/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.installer.provider.installhook;

import java.io.IOException;
import java.io.InputStream;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Dictionary;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.jar.JarInputStream;
import java.util.jar.Manifest;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import org.apache.commons.lang3.StringUtils;
import org.apache.jackrabbit.vault.fs.api.ProgressTrackerListener;
import org.apache.jackrabbit.vault.fs.io.Archive;
import org.apache.jackrabbit.vault.fs.io.ImportOptions;
import org.apache.jackrabbit.vault.packaging.InstallContext;
import org.apache.jackrabbit.vault.packaging.InstallHook;
import org.apache.jackrabbit.vault.packaging.PackageException;
import org.apache.jackrabbit.vault.packaging.PackageProperties;
import org.apache.jackrabbit.vault.packaging.VaultPackage;
import org.apache.sling.installer.api.InstallableResource;
import org.apache.sling.installer.api.OsgiInstaller;
import org.apache.sling.installer.api.event.InstallationEvent;
import org.apache.sling.installer.api.event.InstallationListener;
import org.apache.sling.installer.api.info.InfoProvider;
import org.apache.sling.installer.api.info.InstallationState;
import org.apache.sling.installer.api.info.Resource;
import org.apache.sling.installer.api.info.ResourceGroup;
import org.apache.sling.installer.api.tasks.ResourceState;
import org.apache.sling.installer.api.tasks.TaskResource;
import org.apache.sling.installer.provider.installhook.OsgiInstallerListener;
import org.apache.sling.settings.SlingSettingsService;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleEvent;
import org.osgi.framework.BundleListener;
import org.osgi.framework.FrameworkUtil;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceEvent;
import org.osgi.framework.ServiceListener;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.ServiceRegistration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OsgiInstallerHook
implements InstallHook {
    private static final Logger LOG = LoggerFactory.getLogger(OsgiInstallerHook.class);
    private static final String PACKAGE_PROP_INSTALL_PATH_REGEX = "installPathRegex";
    private static final String PACKAGE_PROPERTY_MAX_WAIT_IN_SEC = "maxWaitForOsgiInstallerInSec";
    private static final String PACKAGE_PROPERTY_INSTALL_PRIORITY = "osgiInstallerPriority";
    private static final String PACKAGE_PROPERTY_WAIT_FOR_OSGI_EVENTS_QUIET_IN_SEC = "waitForOsgiEventsQuietInSec";
    public static final int DEFAULT_PRIORITY_INSTALL_HOOK = 2000;
    private static final int DEFAULT_MAX_WAIT_IN_SEC = 60;
    private static final int DEFAULT_WAIT_FOR_OSGI_EVENTS_QUIET_IN_SEC = 1;
    public static final String URL_SCHEME = "jcrinstall";
    public static final String CONFIG_SUFFIX = ".config";
    public static final String JAR_SUFFIX = ".jar";
    private static final String ENTITY_ID_PREFIX_BUNDLE = "bundle:";
    private static final String MANIFEST_BUNDLE_SYMBOLIC_NAME = "Bundle-SymbolicName";
    private static final String MANIFEST_BUNDLE_VERSION = "Bundle-Version";
    private static final String FOLDER_META_INF = "META-INF";
    static final String JCR_CONTENT = "jcr:content";
    static final String JCR_CONTENT_DATA = "jcr:content/jcr:data";
    static final String JCR_LAST_MODIFIED = "jcr:lastModified";
    static final String JCR_CONTENT_LAST_MODIFIED = "jcr:content/jcr:lastModified";
    public static final String DOT = ".";
    InstallHookLogger logger = new InstallHookLogger();

    public OsgiInstallerHook() {
        LOG.debug("Preloading classes to ensure to not run into a NoClassDefFoundError due to a reloading dynamic classloader: {}, {}, {}, {}", new Object[]{TaskResource.class, InstallationEvent.TYPE.class, ResourceState.class, InstallerHookOsgiEventListener.class});
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void execute(InstallContext context) throws PackageException {
        ServiceReference infoProviderServiceRef;
        ServiceRegistration hookInstallationListenerServiceRegistration;
        ServiceReference slingSettingsServiceRef;
        ServiceReference osgiInstallerServiceRef;
        block20: {
            VaultPackage vaultPackage = context.getPackage();
            PackageProperties packageProperties = vaultPackage.getProperties();
            String installPathRegex = packageProperties.getProperty(PACKAGE_PROP_INSTALL_PATH_REGEX);
            osgiInstallerServiceRef = null;
            slingSettingsServiceRef = null;
            hookInstallationListenerServiceRegistration = null;
            infoProviderServiceRef = null;
            try {
                switch (context.getPhase()) {
                    case PREPARE: {
                        if (!StringUtils.isBlank((CharSequence)installPathRegex)) return;
                        throw new IllegalArgumentException("When using OSGi installer install hook for synchronous installation, the package property installPathRegex has to be provided.");
                    }
                    case INSTALLED: {
                        ImportOptions options = context.getOptions();
                        this.logger.setOptions(options);
                        this.logger.log(this.getClass().getSimpleName() + " is active in " + vaultPackage.getId());
                        ArrayList<BundleInPackage> bundleResources = new ArrayList<BundleInPackage>();
                        ArrayList<String> configResourcePaths = new ArrayList<String>();
                        Archive archive = vaultPackage.getArchive();
                        infoProviderServiceRef = this.getBundleContext().getServiceReference(InfoProvider.class);
                        InfoProvider infoProvider = (InfoProvider)this.getBundleContext().getService(infoProviderServiceRef);
                        InstallationState installationState = infoProvider.getInstallationState();
                        slingSettingsServiceRef = this.getBundleContext().getServiceReference(SlingSettingsService.class);
                        SlingSettingsService slingSettingsService = (SlingSettingsService)this.getBundleContext().getService(slingSettingsServiceRef);
                        Set runModes = slingSettingsService.getRunModes();
                        this.collectResources(archive, archive.getRoot(), "", bundleResources, configResourcePaths, installPathRegex, runModes);
                        this.logger.log("Bundles in package " + bundleResources);
                        Session session = context.getSession();
                        Map<String, InstallableResource> bundlesToInstallByUrl = this.getBundlesToInstall(bundleResources, session, installationState, packageProperties);
                        Map<String, InstallableResource> configsToInstallByUrl = this.getConfigsToInstall(configResourcePaths, session, installationState, packageProperties);
                        if (bundlesToInstallByUrl.isEmpty() && configsToInstallByUrl.isEmpty()) {
                            this.logger.log("No installable resources that are not installed yet found.");
                            if (osgiInstallerServiceRef == null) break block20;
                            break;
                        }
                        this.logger.log("Installing " + bundlesToInstallByUrl.size() + " bundles and " + configsToInstallByUrl.size() + " configs");
                        osgiInstallerServiceRef = this.getBundleContext().getServiceReference(OsgiInstaller.class);
                        OsgiInstaller osgiInstaller = (OsgiInstaller)this.getBundleContext().getService(osgiInstallerServiceRef);
                        OsgiInstallerListener hookInstallationListener = new OsgiInstallerListener(bundlesToInstallByUrl.keySet(), configsToInstallByUrl.keySet());
                        hookInstallationListenerServiceRegistration = this.getBundleContext().registerService(InstallationListener.class, (Object)hookInstallationListener, null);
                        ArrayList<InstallableResource> resourcesToUpdate = new ArrayList<InstallableResource>();
                        resourcesToUpdate.addAll(bundlesToInstallByUrl.values());
                        resourcesToUpdate.addAll(configsToInstallByUrl.values());
                        this.logger.log("Updating resources " + resourcesToUpdate);
                        osgiInstaller.updateResources(URL_SCHEME, resourcesToUpdate.toArray(new InstallableResource[resourcesToUpdate.size()]), null);
                        int maxWaitForOsgiInstallerInSec = this.getNumericPackageProperty(packageProperties, PACKAGE_PROPERTY_MAX_WAIT_IN_SEC, 60);
                        long startTime = System.currentTimeMillis();
                        int bundlesLeftToInstall = 0;
                        int configsLeftToInstall = 0;
                        while ((bundlesLeftToInstall = hookInstallationListener.bundlesLeftToInstall()) > 0 || (configsLeftToInstall = hookInstallationListener.configsLeftToInstall()) > 0) {
                            if (System.currentTimeMillis() - startTime > (long)(maxWaitForOsgiInstallerInSec * 1000)) {
                                this.logger.log("Installable resources " + resourcesToUpdate + " could not be installed even after waiting " + maxWaitForOsgiInstallerInSec + "sec");
                                break;
                            }
                            this.logger.log("Waiting for " + bundlesLeftToInstall + " bundles / " + configsLeftToInstall + " configs to be installed");
                            Thread.sleep(1000L);
                            hookInstallationListener.updateWith(infoProvider.getInstallationState().getInstalledResources());
                        }
                        if (bundlesLeftToInstall == 0 && configsLeftToInstall == 0) {
                            this.logger.log("All " + bundlesToInstallByUrl.size() + " bundles / " + configsToInstallByUrl.size() + " configs have been successfully installed in " + (System.currentTimeMillis() - startTime) + "ms");
                        }
                        int waitForOsgiEventsQuietInSec = this.getNumericPackageProperty(packageProperties, PACKAGE_PROPERTY_WAIT_FOR_OSGI_EVENTS_QUIET_IN_SEC, 1);
                        this.waitForServiceChanges(waitForOsgiEventsQuietInSec);
                        return;
                    }
                    default: {
                        return;
                    }
                }
            }
            catch (Exception e) {
                throw new PackageException("Could not execute install hook to for synchronous installation: " + e, (Throwable)e);
            }
            this.getBundleContext().ungetService(osgiInstallerServiceRef);
        }
        if (slingSettingsServiceRef != null) {
            this.getBundleContext().ungetService(slingSettingsServiceRef);
        }
        if (infoProviderServiceRef != null) {
            this.getBundleContext().ungetService(infoProviderServiceRef);
        }
        if (hookInstallationListenerServiceRegistration == null) return;
        hookInstallationListenerServiceRegistration.unregister();
        return;
        finally {
            if (osgiInstallerServiceRef != null) {
                this.getBundleContext().ungetService(osgiInstallerServiceRef);
            }
            if (slingSettingsServiceRef != null) {
                this.getBundleContext().ungetService(slingSettingsServiceRef);
            }
            if (infoProviderServiceRef != null) {
                this.getBundleContext().ungetService(infoProviderServiceRef);
            }
            if (hookInstallationListenerServiceRegistration != null) {
                hookInstallationListenerServiceRegistration.unregister();
            }
        }
    }

    private int getNumericPackageProperty(PackageProperties packageProperties, String propertyName, int defaultVal) {
        String strVal = packageProperties.getProperty(propertyName);
        int intVal = strVal != null ? Integer.parseInt(strVal) : defaultVal;
        return intVal;
    }

    private Map<String, InstallableResource> getBundlesToInstall(List<BundleInPackage> bundlesInPackage, Session session, InstallationState installationState, PackageProperties packageProperties) throws RepositoryException, IOException {
        HashMap<String, InstallableResource> installableResources = new HashMap<String, InstallableResource>();
        for (BundleInPackage bundle : bundlesInPackage) {
            List<Resource> currentInstallerBundleResources = this.getBundleResources(installationState, bundle.symbolicName);
            boolean needsInstallation = false;
            if (currentInstallerBundleResources.isEmpty()) {
                needsInstallation = true;
            } else if (currentInstallerBundleResources.size() == 1) {
                Resource resource = currentInstallerBundleResources.get(0);
                if (resource.getState() == ResourceState.INSTALLED) {
                    String currentlyActiveBundleVersion = resource.getVersion().toString();
                    if (!StringUtils.startsWith((CharSequence)currentlyActiveBundleVersion, (CharSequence)bundle.version)) {
                        this.logger.log("Bundle " + bundle.symbolicName + " is installed with version " + currentlyActiveBundleVersion + " but package contains version " + bundle.version);
                        needsInstallation = true;
                    } else {
                        this.logger.log("Bundle " + bundle.symbolicName + " is already installed with version " + currentlyActiveBundleVersion + " that matches " + bundle.version + " as provided in package");
                    }
                } else {
                    String msg = MessageFormat.format("Bundle {0} is not in state INSTALLED but in {1}", bundle.symbolicName, resource.getState());
                    if (StringUtils.isNotEmpty((CharSequence)resource.getError())) {
                        msg = msg + " due to error '" + resource.getError() + "'";
                    }
                    this.logger.log(msg);
                    needsInstallation = true;
                }
            } else {
                this.logger.log("Bundle " + bundle.symbolicName + " exists with multiple installer resources");
                boolean installedBundleResourceFound = false;
                for (Resource resource : currentInstallerBundleResources) {
                    this.logger.log("Resource " + resource);
                    if (resource.getState() != ResourceState.INSTALLED || !StringUtils.equals((CharSequence)resource.getVersion().toString(), (CharSequence)bundle.version)) continue;
                    installedBundleResourceFound = true;
                }
                if (!installedBundleResourceFound) {
                    needsInstallation = true;
                }
            }
            if (!needsInstallation) continue;
            this.logger.log("Bundle " + bundle.symbolicName + " requires installation");
            Node node = session.getNode(bundle.path);
            InstallableResource installableResource = this.convert(node, bundle.path, packageProperties);
            String bundleUrl = "jcrinstall:" + bundle.path;
            installableResources.put(bundleUrl, installableResource);
        }
        return installableResources;
    }

    private List<Resource> getBundleResources(InstallationState installationState, String symbolicId) {
        ArrayList<Resource> bundleResources = new ArrayList<Resource>();
        ArrayList allGroups = new ArrayList();
        allGroups.addAll(installationState.getInstalledResources());
        allGroups.addAll(installationState.getActiveResources());
        for (ResourceGroup resourceGroup : allGroups) {
            List resources = resourceGroup.getResources();
            for (Resource resource : resources) {
                if (!StringUtils.equals((CharSequence)resource.getEntityId(), (CharSequence)(ENTITY_ID_PREFIX_BUNDLE + symbolicId))) continue;
                bundleResources.add(resource);
            }
        }
        return bundleResources;
    }

    private Map<String, InstallableResource> getConfigsToInstall(List<String> configResourcePaths, Session session, InstallationState installationState, PackageProperties packageProperties) throws IOException, InvalidSyntaxException, RepositoryException {
        HashMap<String, InstallableResource> configsToInstallByUrl = new HashMap<String, InstallableResource>();
        for (String configResourcePath : configResourcePaths) {
            boolean needsInstallation = false;
            String configUrl = "jcrinstall:" + configResourcePath;
            boolean configFound = false;
            List installedResources = installationState.getInstalledResources();
            for (ResourceGroup resourceGroup : installedResources) {
                for (Resource resource : resourceGroup.getResources()) {
                    if (!StringUtils.equals((CharSequence)configUrl, (CharSequence)resource.getURL())) continue;
                    configFound = true;
                    this.logger.log("Config " + configResourcePath + " is already installed");
                }
            }
            if (!configFound) {
                this.logger.log("Config " + configResourcePath + " has not been installed");
                needsInstallation = true;
            }
            if (!needsInstallation) continue;
            Node node = session.getNode(configResourcePath);
            InstallableResource installableResource = this.convert(node, configResourcePath, packageProperties);
            configsToInstallByUrl.put(configUrl, installableResource);
        }
        return configsToInstallByUrl;
    }

    void collectResources(Archive archive, Archive.Entry entry, String dirPath, List<BundleInPackage> bundleResources, List<String> configResources, String installPathRegex, Set<String> actualRunmodes) {
        boolean runmodesMatch;
        Object runmodesOfResource;
        String entryName = entry.getName();
        if (entryName.equals(FOLDER_META_INF)) {
            return;
        }
        String dirPathWithoutJcrRoot = StringUtils.substringAfter((String)dirPath, (String)"/jcr_root");
        String entryPath = dirPathWithoutJcrRoot + entryName;
        String dirPathWithoutSlash = StringUtils.chomp((String)dirPathWithoutJcrRoot, (String)"/");
        if (dirPathWithoutSlash.contains(DOT)) {
            String[] bits = dirPathWithoutSlash.split("\\.", 2);
            runmodesOfResource = Arrays.asList(bits[1].split("\\."));
            HashSet<String> matchingRunmodes = new HashSet<String>((Collection<String>)runmodesOfResource);
            matchingRunmodes.retainAll(actualRunmodes);
            LOG.debug("Entry with runmode(s): entryPath={} runmodesOfResource={} actualRunmodes={} matchingRunmodes={}", new Object[]{entryPath, runmodesOfResource, actualRunmodes, matchingRunmodes});
            boolean bl = runmodesMatch = matchingRunmodes.size() == runmodesOfResource.size();
            if (!runmodesMatch) {
                this.logger.log("Skipping installation of  " + entryPath + " because the path is not matching all actual runmodes " + actualRunmodes);
            }
        } else {
            runmodesMatch = true;
        }
        if (entryPath.matches(installPathRegex) && runmodesMatch) {
            if (entryName.endsWith(CONFIG_SUFFIX)) {
                configResources.add(entryPath);
            } else if (entryName.endsWith(JAR_SUFFIX)) {
                try {
                    InputStream entryInputStream = archive.getInputSource(entry).getByteStream();
                    runmodesOfResource = null;
                    try (JarInputStream jarInputStream = new JarInputStream(entryInputStream);){
                        Manifest manifest = jarInputStream.getManifest();
                        String symbolicName = manifest.getMainAttributes().getValue(MANIFEST_BUNDLE_SYMBOLIC_NAME);
                        String version = manifest.getMainAttributes().getValue(MANIFEST_BUNDLE_VERSION);
                        bundleResources.add(new BundleInPackage(entryPath, symbolicName, version));
                    }
                    catch (Throwable throwable) {
                        runmodesOfResource = throwable;
                        throw throwable;
                    }
                    finally {
                        if (entryInputStream != null) {
                            if (runmodesOfResource != null) {
                                try {
                                    entryInputStream.close();
                                }
                                catch (Throwable x2) {
                                    ((Throwable)runmodesOfResource).addSuppressed(x2);
                                }
                            } else {
                                entryInputStream.close();
                            }
                        }
                    }
                }
                catch (Exception e) {
                    throw new IllegalStateException("Could not read symbolic name and version from manifest of bundle " + entryName);
                }
            }
        }
        for (Archive.Entry child : entry.getChildren()) {
            this.collectResources(archive, child, dirPath + entryName + "/", bundleResources, configResources, installPathRegex, actualRunmodes);
        }
    }

    InstallableResource convert(Node node, String path, PackageProperties packageProperties) throws IOException, RepositoryException {
        LOG.trace("Converting {} at path {}", (Object)node, (Object)path);
        String digest = String.valueOf(node.getProperty(JCR_CONTENT_LAST_MODIFIED).getDate().getTimeInMillis());
        InputStream is = node.getProperty(JCR_CONTENT_DATA).getBinary().getStream();
        Hashtable<String, String> dict = new Hashtable<String, String>();
        ((Dictionary)dict).put("installation.hint", node.getParent().getName());
        int priority = this.getNumericPackageProperty(packageProperties, PACKAGE_PROPERTY_INSTALL_PRIORITY, 2000);
        return new InstallableResource(path, is, dict, digest, null, Integer.valueOf(priority));
    }

    private void waitForServiceChanges(int waitForOsgiEventsQuietInSec) {
        if (waitForOsgiEventsQuietInSec <= 0) {
            return;
        }
        InstallerHookOsgiEventListener osgiListener = new InstallerHookOsgiEventListener();
        BundleContext bundleContext = this.getBundleContext();
        bundleContext.addServiceListener((ServiceListener)osgiListener);
        bundleContext.addBundleListener((BundleListener)osgiListener);
        long waitStart = System.currentTimeMillis();
        osgiListener.waitUntilQuiet(waitForOsgiEventsQuietInSec);
        this.logger.log("Waited " + (System.currentTimeMillis() - waitStart) + "ms in total for OSGi events to become quiet (for at least " + waitForOsgiEventsQuietInSec + "sec)");
        bundleContext.removeServiceListener((ServiceListener)osgiListener);
        bundleContext.removeBundleListener((BundleListener)osgiListener);
    }

    private BundleContext getBundleContext() {
        Bundle currentBundle = FrameworkUtil.getBundle(InstallHook.class);
        if (currentBundle == null) {
            throw new IllegalStateException("The class " + InstallHook.class + " was not loaded through a bundle classloader");
        }
        BundleContext bundleContext = currentBundle.getBundleContext();
        if (bundleContext == null) {
            throw new IllegalStateException("Could not get bundle context for bundle " + currentBundle);
        }
        return bundleContext;
    }

    static class InstallerHookOsgiEventListener
    implements ServiceListener,
    BundleListener {
        private long lastEventTimestamp = System.currentTimeMillis();

        InstallerHookOsgiEventListener() {
        }

        public void serviceChanged(ServiceEvent event) {
            this.lastEventTimestamp = System.currentTimeMillis();
            LOG.trace("Service changed event {}", (Object)event);
        }

        public void bundleChanged(BundleEvent event) {
            this.lastEventTimestamp = System.currentTimeMillis();
            LOG.trace("Bundle changed event {}", (Object)event);
        }

        public void waitUntilQuiet(long waitInSec) {
            try {
                while (System.currentTimeMillis() - this.lastEventTimestamp < waitInSec * 1000L) {
                    Thread.sleep(100L);
                }
            }
            catch (InterruptedException e) {
                LOG.warn("Wait for OSGi events was interrupted");
            }
        }
    }

    static class InstallHookLogger {
        private ProgressTrackerListener listener;

        InstallHookLogger() {
        }

        public void setOptions(ImportOptions options) {
            this.listener = options.getListener();
        }

        public void logError(Logger logger, String message, Throwable throwable) {
            if (this.listener != null) {
                this.listener.onMessage(ProgressTrackerListener.Mode.TEXT, "ERROR: " + message, "");
            }
            logger.error(message, throwable);
        }

        public void log(String message) {
            this.log(LOG, message);
        }

        public void log(Logger logger, String message) {
            if (this.listener != null) {
                this.listener.onMessage(ProgressTrackerListener.Mode.TEXT, message, "");
            }
            logger.info(message);
        }
    }

    class BundleInPackage {
        final String path;
        final String symbolicName;
        final String version;

        public BundleInPackage(String path, String symbolicName, String version) {
            this.path = path;
            this.symbolicName = symbolicName;
            this.version = version;
        }

        public String toString() {
            return "BundleInPackage [path=" + this.path + ", symbolicId=" + this.symbolicName + ", version=" + this.version + "]";
        }
    }
}

