/*
 * Decompiled with CFR 0.152.
 */
package biz.netcentric.cq.tools.actool.aceinstaller;

import biz.netcentric.cq.tools.actool.aceinstaller.AceBeanInstaller;
import biz.netcentric.cq.tools.actool.aceinstaller.BaseAceBeanInstaller;
import biz.netcentric.cq.tools.actool.aem.AemCqActionsSupport;
import biz.netcentric.cq.tools.actool.configmodel.AceBean;
import biz.netcentric.cq.tools.actool.helper.AccessControlUtils;
import biz.netcentric.cq.tools.actool.helper.RestrictionsHolder;
import biz.netcentric.cq.tools.actool.history.InstallationLogger;
import java.security.Principal;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.UnsupportedRepositoryOperationException;
import javax.jcr.security.AccessControlEntry;
import javax.jcr.security.AccessControlException;
import javax.jcr.security.AccessControlManager;
import javax.jcr.security.AccessControlPolicy;
import javax.jcr.security.Privilege;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.jackrabbit.api.security.JackrabbitAccessControlEntry;
import org.apache.jackrabbit.api.security.JackrabbitAccessControlList;
import org.apache.jackrabbit.oak.spi.security.principal.PrincipalImpl;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.osgi.service.component.annotations.ReferencePolicyOption;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component
public class AceBeanInstallerClassic
extends BaseAceBeanInstaller
implements AceBeanInstaller {
    private static final Logger LOG = LoggerFactory.getLogger(AceBeanInstallerClassic.class);
    @Reference(cardinality=ReferenceCardinality.OPTIONAL, policy=ReferencePolicy.DYNAMIC, policyOption=ReferencePolicyOption.GREEDY)
    volatile AemCqActionsSupport aemCqActionsSupport;

    @Override
    protected void installAcl(Set<AceBean> aceBeanSetFromConfig, String path, Set<String> principalsToRemoveAcesFor, Session session, InstallationLogger installLog) throws RepositoryException {
        int countRemoved = AccessControlUtils.deleteAllEntriesForPrincipalsFromACL(session, path, principalsToRemoveAcesFor.toArray(new String[principalsToRemoveAcesFor.size()]));
        installLog.addVerboseMessage(LOG, "Deleted " + countRemoved + " ACEs for configured principals from path " + path);
        for (AceBean bean : aceBeanSetFromConfig) {
            LOG.debug("Writing bean to repository {}", (Object)bean);
            PrincipalImpl currentPrincipal = new PrincipalImpl(bean.getPrincipalName());
            this.installAce(bean, session, (Principal)currentPrincipal, installLog);
        }
        installLog.incCountAclsChanged();
    }

    private void installAce(AceBean aceBean, Session session, Principal principal, InstallationLogger installLog) throws RepositoryException {
        if (aceBean.isInitialContentOnlyConfig()) {
            return;
        }
        AccessControlManager acMgr = session.getAccessControlManager();
        JackrabbitAccessControlList acl = AccessControlUtils.getModifiableAcl(acMgr, aceBean.getJcrPathForPolicyApi());
        if (acl == null) {
            installLog.addMessage(LOG, "Skipped installing privileges/actions for non existing path: " + aceBean.getJcrPath());
            return;
        }
        JackrabbitAccessControlList newAcl = this.installActions(aceBean, principal, acl, session, acMgr, installLog);
        if (acl != newAcl) {
            installLog.addVerboseMessage(LOG, "Added action(s) for path: " + aceBean.getJcrPath() + ", principal: " + principal.getName() + ", actions: " + aceBean.getActionsString() + ", allow: " + aceBean.isAllow());
            this.removeRedundantPrivileges(aceBean, session);
            acl = newAcl;
        }
        if (this.installPrivileges(aceBean, principal, acl, session, acMgr)) {
            installLog.addVerboseMessage(LOG, "Added privilege(s) for path: " + aceBean.getJcrPath() + ", principal: " + principal.getName() + ", privileges: " + aceBean.getPrivilegesString() + ", allow: " + aceBean.isAllow());
        }
        if (!acl.isEmpty()) {
            acMgr.setPolicy(aceBean.getJcrPathForPolicyApi(), (AccessControlPolicy)acl);
        } else {
            acMgr.removePolicy(aceBean.getJcrPathForPolicyApi(), (AccessControlPolicy)acl);
        }
    }

    private JackrabbitAccessControlList installActions(AceBean aceBean, Principal principal, JackrabbitAccessControlList acl, Session session, AccessControlManager acMgr, InstallationLogger installLog) throws RepositoryException {
        Map<String, Boolean> actionMap = aceBean.getActionMap();
        if (actionMap.isEmpty()) {
            return acl;
        }
        if (this.aemCqActionsSupport == null) {
            throw new IllegalArgumentException("actions can only be used when using AC Tool in AEM (package com.day.cq.security.util with class CqActions is not available)");
        }
        AemCqActionsSupport.AemCqActions cqActions = this.aemCqActionsSupport.getCqActions(session);
        Collection<String> inheritedAllows = cqActions.getAllowedActions(aceBean.getJcrPathForPolicyApi(), Collections.singleton(principal));
        cqActions.installActions(aceBean.getJcrPathForPolicyApi(), principal, actionMap, inheritedAllows);
        JackrabbitAccessControlList newAcl = AccessControlUtils.getAccessControlList(session, aceBean.getJcrPath());
        RestrictionsHolder restrictions = this.getRestrictions(aceBean, session, acl);
        if (!aceBean.getRestrictions().isEmpty()) {
            this.addAdditionalRestriction(aceBean, acl, newAcl, restrictions);
        }
        return newAcl;
    }

    private void addAdditionalRestriction(AceBean aceBean, JackrabbitAccessControlList oldAcl, JackrabbitAccessControlList newAcl, RestrictionsHolder restrictions) throws RepositoryException {
        List<AccessControlEntry> changedAces = this.getModifiedAces(oldAcl, newAcl);
        if (!changedAces.isEmpty()) {
            for (AccessControlEntry newAce : changedAces) {
                this.addRestrictionIfNotSet(newAcl, restrictions, newAce);
            }
        } else {
            AccessControlEntry lastNewAce;
            AccessControlEntry lastOldAce = oldAcl.getAccessControlEntries()[oldAcl.getAccessControlEntries().length - 1];
            if (lastOldAce.equals(lastNewAce = newAcl.getAccessControlEntries()[newAcl.getAccessControlEntries().length - 1]) && lastNewAce.getPrincipal().getName().equals(aceBean.getPrincipalName())) {
                this.addRestrictionIfNotSet(newAcl, restrictions, lastNewAce);
            } else {
                throw new IllegalStateException("No new entries have been set for AccessControlList at " + aceBean.getJcrPath());
            }
        }
    }

    private void addRestrictionIfNotSet(JackrabbitAccessControlList newAcl, RestrictionsHolder restrictions, AccessControlEntry newAce) throws RepositoryException, AccessControlException, UnsupportedRepositoryOperationException, SecurityException {
        if (!(newAce instanceof JackrabbitAccessControlEntry)) {
            throw new IllegalStateException("Can not deal with non JackrabbitAccessControlEntrys, but entry is of type " + newAce.getClass().getName());
        }
        JackrabbitAccessControlEntry ace = (JackrabbitAccessControlEntry)newAce;
        if (ace.getRestrictionNames().length == 0) {
            this.extendExistingAceWithRestrictions(newAcl, ace, restrictions);
        }
    }

    private List<AccessControlEntry> getModifiedAces(JackrabbitAccessControlList oldAcl, JackrabbitAccessControlList newAcl) throws RepositoryException {
        List<AccessControlEntry> oldAces = Arrays.asList(oldAcl.getAccessControlEntries());
        List<AccessControlEntry> newAces = Arrays.asList(newAcl.getAccessControlEntries());
        return (List)CollectionUtils.subtract(newAces, oldAces);
    }

    private void removeRedundantPrivileges(AceBean aceBean, Session session) throws RepositoryException {
        Set<String> cleanedPrivileges = this.removeRedundantPrivileges(session, aceBean.getPrivileges(), aceBean.getActions());
        aceBean.setPrivilegesString(StringUtils.join(cleanedPrivileges, (String)","));
    }

    private Set<String> removeRedundantPrivileges(Session session, String[] privileges, String[] actions) throws RepositoryException {
        AemCqActionsSupport.AemCqActions cqActions = this.aemCqActionsSupport.getCqActions(session);
        HashSet<String> cleanedPrivileges = new HashSet<String>();
        if (privileges == null) {
            return cleanedPrivileges;
        }
        cleanedPrivileges.addAll(Arrays.asList(privileges));
        if (actions == null) {
            return cleanedPrivileges;
        }
        for (String action : actions) {
            Set<Privilege> coveredPrivileges = cqActions.getPrivileges(action);
            for (Privilege coveredPrivilege : coveredPrivileges) {
                cleanedPrivileges.remove(coveredPrivilege.getName());
            }
        }
        return cleanedPrivileges;
    }

    private void extendExistingAceWithRestrictions(JackrabbitAccessControlList accessControlList, JackrabbitAccessControlEntry accessControlEntry, RestrictionsHolder restrictions) throws SecurityException, UnsupportedRepositoryOperationException, RepositoryException {
        if (!accessControlList.addEntry(accessControlEntry.getPrincipal(), accessControlEntry.getPrivileges(), accessControlEntry.isAllow(), restrictions.getSingleValuedRestrictionsMap(), restrictions.getMultiValuedRestrictionsMap())) {
            throw new IllegalStateException("Could not add entry, probably because it was already there!");
        }
        AccessControlEntry newAccessControlEntry = accessControlList.getAccessControlEntries()[accessControlList.size() - 1];
        accessControlList.orderBefore(newAccessControlEntry, (AccessControlEntry)accessControlEntry);
        accessControlList.removeAccessControlEntry((AccessControlEntry)accessControlEntry);
    }
}

