/*
 * Decompiled with CFR 0.152.
 */
package biz.netcentric.cq.tools.actool.aceinstaller;

import biz.netcentric.cq.tools.actool.aceinstaller.AceBeanInstaller;
import biz.netcentric.cq.tools.actool.comparators.AcePermissionComparator;
import biz.netcentric.cq.tools.actool.configmodel.AcConfiguration;
import biz.netcentric.cq.tools.actool.configmodel.AceBean;
import biz.netcentric.cq.tools.actool.configmodel.Restriction;
import biz.netcentric.cq.tools.actool.helper.AccessControlUtils;
import biz.netcentric.cq.tools.actool.helper.ContentHelper;
import biz.netcentric.cq.tools.actool.helper.RestrictionsHolder;
import biz.netcentric.cq.tools.actool.helper.runtime.RuntimeHelper;
import biz.netcentric.cq.tools.actool.history.InstallationLogger;
import biz.netcentric.cq.tools.actool.history.PersistableInstallationLogger;
import java.security.Principal;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.UnsupportedRepositoryOperationException;
import javax.jcr.ValueFormatException;
import javax.jcr.security.AccessControlManager;
import javax.jcr.security.Privilege;
import org.apache.commons.lang3.time.StopWatch;
import org.apache.jackrabbit.api.security.JackrabbitAccessControlList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BaseAceBeanInstaller
implements AceBeanInstaller {
    private static final Logger LOG = LoggerFactory.getLogger(BaseAceBeanInstaller.class);

    @Override
    public void installPathBasedACEs(Map<String, Set<AceBean>> pathBasedAceMapFromConfig, AcConfiguration acConfiguration, Session session, InstallationLogger history, Set<String> principalsToRemoveAcesFor, boolean intermediateSaves) throws Exception {
        StopWatch stopWatch = new StopWatch();
        stopWatch.start();
        Set<String> paths = pathBasedAceMapFromConfig.keySet();
        history.addVerboseMessage(LOG, "Found " + paths.size() + "  paths in config");
        LOG.trace("Paths with ACEs: {}", paths);
        paths = this.filterReadOnlyPaths(paths, history, session);
        if (intermediateSaves) {
            history.addMessage(LOG, "Will save ACL for each path to session due to configuration option intermediateSaves=true - rollback functionality is disabled.");
        }
        for (String path : paths) {
            boolean pathExits;
            Set<AceBean> aceBeanSetFromConfig = pathBasedAceMapFromConfig.get(path);
            boolean bl = pathExits = AccessControlUtils.getModifiableAcl(session.getAccessControlManager(), path) != null;
            if (!pathExits && !ContentHelper.createInitialContent(session, history, path, aceBeanSetFromConfig)) {
                history.addVerboseMessage(LOG, "Skipped installing privileges/actions for non existing path: " + path);
                history.incCountAclsPathDoesNotExist();
                continue;
            }
            TreeSet<AceBean> orderedAceBeanSetFromConfig = new TreeSet<AceBean>(new AcePermissionComparator());
            orderedAceBeanSetFromConfig.addAll(aceBeanSetFromConfig);
            Set<String> principalsToRemoveAcesForAtThisPath = acConfiguration.getAuthorizablesConfig().removeUnmanagedPrincipalNamesAtPath(path, principalsToRemoveAcesFor, acConfiguration.getGlobalConfiguration().getDefaultUnmanagedAcePathsRegex());
            this.installAcl(orderedAceBeanSetFromConfig, path, principalsToRemoveAcesForAtThisPath, session, history);
            if (!intermediateSaves || !session.hasPendingChanges()) continue;
            history.addVerboseMessage(LOG, "Saved session for path " + path);
            session.save();
        }
        if (history.getMissingParentPathsForInitialContent() > 0) {
            history.addWarning(LOG, "There were " + history.getMissingParentPathsForInitialContent() + " parent paths missing for creation of initial content (those paths were skipped, see verbose log for details)");
        }
        history.addMessage(LOG, "ACL Update Statistics: Changed=" + history.getCountAclsChanged() + " Unchanged=" + history.getCountAclsUnchanged() + " Path not found=" + history.getCountAclsPathDoesNotExist() + " (action cache hit/miss=" + history.getCountActionCacheHit() + "/" + history.getCountActionCacheMiss() + ")");
        history.addMessage(LOG, "*** Finished installation of " + paths.size() + " ACLs in " + PersistableInstallationLogger.msHumanReadable(stopWatch.getTime()));
    }

    private Set<String> filterReadOnlyPaths(Set<String> paths, InstallationLogger history, Session session) {
        boolean isCompositeNodeStore = RuntimeHelper.isCompositeNodeStore(session);
        if (isCompositeNodeStore) {
            TreeSet<String> pathsToKeep = new TreeSet<String>();
            TreeSet<String> readOnlyPaths = new TreeSet<String>();
            for (String path : paths) {
                if (path != null && (path.startsWith("/apps") || path.startsWith("/libs"))) {
                    readOnlyPaths.add(path);
                    continue;
                }
                pathsToKeep.add(path);
            }
            history.addMessage(LOG, "Ignoring " + readOnlyPaths.size() + " ACLs in /apps and /libs because they are ready-only (Composite NodeStore)");
            return pathsToKeep;
        }
        return paths;
    }

    protected abstract void installAcl(Set<AceBean> var1, String var2, Set<String> var3, Session var4, InstallationLogger var5) throws RepositoryException;

    protected boolean installPrivileges(AceBean aceBean, Principal principal, JackrabbitAccessControlList acl, Session session, AccessControlManager acMgr) throws RepositoryException {
        Set<Privilege> privileges = this.getPrivilegeSet(aceBean.getPrivileges(), acMgr);
        if (!privileges.isEmpty()) {
            RestrictionsHolder restrictions = this.getRestrictions(aceBean, session, acl);
            if (!restrictions.isEmpty()) {
                acl.addEntry(principal, privileges.toArray(new Privilege[privileges.size()]), aceBean.isAllow(), restrictions.getSingleValuedRestrictionsMap(), restrictions.getMultiValuedRestrictionsMap());
            } else {
                acl.addEntry(principal, privileges.toArray(new Privilege[privileges.size()]), aceBean.isAllow());
            }
            return true;
        }
        return false;
    }

    protected RestrictionsHolder getRestrictions(AceBean aceBean, Session session, JackrabbitAccessControlList acl) throws ValueFormatException, UnsupportedRepositoryOperationException, RepositoryException {
        List<String> supportedRestrictionNames = Arrays.asList(acl.getRestrictionNames());
        if (aceBean.getRestrictions().isEmpty()) {
            return RestrictionsHolder.empty();
        }
        List<Restriction> restrictions = aceBean.getRestrictions();
        for (Restriction restriction : restrictions) {
            if (supportedRestrictionNames.contains(restriction.getName())) continue;
            throw new IllegalStateException("The AccessControlList at " + acl.getPath() + " does not support setting " + restriction.getName() + " restrictions!");
        }
        RestrictionsHolder restrictionsHolder = new RestrictionsHolder(restrictions, session.getValueFactory(), acl);
        return restrictionsHolder;
    }

    public Set<Privilege> getPrivilegeSet(String[] privNames, AccessControlManager acMgr) throws RepositoryException {
        if (privNames == null) {
            return Collections.emptySet();
        }
        HashSet<Privilege> privileges = new HashSet<Privilege>(privNames.length);
        for (String name : privNames) {
            Privilege p = acMgr.privilegeFromName(name);
            if (p.isAggregate()) {
                privileges.addAll(Arrays.asList(p.getAggregatePrivileges()));
                continue;
            }
            privileges.add(p);
        }
        return privileges;
    }
}

