/*
 * Decompiled with CFR 0.152.
 */
package biz.netcentric.cq.tools.actool.configmodel;

import biz.netcentric.cq.tools.actool.configmodel.AuthorizableConfigBean;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;

public class AuthorizablesConfig
extends LinkedHashSet<AuthorizableConfigBean> {
    private static final long serialVersionUID = -253685832563496002L;

    public AuthorizableConfigBean getAuthorizableConfig(String authorizableId) {
        for (AuthorizableConfigBean authorizableConfigBean : this) {
            if (!StringUtils.equals((CharSequence)authorizableConfigBean.getAuthorizableId(), (CharSequence)authorizableId)) continue;
            return authorizableConfigBean;
        }
        return null;
    }

    public AuthorizableConfigBean getAuthorizableConfigByPrincipalName(String principalName) {
        for (AuthorizableConfigBean authorizableConfigBean : this) {
            if (!StringUtils.equals((CharSequence)authorizableConfigBean.getPrincipalName(), (CharSequence)principalName)) continue;
            return authorizableConfigBean;
        }
        return null;
    }

    public Set<String> getAuthorizableIds() {
        LinkedHashSet<String> authorizableIdsFromConfigurations = new LinkedHashSet<String>();
        for (AuthorizableConfigBean authorizableConfigBean : this) {
            authorizableIdsFromConfigurations.add(authorizableConfigBean.getAuthorizableId());
        }
        return authorizableIdsFromConfigurations;
    }

    public Set<String> getPrincipalNames() {
        HashSet<String> principals = new HashSet<String>();
        for (AuthorizableConfigBean authorizableConfigBean : this) {
            principals.add(authorizableConfigBean.getPrincipalName());
        }
        return principals;
    }

    public String getPrincipalNameForAuthorizableId(String authorizableId) {
        String principalName = null;
        for (AuthorizableConfigBean authorizableConfigBean : this) {
            if (!StringUtils.equals((CharSequence)authorizableConfigBean.getAuthorizableId(), (CharSequence)authorizableId)) continue;
            principalName = authorizableConfigBean.getPrincipalName();
            break;
        }
        return principalName;
    }

    public Set<String> removeUnmanagedPrincipalNamesAtPath(String path, Set<String> principals, String defaultUnmanagedAcePathsRegex) {
        HashSet<String> filteredPrincipals = new HashSet<String>();
        for (String principal : principals) {
            AuthorizableConfigBean authorizableConfig = this.getAuthorizableConfigByPrincipalName(principal);
            if (authorizableConfig != null && !authorizableConfig.managesPath(path, defaultUnmanagedAcePathsRegex)) continue;
            filteredPrincipals.add(principal);
        }
        return filteredPrincipals;
    }
}

