/*
 * Decompiled with CFR 0.152.
 */
package biz.netcentric.cq.tools.actool.configmodel;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;

public class AutoCreateTestUsersConfig {
    private static final String KEY_PREFIX = "prefix";
    private static final String KEY_NAME = "name";
    private static final String KEY_EMAIL = "email";
    private static final String KEY_DESCRIPTION = "description";
    private static final String KEY_PASSWORD = "password";
    private static final String KEY_SKIP_FOR_RUNMODES = "skipForRunmodes";
    private static final String KEY_CREATE_FOR_GROUP_NAMES_REG_EX = "createForGroupNamesRegEx";
    private static final String KEY_PATH = "path";
    private static final List<String> DEFAULT_PRODUCTION_RUNMODES = Arrays.asList("prod", "production");
    private final String prefix;
    private final String name;
    private final String description;
    private final String email;
    private final String password;
    private final List<String> skipForRunmodes;
    private final String createForGroupNamesRegEx;
    private final String path;

    public AutoCreateTestUsersConfig(Map map) {
        if (!map.containsKey(KEY_PREFIX)) {
            throw new IllegalArgumentException("When configuring autoCreateTestUsers, prefix is required");
        }
        this.prefix = (String)map.get(KEY_PREFIX);
        this.name = (String)StringUtils.defaultIfEmpty((CharSequence)((String)map.get(KEY_NAME)), null);
        this.description = (String)StringUtils.defaultIfEmpty((CharSequence)((String)map.get(KEY_DESCRIPTION)), null);
        this.email = (String)StringUtils.defaultIfEmpty((CharSequence)((String)map.get(KEY_EMAIL)), null);
        this.password = (String)StringUtils.defaultIfEmpty((CharSequence)((String)map.get(KEY_PASSWORD)), null);
        Object skipForRunmodesObj = map.get(KEY_SKIP_FOR_RUNMODES);
        if (skipForRunmodesObj instanceof List) {
            this.skipForRunmodes = !CollectionUtils.isEmpty((Collection)((List)skipForRunmodesObj)) ? (List)skipForRunmodesObj : DEFAULT_PRODUCTION_RUNMODES;
        } else {
            Object[] skipForRunmodesBits = String.valueOf(skipForRunmodesObj).split(" *, *");
            List<Object> list = this.skipForRunmodes = !ArrayUtils.isEmpty((Object[])skipForRunmodesBits) ? Arrays.asList(skipForRunmodesBits) : DEFAULT_PRODUCTION_RUNMODES;
        }
        if (!map.containsKey(KEY_CREATE_FOR_GROUP_NAMES_REG_EX)) {
            throw new IllegalArgumentException("When configuring autoCreateTestUsers, createForGroupNamesRegEx is required");
        }
        this.createForGroupNamesRegEx = String.valueOf(map.get(KEY_CREATE_FOR_GROUP_NAMES_REG_EX));
        if (!map.containsKey(KEY_PATH)) {
            throw new IllegalArgumentException("When configuring autoCreateTestUsers, path is required");
        }
        this.path = String.valueOf(map.get(KEY_PATH));
    }

    public String getPrefix() {
        return this.prefix;
    }

    public String getPassword() {
        return this.password;
    }

    public List<String> getSkipForRunmodes() {
        return this.skipForRunmodes;
    }

    public String getCreateForGroupNamesRegEx() {
        return this.createForGroupNamesRegEx;
    }

    public String getPath() {
        return this.path;
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public String getEmail() {
        return this.email;
    }
}

