/*
 * Decompiled with CFR 0.152.
 */
package biz.netcentric.cq.tools.actool.configreader;

import biz.netcentric.cq.tools.actool.configreader.ConfigFilesRetriever;
import biz.netcentric.cq.tools.actool.slingsettings.ExtendedSlingSettingsService;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.Session;
import org.apache.commons.io.IOUtils;
import org.apache.jackrabbit.commons.JcrUtils;
import org.apache.jackrabbit.vault.fs.io.Archive;
import org.apache.sling.jcr.api.SlingRepository;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferencePolicyOption;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component
public class ConfigFilesRetrieverImpl
implements ConfigFilesRetriever {
    private static final Logger LOG = LoggerFactory.getLogger(ConfigFilesRetrieverImpl.class);
    @Reference(policyOption=ReferencePolicyOption.GREEDY)
    private ExtendedSlingSettingsService slingSettingsService;
    @Reference(policyOption=ReferencePolicyOption.GREEDY)
    private SlingRepository repository;

    @Override
    public Map<String, String> getConfigFileContentFromNode(String rootPath, Session session) throws Exception {
        Node rootNode = session.getNode(rootPath);
        if (rootNode == null) {
            throw new IllegalArgumentException("No configuration path configured! please check the configuration of AcService!");
        }
        Map<String, String> configurations = this.getConfigurations(new NodeInJcr(rootNode), Collections.emptyList());
        return configurations;
    }

    @Override
    public Map<String, String> getConfigFileContentFromPackage(Archive archive, Collection<String> configFilePatterns) throws Exception {
        Archive.Entry rootEntry = archive.getJcrRoot();
        if (rootEntry == null) {
            throw new IllegalStateException("Invalid package: It does not contain a JCR root element");
        }
        Map<String, String> configurations = this.getConfigurations(new EntryInPackage(archive, "", rootEntry), configFilePatterns);
        return configurations;
    }

    private Map<String, String> getConfigurations(PackageEntryOrNode configFileOrDir, Collection<String> configFilePatterns) throws Exception {
        TreeMap<String, String> configs = new TreeMap<String, String>();
        for (PackageEntryOrNode entry : configFileOrDir.getChildren()) {
            if (entry.isDirectory()) {
                Map<String, String> resultsFromDir = this.getConfigurations(entry, configFilePatterns);
                configs.putAll(resultsFromDir);
                continue;
            }
            if (!ConfigFilesRetrieverImpl.isRelevantConfiguration(entry, configFileOrDir.getName(), this.slingSettingsService, configFilePatterns)) continue;
            LOG.debug("Found relevant YAML file {}", (Object)entry.getName());
            configs.put(entry.getPath(), entry.getContentAsString());
        }
        return configs;
    }

    static boolean isRelevantConfiguration(PackageEntryOrNode entry, String parentName, ExtendedSlingSettingsService slingSettings, Collection<String> configFilePatterns) throws Exception {
        boolean matchPattern = configFilePatterns.isEmpty();
        for (String pathPattern : configFilePatterns) {
            if (!entry.getPath().matches(pathPattern)) continue;
            matchPattern = true;
        }
        if (!matchPattern) {
            LOG.info("Skipped file '{}' because it didn't match any path pattern", (Object)entry.getPath());
            return false;
        }
        String entryName = entry.getName();
        if (!entryName.endsWith(".yaml") && !entryName.equals("config")) {
            return false;
        }
        String runModeSpec = ConfigFilesRetrieverImpl.extractRunModeSpecFromName(parentName);
        if (runModeSpec.isEmpty()) {
            LOG.debug("Install file '{}', because parent name '{}' does not have a run mode specified.", (Object)entryName, (Object)parentName);
            return true;
        }
        boolean restrictionFulfilled = slingSettings.isMatchingRunModeSpec(runModeSpec);
        if (restrictionFulfilled) {
            LOG.debug("The relevant run modes are all set, therefore proceed installing file '{}'", (Object)entryName);
        } else {
            LOG.debug("The run mode restrictions could not be fullfilled, therefore not installing file '{}'", (Object)entryName);
        }
        return restrictionFulfilled;
    }

    static String extractRunModeSpecFromName(String name) {
        int positionDot = name.indexOf(".");
        if (positionDot == -1) {
            return "";
        }
        return name.substring(positionDot + 1);
    }

    private static class EntryInPackage
    implements PackageEntryOrNode {
        private final Archive.Entry entry;
        private final String path;
        private final Archive archive;

        public EntryInPackage(Archive archive, String parentPath, Archive.Entry entry) {
            this.archive = archive;
            this.entry = entry;
            this.path = parentPath + "/" + entry.getName();
        }

        @Override
        public String getName() throws Exception {
            return this.entry.getName();
        }

        @Override
        public String getPath() {
            return this.path;
        }

        @Override
        public List<PackageEntryOrNode> getChildren() throws Exception {
            LinkedList<PackageEntryOrNode> children = new LinkedList<PackageEntryOrNode>();
            Collection entryChildren = this.entry.getChildren();
            for (Archive.Entry childEntry : entryChildren) {
                children.add(new EntryInPackage(this.archive, this.getPath(), childEntry));
            }
            return children;
        }

        @Override
        public boolean isDirectory() throws Exception {
            return this.entry.isDirectory();
        }

        @Override
        public String getContentAsString() throws Exception {
            LOG.debug("Reading YAML file {}", (Object)this.getPath());
            try (InputStream input = this.archive.getInputSource(this.entry).getByteStream();){
                if (input == null) {
                    throw new IllegalStateException("Could not get input stream from entry " + this.getPath());
                }
                StringWriter writer = new StringWriter();
                IOUtils.copy((InputStream)input, (Writer)writer, (String)"UTF-8");
                String string = writer.toString();
                return string;
            }
        }
    }

    private static class NodeInJcr
    implements PackageEntryOrNode {
        private final Node node;

        public NodeInJcr(Node node) {
            this.node = node;
        }

        @Override
        public String getName() throws Exception {
            return this.node.getName();
        }

        @Override
        public String getPath() throws Exception {
            return this.node.getPath();
        }

        @Override
        public List<PackageEntryOrNode> getChildren() throws Exception {
            LinkedList<PackageEntryOrNode> children = new LinkedList<PackageEntryOrNode>();
            NodeIterator childNodesIt = this.node.getNodes();
            while (childNodesIt.hasNext()) {
                children.add(new NodeInJcr((Node)childNodesIt.next()));
            }
            return children;
        }

        @Override
        public boolean isDirectory() throws Exception {
            return this.node.getPrimaryNodeType().isNodeType("{http://www.jcp.org/jcr/nt/1.0}folder");
        }

        @Override
        public String getContentAsString() throws Exception {
            try (InputStream configInputStream = JcrUtils.readFile((Node)this.node);){
                StringWriter writer = new StringWriter();
                IOUtils.copy((InputStream)configInputStream, (Writer)writer, (String)"UTF-8");
                String configData = writer.toString();
                LOG.debug("Found configuration data of node: {} with {} chars", (Object)this.node.getPath(), (Object)configData.length());
                String string = configData;
                return string;
            }
        }
    }

    static interface PackageEntryOrNode {
        public String getName() throws Exception;

        public String getPath() throws Exception;

        public List<PackageEntryOrNode> getChildren() throws Exception;

        public boolean isDirectory() throws Exception;

        public String getContentAsString() throws Exception;
    }
}

