/*
 * Decompiled with CFR 0.152.
 */
package biz.netcentric.cq.tools.actool.configreader;

import biz.netcentric.cq.tools.actool.configmodel.AcConfiguration;
import biz.netcentric.cq.tools.actool.configmodel.AcesConfig;
import biz.netcentric.cq.tools.actool.configmodel.AuthorizableConfigBean;
import biz.netcentric.cq.tools.actool.configmodel.AuthorizablesConfig;
import biz.netcentric.cq.tools.actool.configmodel.GlobalConfiguration;
import biz.netcentric.cq.tools.actool.configreader.ConfigReader;
import biz.netcentric.cq.tools.actool.configreader.ConfigurationMerger;
import biz.netcentric.cq.tools.actool.configreader.TestUserConfigsCreator;
import biz.netcentric.cq.tools.actool.configreader.VirtualGroupProcessor;
import biz.netcentric.cq.tools.actool.configreader.YamlConfigurationAdminPluginScalarConstructor;
import biz.netcentric.cq.tools.actool.configreader.YamlMacroProcessor;
import biz.netcentric.cq.tools.actool.history.InstallationLogger;
import biz.netcentric.cq.tools.actool.history.PersistableInstallationLogger;
import biz.netcentric.cq.tools.actool.slingsettings.ExtendedSlingSettingsService;
import biz.netcentric.cq.tools.actool.validators.GlobalConfigurationValidator;
import biz.netcentric.cq.tools.actool.validators.ObsoleteAuthorizablesValidator;
import biz.netcentric.cq.tools.actool.validators.UnmangedExternalMemberRelationshipChecker;
import biz.netcentric.cq.tools.actool.validators.YamlConfigurationsValidator;
import biz.netcentric.cq.tools.actool.validators.exceptions.AcConfigBeanValidationException;
import biz.netcentric.cq.tools.actool.validators.exceptions.NoListOnTopLevelException;
import biz.netcentric.cq.tools.actool.validators.impl.AceBeanValidatorImpl;
import biz.netcentric.cq.tools.actool.validators.impl.AuthorizableValidatorImpl;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import org.osgi.service.cm.ConfigurationPlugin;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicyOption;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.yaml.snakeyaml.Yaml;
import org.yaml.snakeyaml.constructor.BaseConstructor;
import org.yaml.snakeyaml.error.YAMLException;

@Component
public class YamlConfigurationMerger
implements ConfigurationMerger {
    private static final Logger LOG = LoggerFactory.getLogger(YamlConfigurationMerger.class);
    public static final String GLOBAL_VAR_RUNMODES = "RUNMODES";
    @Reference(policyOption=ReferencePolicyOption.GREEDY)
    YamlMacroProcessor yamlMacroProcessor;
    @Reference(policyOption=ReferencePolicyOption.GREEDY)
    ObsoleteAuthorizablesValidator obsoleteAuthorizablesValidator;
    @Reference(policyOption=ReferencePolicyOption.GREEDY)
    VirtualGroupProcessor virtualGroupProcessor;
    @Reference(policyOption=ReferencePolicyOption.GREEDY)
    TestUserConfigsCreator testUserConfigsCreator;
    @Reference(policyOption=ReferencePolicyOption.GREEDY)
    ExtendedSlingSettingsService slingSettingsService;
    @Reference(cardinality=ReferenceCardinality.OPTIONAL, policyOption=ReferencePolicyOption.GREEDY, target="(config.plugin.id=org.apache.felix.configadmin.plugin.interpolation)")
    ConfigurationPlugin interpolationPlugin;
    public static final Pattern CONFIG_ADMIN_INTERPOLATOR_FORMAT = Pattern.compile(".*\\$\\[(env|secret|prop):[^\\]]*\\].*");

    @Override
    public AcConfiguration getMergedConfigurations(Map<String, String> configFileContentByFilename, PersistableInstallationLogger installLog, ConfigReader configReader, Session session) throws RepositoryException, AcConfigBeanValidationException {
        Yaml yamlParser;
        long wholeConfigStart = System.currentTimeMillis();
        GlobalConfiguration globalConfiguration = new GlobalConfiguration();
        AuthorizablesConfig mergedAuthorizablesBeansfromConfig = new AuthorizablesConfig();
        AcesConfig mergedAceBeansFromConfig = new AcesConfig();
        HashSet<String> authorizableIdsFromAllConfigs = new HashSet<String>();
        HashSet<String> obsoleteAuthorizables = new HashSet<String>();
        if (this.interpolationPlugin != null) {
            yamlParser = new Yaml((BaseConstructor)new YamlConfigurationAdminPluginScalarConstructor(installLog, this.interpolationPlugin));
            yamlParser.addImplicitResolver(YamlConfigurationAdminPluginScalarConstructor.TAG, CONFIG_ADMIN_INTERPOLATOR_FORMAT, null);
            installLog.addMessage(LOG, "Using YAML parser with ConfigurationAdmin Plugin placeholder support");
        } else {
            yamlParser = new Yaml();
        }
        YamlConfigurationsValidator configurationsValidator = new YamlConfigurationsValidator();
        Map<String, Object> globalVariables = this.getGlobalVariablesForYamlMacroProcessing();
        for (Map.Entry<String, String> entry : configFileContentByFilename.entrySet()) {
            AuthorizablesConfig usersMapFromThisConfig;
            List<Map> yamlRootList;
            long configFileStart = System.currentTimeMillis();
            String sourceFile = entry.getKey();
            installLog.addMessage(LOG, "Using configuration file " + sourceFile);
            try {
                yamlRootList = (List<Map>)yamlParser.loadAs(entry.getValue(), List.class);
                if (yamlRootList == null || yamlRootList.isEmpty()) {
                    installLog.addMessage(LOG, "   " + sourceFile + " has no instructions");
                    continue;
                }
            }
            catch (ClassCastException e) {
                throw new NoListOnTopLevelException("Each yaml file must contain a list on the top level but the yaml at " + sourceFile + " does not.", e);
            }
            catch (YAMLException e) {
                throw new IllegalArgumentException("Invalid yaml source file " + sourceFile + ": " + (Object)((Object)e), e);
            }
            yamlRootList = this.yamlMacroProcessor.processMacros(yamlRootList, globalVariables, installLog, session);
            installLog.setMergedAndProcessedConfig("# File " + sourceFile + "\n" + yamlParser.dump(yamlRootList));
            LinkedHashSet<String> sectionIdentifiers = new LinkedHashSet<String>();
            for (int i = 0; i < yamlRootList.size(); ++i) {
                sectionIdentifiers.addAll(yamlRootList.get(i).keySet());
            }
            configurationsValidator.validateSectionIdentifiers(sectionIdentifiers, sourceFile);
            try {
                globalConfiguration.merge(configReader.getGlobalConfiguration(yamlRootList));
            }
            catch (IllegalArgumentException e) {
                throw new IllegalArgumentException("Invalid global configuration in " + sourceFile + ": " + e, e);
            }
            AuthorizableValidatorImpl authorizableValidator = new AuthorizableValidatorImpl("/home/groups", "/home/users");
            AuthorizablesConfig groupsFromThisConfig = configReader.getGroupConfigurationBeans(yamlRootList, authorizableValidator);
            if (groupsFromThisConfig != null) {
                mergedAuthorizablesBeansfromConfig.addAll(groupsFromThisConfig);
            }
            if ((usersMapFromThisConfig = configReader.getUserConfigurationBeans(yamlRootList, authorizableValidator)) != null) {
                mergedAuthorizablesBeansfromConfig.addAll(usersMapFromThisConfig);
            }
            HashSet<String> authorizableIdsFromCurrentConfig = new HashSet<String>();
            if (groupsFromThisConfig != null) {
                authorizableIdsFromCurrentConfig.addAll(groupsFromThisConfig.getAuthorizableIds());
            }
            if (usersMapFromThisConfig != null) {
                authorizableIdsFromCurrentConfig.addAll(usersMapFromThisConfig.getAuthorizableIds());
            }
            if (authorizableIdsFromCurrentConfig != null) {
                configurationsValidator.validateDuplicateAuthorizables(authorizableIdsFromAllConfigs, authorizableIdsFromCurrentConfig, sourceFile);
                authorizableIdsFromAllConfigs.addAll(authorizableIdsFromCurrentConfig);
            }
            AcesConfig currentAceBeansFromConfig = configReader.getAceConfigurationBeans(yamlRootList, this.getAceBeanValidator(authorizableIdsFromAllConfigs), session, sourceFile);
            configurationsValidator.validateKeepOrder(mergedAceBeansFromConfig, currentAceBeansFromConfig, sourceFile);
            if (currentAceBeansFromConfig != null) {
                mergedAceBeansFromConfig.addAll(currentAceBeansFromConfig);
            }
            configurationsValidator.validateInitialContentForNoDuplicates(mergedAceBeansFromConfig);
            obsoleteAuthorizables.addAll(configReader.getObsoluteAuthorizables(yamlRootList));
            this.obsoleteAuthorizablesValidator.validate(obsoleteAuthorizables, authorizableIdsFromAllConfigs, sourceFile);
            installLog.addVerboseMessage(LOG, "Loaded configuration file " + sourceFile + " in " + PersistableInstallationLogger.msHumanReadable(System.currentTimeMillis() - configFileStart));
        }
        this.ensureIsMemberOfIsUsedWherePossible(mergedAuthorizablesBeansfromConfig, installLog);
        GlobalConfigurationValidator.validate(globalConfiguration);
        AcConfiguration acConfiguration = new AcConfiguration();
        acConfiguration.setGlobalConfiguration(globalConfiguration);
        acConfiguration.setAuthorizablesConfig(mergedAuthorizablesBeansfromConfig);
        acConfiguration.setAceConfig(mergedAceBeansFromConfig);
        acConfiguration.setObsoleteAuthorizables(obsoleteAuthorizables);
        this.virtualGroupProcessor.flattenGroupTree(acConfiguration, installLog);
        this.testUserConfigsCreator.createTestUserConfigs(acConfiguration, installLog);
        if (!Boolean.TRUE.equals(globalConfiguration.getAllowCreateOfUnmanagedRelationships())) {
            UnmangedExternalMemberRelationshipChecker.validate(acConfiguration);
        }
        installLog.setMergedAndProcessedConfig("# Merged configuration of " + configFileContentByFilename.size() + " files \n" + yamlParser.dump((Object)acConfiguration));
        installLog.addMessage(LOG, "Loaded configuration in " + PersistableInstallationLogger.msHumanReadable(System.currentTimeMillis() - wholeConfigStart));
        return acConfiguration;
    }

    private Map<String, Object> getGlobalVariablesForYamlMacroProcessing() {
        HashMap<String, Object> globalVariables = new HashMap<String, Object>();
        if (this.slingSettingsService != null) {
            globalVariables.put(GLOBAL_VAR_RUNMODES, new ArrayList<String>(this.slingSettingsService.getRunModes()));
        }
        return globalVariables;
    }

    AceBeanValidatorImpl getAceBeanValidator(Set<String> authorizableIdsFromAllConfigs) {
        return new AceBeanValidatorImpl(authorizableIdsFromAllConfigs);
    }

    void ensureIsMemberOfIsUsedWherePossible(AuthorizablesConfig mergedAuthorizablesBeansfromConfig, InstallationLogger history) {
        for (AuthorizableConfigBean group : mergedAuthorizablesBeansfromConfig) {
            if (!group.isGroup()) continue;
            String groupName = group.getAuthorizableId();
            String[] origMembersArr = group.getMembers();
            if (origMembersArr == null || origMembersArr.length == 0) continue;
            ArrayList<String> members = new ArrayList<String>(Arrays.asList(origMembersArr));
            Iterator membersIt = members.iterator();
            while (membersIt.hasNext()) {
                String member = (String)membersIt.next();
                AuthorizableConfigBean groupForIsMemberOf = mergedAuthorizablesBeansfromConfig.getAuthorizableConfig(member);
                boolean memberContainedInConfig = groupForIsMemberOf != null;
                if (!memberContainedInConfig) continue;
                groupForIsMemberOf.addIsMemberOf(groupName);
                membersIt.remove();
                history.addVerboseMessage(LOG, "Group " + group.getAuthorizableId() + " is declaring member " + member + " - moving relationship to isMemberOf of authorizable " + groupForIsMemberOf.getAuthorizableId() + " (always prefer using isMemberOf over members if referenced member is availalbe in configuration)");
            }
            group.setMembers(members.toArray(new String[members.size()]));
        }
    }
}

