/*
 * Decompiled with CFR 0.152.
 */
package biz.netcentric.cq.tools.actool.configreader;

import biz.netcentric.cq.tools.actool.configreader.YamlMacroChildNodeObjectsProvider;
import biz.netcentric.cq.tools.actool.configreader.YamlMacroElEvaluator;
import biz.netcentric.cq.tools.actool.configreader.YamlMacroProcessor;
import biz.netcentric.cq.tools.actool.history.InstallationLogger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.jcr.Session;
import org.apache.commons.lang3.StringUtils;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferencePolicyOption;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component
public class YamlMacroProcessorImpl
implements YamlMacroProcessor {
    private static final Logger LOG = LoggerFactory.getLogger(YamlMacroProcessorImpl.class);
    private static final Pattern FOR_LOOP_PATTERN = Pattern.compile("for +(\\w+)( +with +content)? +in +(?:\\[([,/\\s\\w\\-\\.:]+)\\]|children +of +([^\\s]+)|(\\$\\{[^\\}]+\\}))", 2);
    private static final Pattern IF_PATTERN = Pattern.compile("if +(\\$\\{[^\\}]+\\})", 2);
    private static final String VARIABLE_DEF_BASE_PATTERN = "DEF +([a-z0-9_]+)=";
    static final Pattern VARIABLE_DEF_PATTERN_COMPLEX_VAL_FROM_YAML = Pattern.compile("DEF +([a-z0-9_]+)=", 2);
    static final Pattern VARIABLE_DEF_PATTERN_ONE_LINE = Pattern.compile("DEF +([a-z0-9_]+)=(?:\\[(.+)\\]|(\"?)([^\"]*)(\\3))", 2);
    static final String COMMA_SEPARATED_LIST_SPLITTER = "\\s*,\\s*";
    YamlMacroElEvaluator elEvaluator = new YamlMacroElEvaluator();
    @Reference(policyOption=ReferencePolicyOption.GREEDY)
    YamlMacroChildNodeObjectsProvider yamlMacroChildNodeObjectsProvider;

    @Override
    public List<Map> processMacros(List<Map> yamlList, Map<String, Object> globalVariables, InstallationLogger installLog, Session session) {
        Map<String, Object> initialVariables = this.getLocalVariables(yamlList, globalVariables, installLog, session);
        return (List)this.transform(yamlList, initialVariables, installLog, session);
    }

    private Map<String, Object> getLocalVariables(List<Map> yamlList, Map<String, Object> globalVariables, InstallationLogger installLog, Session session) {
        HashSet<String> initalGlobalVarNames = new HashSet<String>(globalVariables.keySet());
        Iterator<Map> topLevelIterator = yamlList.iterator();
        Object transformedGlobalConfig = null;
        while (topLevelIterator.hasNext()) {
            Map map;
            Map obj = topLevelIterator.next();
            if (!(obj instanceof Map) || (map = (Map)obj).isEmpty() || !"global_config".equals(map.keySet().iterator().next())) continue;
            transformedGlobalConfig = this.transform(map, globalVariables, installLog, session);
            topLevelIterator.remove();
            break;
        }
        if (transformedGlobalConfig != null) {
            yamlList.add(0, (Map)transformedGlobalConfig);
        }
        for (Map.Entry entry : globalVariables.entrySet()) {
            if (initalGlobalVarNames.contains(entry.getKey())) continue;
            installLog.addVerboseMessage(LOG, "Global DEF Statement: " + (String)entry.getKey() + "=" + entry.getValue());
        }
        LinkedHashMap<String, Object> localVariables = new LinkedHashMap<String, Object>();
        localVariables.putAll(globalVariables);
        return localVariables;
    }

    private Object transform(Object o, Map<String, Object> variables, InstallationLogger installLog, Session session) {
        if (o == null) {
            return null;
        }
        if (o instanceof String) {
            String str = (String)o;
            Matcher variableDefMatcher = VARIABLE_DEF_PATTERN_ONE_LINE.matcher(str);
            if (variableDefMatcher.find()) {
                return this.evaluateDefStatementOneLine(variables, variableDefMatcher, installLog);
            }
            Object result = this.elEvaluator.evaluateEl(str, Object.class, variables);
            return result;
        }
        if (o instanceof Boolean) {
            return (Boolean)o;
        }
        if (o instanceof List) {
            List list = (List)o;
            LinkedList transformedList = new LinkedList();
            for (Object val : list) {
                Object transformedObject = this.transform(val, variables, installLog, session);
                this.addToListWithPotentialUnfolding(transformedList, transformedObject);
            }
            return transformedList;
        }
        if (o instanceof Map) {
            Map map = (Map)o;
            LinkedHashMap<Object, Object> resultMap = new LinkedHashMap<Object, Object>();
            for (Object key : map.keySet()) {
                Object objVal = map.get(key);
                String string = key.toString();
                Matcher forMatcher = FOR_LOOP_PATTERN.matcher(string);
                if (forMatcher.matches()) {
                    return this.evaluateForStatement(variables, objVal, forMatcher, installLog, session);
                }
                Matcher ifMatcher = IF_PATTERN.matcher(string);
                if (ifMatcher.matches()) {
                    return this.evaluateIfStatement(variables, objVal, ifMatcher, installLog, session);
                }
                Matcher complexVarDefMatcher = VARIABLE_DEF_PATTERN_COMPLEX_VAL_FROM_YAML.matcher(string);
                if (complexVarDefMatcher.matches()) {
                    return this.evaluateDefStatementComplex(variables, complexVarDefMatcher, objVal, installLog);
                }
                Object transformedKey = this.transform(key, variables, installLog, session);
                Object transformedVal = this.transform(objVal, variables, installLog, session);
                if (transformedVal == null) continue;
                resultMap.put(transformedKey, transformedVal);
            }
            return resultMap;
        }
        throw new IllegalStateException("Unexpected class " + o.getClass() + " in object structure produced by yaml: " + o);
    }

    private Object evaluateDefStatementOneLine(Map<String, Object> variables, Matcher variableDefMatcher, InstallationLogger installLog) {
        ArrayList<Object> varValueEvaluated;
        String varName = variableDefMatcher.group(1);
        String varValueArr = variableDefMatcher.group(2);
        String varValueStr = variableDefMatcher.group(4);
        if (varValueStr != null) {
            varValueEvaluated = this.elEvaluator.evaluateEl(varValueStr, Object.class, variables);
        } else if (varValueArr != null) {
            String[] arrayVals;
            ArrayList<Object> result = new ArrayList<Object>();
            for (String arrayVal : arrayVals = varValueArr.split(COMMA_SEPARATED_LIST_SPLITTER)) {
                Object arrayValEvaluated = this.elEvaluator.evaluateEl(arrayVal, Object.class, variables);
                result.add(arrayValEvaluated);
            }
            varValueEvaluated = result;
        } else {
            throw new IllegalStateException("None of the def value types were set even though RegEx matched");
        }
        if (variables.containsKey(varName)) {
            installLog.addVerboseMessage(LOG, "Overwriting variable '" + varName + "' with " + varValueEvaluated);
        }
        variables.put(varName, varValueEvaluated);
        return null;
    }

    private Object evaluateDefStatementComplex(Map<String, Object> variables, Matcher variableDefMatcher, Object varComplexValueFromYaml, InstallationLogger installLog) {
        String varName = variableDefMatcher.group(1);
        if (variables.containsKey(varName)) {
            installLog.addVerboseMessage(LOG, "Overwriting variable '" + varName + "' with " + varComplexValueFromYaml);
        }
        variables.put(varName, varComplexValueFromYaml);
        return null;
    }

    private Object evaluateForStatement(Map<String, Object> variables, Object objVal, Matcher forMatcher, InstallationLogger installLog, Session session) {
        List<Object> iterationValues;
        String varName = StringUtils.trim((String)forMatcher.group(1));
        String withClause = StringUtils.trim((String)forMatcher.group(2));
        String valueOfInClause = StringUtils.trim((String)forMatcher.group(3));
        String pathOfChildrenOfClause = StringUtils.trim((String)forMatcher.group(4));
        String variableForInClause = StringUtils.trim((String)forMatcher.group(5));
        if (valueOfInClause != null) {
            iterationValues = Arrays.asList(valueOfInClause.split(COMMA_SEPARATED_LIST_SPLITTER));
        } else if (pathOfChildrenOfClause != null) {
            pathOfChildrenOfClause = this.elEvaluator.evaluateEl(pathOfChildrenOfClause, String.class, variables);
            iterationValues = this.yamlMacroChildNodeObjectsProvider.getValuesForPath(pathOfChildrenOfClause, installLog, session, StringUtils.isNotBlank((CharSequence)withClause));
        } else if (variableForInClause != null) {
            iterationValues = this.elEvaluator.evaluateEl(variableForInClause, List.class, variables);
            if (iterationValues == null) {
                if (variableForInClause.contains(".") || variableForInClause.contains("[")) {
                    return null;
                }
                throw new IllegalStateException("LOOP over EL ${" + variableForInClause + "} is null");
            }
        } else {
            throw new IllegalStateException("None of the loop type variables were set even though RegEx matched");
        }
        List toBeUnfoldedList = this.unfoldLoop(variables, objVal, varName, iterationValues, installLog, session);
        return toBeUnfoldedList;
    }

    private Object evaluateIfStatement(Map<String, Object> variables, Object objVal, Matcher ifMatcher, InstallationLogger installLog, Session session) {
        String condition = ifMatcher.group(1).trim();
        boolean expressionIsTrue = this.elEvaluator.evaluateEl(condition, Boolean.class, variables);
        List toBeUnfoldedList = this.unfoldIf(variables, objVal, expressionIsTrue, installLog, session);
        return toBeUnfoldedList;
    }

    private void addToListWithPotentialUnfolding(List transformedList, Object transformedObject) {
        if (transformedObject == null) {
            return;
        }
        if (transformedObject instanceof ToBeUnfoldedList) {
            ToBeUnfoldedList toBeUnfoldedList = (ToBeUnfoldedList)transformedObject;
            for (Object object : toBeUnfoldedList) {
                transformedList.add(object);
            }
        } else {
            transformedList.add(transformedObject);
        }
    }

    private List unfoldLoop(Map<String, Object> variables, Object val, String varName, List<?> varValues, InstallationLogger installLog, Session session) {
        ToBeUnfoldedList resultList = new ToBeUnfoldedList();
        for (Object varValue : varValues) {
            HashMap<String, Object> variablesAtThisScope = new HashMap<String, Object>(variables);
            variablesAtThisScope.put(varName, varValue);
            this.unfold(val, resultList, variablesAtThisScope, installLog, session);
        }
        return resultList;
    }

    private List unfoldIf(Map<String, Object> variables, Object val, boolean expressionIsTrue, InstallationLogger installLog, Session session) {
        ToBeUnfoldedList resultList = new ToBeUnfoldedList();
        if (expressionIsTrue) {
            this.unfold(val, resultList, variables, installLog, session);
        }
        return resultList;
    }

    private void unfold(Object val, List resultList, Map<String, Object> variablesAtThisScope, InstallationLogger installLog, Session session) {
        if (val instanceof List) {
            List origList = (List)val;
            for (Object origListItem : origList) {
                Object transformedListItem = this.transform(origListItem, variablesAtThisScope, installLog, session);
                this.addToListWithPotentialUnfolding(resultList, transformedListItem);
            }
        } else {
            Object transformedListItem = this.transform(val, variablesAtThisScope, installLog, session);
            this.addToListWithPotentialUnfolding(resultList, transformedListItem);
        }
    }

    public static void main(String[] args) throws Exception {
        HashMap<String, Object> userMap = new HashMap<String, Object>();
        userMap.put("x", new Integer(123));
        userMap.put("y", new Integer(456));
        userMap.put("TEST", "a long test value");
        String expr = "x= ---- ${upperCase(splitByWholeSeparator(TEST,'long')[1])}";
        String val = new YamlMacroElEvaluator().evaluateEl(expr, String.class, userMap);
        System.out.println("the value for " + expr + " =>> " + val);
    }

    private class ToBeUnfoldedList
    extends LinkedList {
        private ToBeUnfoldedList() {
        }
    }
}

