/*
 * Decompiled with CFR 0.152.
 */
package biz.netcentric.cq.tools.actool.helper;

import biz.netcentric.cq.tools.actool.comparators.AcePermissionComparator;
import biz.netcentric.cq.tools.actool.configmodel.AceBean;
import biz.netcentric.cq.tools.actool.configmodel.Restriction;
import biz.netcentric.cq.tools.actool.helper.AceWrapper;
import java.util.AbstractSet;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import javax.jcr.RepositoryException;
import javax.jcr.Value;
import javax.jcr.ValueFormatException;
import javax.jcr.security.AccessControlEntry;
import javax.jcr.security.AccessControlList;
import org.apache.commons.lang3.StringUtils;
import org.apache.jackrabbit.api.security.JackrabbitAccessControlEntry;
import org.apache.jackrabbit.api.security.JackrabbitAccessControlList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AcHelper {
    public static final Logger LOG = LoggerFactory.getLogger(AcHelper.class);
    public static int ACE_ORDER_ACTOOL_BEST_PRACTICE = 1;
    public static int ACE_ORDER_NONE = 2;
    public static int ACE_ORDER_ALPHABETICAL = 3;
    public static int PRINCIPAL_BASED_ORDER = 1;
    public static int PATH_BASED_ORDER = 2;

    private AcHelper() {
    }

    public static AceBean getAceBean(AccessControlEntry ace, AccessControlList acl) throws RepositoryException {
        AceWrapper aceWrapper = new AceWrapper((JackrabbitAccessControlEntry)ace, ((JackrabbitAccessControlList)acl).getPath());
        AceBean aceBean = AcHelper.getAceBean(aceWrapper);
        return aceBean;
    }

    public static AceBean getAceBean(AceWrapper ace) throws ValueFormatException, IllegalStateException, RepositoryException {
        AceBean aceBean = new AceBean();
        aceBean.setPermission(ace.isAllow() ? "allow" : "deny");
        aceBean.setJcrPath(ace.getJcrPath());
        aceBean.setPrincipalName(ace.getPrincipal().getName());
        aceBean.setPrivilegesString(ace.getPrivilegesString());
        List<Restriction> restrictions = AcHelper.buildRestrictionsMap(ace);
        aceBean.setRestrictions(restrictions);
        return aceBean;
    }

    private static List<Restriction> buildRestrictionsMap(AceWrapper ace) throws RepositoryException, ValueFormatException {
        String[] restrictionNames = ace.getRestrictionNames();
        ArrayList<Restriction> restrictionsList = new ArrayList<Restriction>();
        for (String restrictionName : restrictionNames) {
            Value[] values = ace.getRestrictions(restrictionName);
            String[] strValues = new String[values.length];
            for (int i = 0; i < strValues.length; ++i) {
                strValues[i] = values[i].getString();
            }
            restrictionsList.add(new Restriction(restrictionName, strValues));
        }
        return restrictionsList;
    }

    public static String getBlankString(int nrOfBlanks) {
        return StringUtils.repeat((String)" ", (int)nrOfBlanks);
    }

    public static Map<String, Set<AceBean>> getPathBasedAceMap(Set<AceBean> aceBeansFromConfig, int sorting) {
        TreeMap<String, Set<AceBean>> pathBasedAceMap = new TreeMap<String, Set<AceBean>>();
        for (AceBean bean : aceBeansFromConfig) {
            if (pathBasedAceMap.get(bean.getJcrPath()) == null) {
                AbstractSet aceSet = null;
                if (sorting == ACE_ORDER_NONE) {
                    aceSet = new LinkedHashSet<AceBean>();
                } else if (sorting == ACE_ORDER_ACTOOL_BEST_PRACTICE) {
                    aceSet = new TreeSet<AceBean>(new AcePermissionComparator());
                }
                aceSet.add(bean);
                pathBasedAceMap.put(bean.getJcrPath(), aceSet);
                continue;
            }
            ((Set)pathBasedAceMap.get(bean.getJcrPath())).add(bean);
        }
        return pathBasedAceMap;
    }

    public static Map<String, Set<AceBean>> getPathBasedAceMap(Map<String, Set<AceBean>> groupBasedAceMap, int sorting) {
        TreeMap<String, Set<AceBean>> pathBasedAceMap = new TreeMap<String, Set<AceBean>>();
        for (Map.Entry<String, Set<AceBean>> entry : groupBasedAceMap.entrySet()) {
            String principal = entry.getKey();
            Set<AceBean> tmpSet = entry.getValue();
            for (AceBean bean : tmpSet) {
                bean.setPrincipalName(principal);
                if (pathBasedAceMap.get(bean.getJcrPath()) == null) {
                    AbstractSet aceSet = null;
                    if (sorting == ACE_ORDER_NONE) {
                        aceSet = new LinkedHashSet<AceBean>();
                    } else if (sorting == ACE_ORDER_ACTOOL_BEST_PRACTICE) {
                        aceSet = new TreeSet<AceBean>(new AcePermissionComparator());
                    }
                    aceSet.add(bean);
                    pathBasedAceMap.put(bean.getJcrPath(), aceSet);
                    continue;
                }
                ((Set)pathBasedAceMap.get(bean.getJcrPath())).add(bean);
            }
        }
        return pathBasedAceMap;
    }

    public static String valuesToString(Value[] propertyValues) throws RepositoryException {
        if (propertyValues == null) {
            return null;
        }
        if (propertyValues.length == 0) {
            return null;
        }
        if (propertyValues.length == 1) {
            return propertyValues[0].getString();
        }
        throw new IllegalArgumentException("Unexpectedly received more than one value for a property that is expected to be non-multiple");
    }
}

