/*
 * Decompiled with CFR 0.152.
 */
package biz.netcentric.cq.tools.actool.helper;

import java.security.Principal;
import java.text.Collator;
import java.util.ArrayList;
import java.util.List;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.UnsupportedRepositoryOperationException;
import javax.jcr.security.AccessControlEntry;
import org.apache.commons.lang3.StringUtils;
import org.apache.jackrabbit.api.security.JackrabbitAccessControlList;

public class AclBean
implements Comparable<AclBean> {
    private String jcrPath;
    private String parentPath;
    private JackrabbitAccessControlList acl;

    public AclBean(JackrabbitAccessControlList acl, String jcrPath) {
        this.jcrPath = jcrPath;
        this.acl = acl;
    }

    public AclBean() {
    }

    public String getParentPath() {
        return this.parentPath;
    }

    public void setParentPath(String parentPath) {
        this.parentPath = parentPath;
    }

    public String getJcrPath() {
        return this.jcrPath;
    }

    public void setJcrPath(String jcrPath) {
        this.jcrPath = jcrPath;
    }

    public JackrabbitAccessControlList getAcl() {
        return this.acl;
    }

    public void setAcl(JackrabbitAccessControlList acl) {
        this.acl = acl;
    }

    public String[] getAces(JackrabbitAccessControlList acl) throws RepositoryException {
        return this.acl.getRestrictionNames();
    }

    public List<AccessControlEntry> getGroupBasedACEs(Session session, Principal principal) throws UnsupportedRepositoryOperationException, RepositoryException {
        ArrayList<AccessControlEntry> aceList = new ArrayList<AccessControlEntry>();
        if (this.acl != null) {
            AccessControlEntry[] aces;
            for (AccessControlEntry ace : aces = this.acl.getAccessControlEntries()) {
                if (!ace.getPrincipal().getName().equals(principal.getName())) continue;
                aceList.add(ace);
            }
        }
        return aceList;
    }

    public String toString() {
        return "[AclBean " + this.jcrPath + " " + this.acl.toString() + "]";
    }

    public boolean equals(Object obj) {
        return this.acl.equals(obj);
    }

    @Override
    public int compareTo(AclBean o) {
        if (o == null) {
            return -1;
        }
        String comparePath1 = (String)StringUtils.defaultIfEmpty((CharSequence)this.getParentPath(), (CharSequence)"");
        String comparePath2 = (String)StringUtils.defaultIfEmpty((CharSequence)o.getParentPath(), (CharSequence)"");
        return Collator.getInstance().compare(comparePath1, comparePath2);
    }
}

