/*
 * Decompiled with CFR 0.152.
 */
package biz.netcentric.cq.tools.actool.helper;

import biz.netcentric.cq.tools.actool.helper.AclBean;
import biz.netcentric.cq.tools.actool.history.PersistableInstallationLogger;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import javax.jcr.AccessDeniedException;
import javax.jcr.ItemNotFoundException;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.PathNotFoundException;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.UnsupportedRepositoryOperationException;
import javax.jcr.query.InvalidQueryException;
import javax.jcr.query.Query;
import javax.jcr.query.QueryResult;
import javax.jcr.security.AccessControlList;
import javax.jcr.security.AccessControlManager;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.time.StopWatch;
import org.apache.jackrabbit.api.security.JackrabbitAccessControlList;
import org.apache.jackrabbit.util.Text;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QueryHelper {
    public static final Logger LOG = LoggerFactory.getLogger(QueryHelper.class);
    private static final String ROOT_REP_POLICY_NODE = "/rep:policy";
    private static final String ROOT_REPO_POLICY_NODE = "/rep:repoPolicy";
    private static final String HOME_REP_POLICY = "/home/rep:policy";
    private static final String OAK_INDEX_PATH_REP_ACL = "/oak:index/repACL";

    public static Set<String> getRepPolicyNodePaths(Session session, List<String> excludePaths) {
        NodeIterator nodeIt = null;
        try {
            nodeIt = session.getRootNode().getNodes();
        }
        catch (RepositoryException e) {
            LOG.error("Exception: {}", (Throwable)e);
        }
        TreeSet<String> rootChildrenPaths = new TreeSet<String>();
        while (nodeIt.hasNext()) {
            String currentPath = null;
            Node currentNode = nodeIt.nextNode();
            try {
                currentPath = currentNode.getPath();
            }
            catch (RepositoryException e) {
                LOG.error("Exception: {}", (Throwable)e);
            }
            try {
                if (currentNode.hasProperty("rep:AuthorizableFolder") || excludePaths.contains(currentPath)) continue;
                rootChildrenPaths.add(currentPath);
            }
            catch (RepositoryException e) {
                LOG.error("Exception: {}", (Throwable)e);
            }
        }
        HashSet<String> paths = new HashSet<String>();
        try {
            if (session.nodeExists(ROOT_REP_POLICY_NODE)) {
                paths.add(ROOT_REP_POLICY_NODE);
            }
            if (session.nodeExists(ROOT_REPO_POLICY_NODE)) {
                paths.add(ROOT_REPO_POLICY_NODE);
            }
            if (session.nodeExists(HOME_REP_POLICY)) {
                paths.add(HOME_REP_POLICY);
            }
            boolean indexForRepACLExists = session.nodeExists(OAK_INDEX_PATH_REP_ACL);
            LOG.debug("Index for repACL exists: {}", (Object)indexForRepACLExists);
            String queryForAClNodes = indexForRepACLExists ? "SELECT * FROM [rep:ACL] WHERE ISDESCENDANTNODE([%s])" : "SELECT ace.* FROM [rep:ACE] AS ace WHERE ace.[rep:principalName] IS NOT NULL AND ISDESCENDANTNODE(ace, [%s])";
            LOG.debug("Query to obtain all ACLs: {}", (Object)queryForAClNodes);
            for (String path : rootChildrenPaths) {
                if (StringUtils.equals((CharSequence)path, (CharSequence)ROOT_REP_POLICY_NODE) || StringUtils.equals((CharSequence)path, (CharSequence)ROOT_REPO_POLICY_NODE)) continue;
                String query = String.format(queryForAClNodes, path);
                long startTime1 = System.currentTimeMillis();
                Set<String> nodesResult = indexForRepACLExists ? QueryHelper.getNodePathsFromQuery(session, query, "JCR-SQL2") : QueryHelper.getDistinctParentNodePathsFromQuery(session, query, "JCR-SQL2");
                LOG.debug("Query to find ACLs under {} ran in {}ms (count ACLs: {})", new Object[]{path, System.currentTimeMillis() - startTime1, nodesResult.size()});
                paths.addAll(nodesResult);
            }
        }
        catch (Exception e) {
            throw new IllegalStateException("Could not query repository for existing ACLs: " + e, e);
        }
        return paths;
    }

    public static Set<String> getNodePathsFromQuery(Session session, String xpathQuery) throws InvalidQueryException, RepositoryException {
        return QueryHelper.getNodePathsFromQuery(session, xpathQuery, "xpath");
    }

    public static Set<String> getDistinctParentNodePathsFromQuery(Session session, String queryStatement, String queryLanguageType) throws InvalidQueryException, RepositoryException {
        Set<String> paths = QueryHelper.getNodePathsFromQuery(session, queryStatement, queryLanguageType);
        HashSet<String> parentPaths = new HashSet<String>();
        for (String path : paths) {
            parentPaths.add(Text.getRelativeParent((String)path, (int)1));
        }
        return parentPaths;
    }

    public static NodeIterator getNodesFromQuery(Session session, String queryStatement, String queryLanguageType) throws RepositoryException {
        Query query = session.getWorkspace().getQueryManager().createQuery(queryStatement, queryLanguageType);
        QueryResult queryResult = query.execute();
        return queryResult.getNodes();
    }

    public static Set<String> getNodePathsFromQuery(Session session, String queryStatement, String queryLanguageType) throws RepositoryException {
        HashSet<String> paths = new HashSet<String>();
        NodeIterator nit = QueryHelper.getNodesFromQuery(session, queryStatement, queryLanguageType);
        while (nit.hasNext()) {
            Node node = nit.nextNode();
            paths.add(node.getPath());
        }
        return paths;
    }

    public static Set<AclBean> getAuthorizablesAcls(Session session, Set<String> authorizableIds, Set<String> principalIdsToBeFilled) throws InvalidQueryException, RepositoryException {
        LOG.debug("Querying AclBeans for {} authorizables", (Object)authorizableIds.size());
        StopWatch sw = new StopWatch();
        sw.start();
        LinkedList<Node> nodes = new LinkedList<Node>();
        Iterator<String> authorizablesIdIterator = authorizableIds.iterator();
        while (authorizablesIdIterator.hasNext()) {
            StringBuilder queryStringBuilder = new StringBuilder();
            queryStringBuilder.append("SELECT ace.* FROM [rep:ACE] AS ace INNER JOIN [rep:Authorizable] AS authorizable ON ace.[rep:principalName] = authorizable.[rep:principalName] WHERE ");
            queryStringBuilder.append((CharSequence)QueryHelper.getAuthorizablesQueryStringBuilder(authorizablesIdIterator, 100));
            String query = queryStringBuilder.toString();
            NodeIterator nit = QueryHelper.getNodesFromQuery(session, query, "JCR-SQL2");
            LinkedList<Node> resultNodes = new LinkedList<Node>();
            while (nit.hasNext()) {
                resultNodes.add(nit.nextNode());
            }
            LOG.trace("Querying AclBeans with {} returned {} results", (Object)query, (Object)resultNodes.size());
            nodes.addAll(resultNodes);
        }
        Set<AclBean> resultBeans = QueryHelper.buildAclBeansFromNodes(session, nodes, principalIdsToBeFilled);
        sw.stop();
        LOG.debug("Found {} AclBeans in {}", (Object)resultBeans.size(), (Object)PersistableInstallationLogger.msHumanReadable(sw.getTime()));
        return resultBeans;
    }

    private static Set<AclBean> buildAclBeansFromNodes(Session session, Collection<Node> nodes, Set<String> principalIdsToBeFilled) throws UnsupportedRepositoryOperationException, RepositoryException, PathNotFoundException, AccessDeniedException, ItemNotFoundException {
        AccessControlManager aMgr = session.getAccessControlManager();
        TreeSet<AclBean> aclSet = new TreeSet<AclBean>();
        for (Node allowOrDenyNode : nodes) {
            String jcrPathAcl;
            String aclEffectiveOnPath;
            String principalId = allowOrDenyNode.getProperty("rep:principalName").getValue().getString();
            principalIdsToBeFilled.add(principalId);
            Node aclNode = allowOrDenyNode.getParent();
            if (!"rep:repoPolicy".equals(aclNode.getName())) {
                aclEffectiveOnPath = aclNode.getParent().getPath();
                jcrPathAcl = aclNode.getPath();
            } else {
                aclEffectiveOnPath = null;
                jcrPathAcl = ROOT_REPO_POLICY_NODE;
            }
            AccessControlList acl = (AccessControlList)aMgr.getPolicies(aclEffectiveOnPath)[0];
            if (acl == null) {
                LOG.warn("Path " + aclEffectiveOnPath + " unexpectedly does not have a ACL");
                continue;
            }
            AclBean aclBean = new AclBean();
            aclBean.setParentPath(aclEffectiveOnPath);
            aclBean.setAcl((JackrabbitAccessControlList)acl);
            aclBean.setJcrPath(jcrPathAcl);
            aclSet.add(aclBean);
        }
        return aclSet;
    }

    private static StringBuilder getAuthorizablesQueryStringBuilder(Iterator<String> authorizablesIdIterator, int authorizbalesLimitPerQuery) {
        int authorizableCounter = 0;
        StringBuilder querySb = new StringBuilder();
        if (!authorizablesIdIterator.hasNext()) {
            return querySb;
        }
        while (true) {
            querySb.append("authorizable.[rep:authorizableId] = '" + authorizablesIdIterator.next() + "'");
            if (++authorizableCounter >= authorizbalesLimitPerQuery || !authorizablesIdIterator.hasNext()) break;
            querySb.append(" or ");
        }
        return querySb;
    }
}

