/*
 * Decompiled with CFR 0.152.
 */
package biz.netcentric.cq.tools.actool.history.impl;

import biz.netcentric.cq.tools.actool.history.AcHistoryService;
import biz.netcentric.cq.tools.actool.history.AcToolExecution;
import biz.netcentric.cq.tools.actool.history.PersistableInstallationLogger;
import biz.netcentric.cq.tools.actool.history.impl.HistoryUtils;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.InputStream;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import org.apache.commons.lang3.StringUtils;
import org.apache.jackrabbit.commons.JcrUtils;
import org.apache.sling.jcr.api.SlingRepository;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferencePolicyOption;
import org.osgi.service.metatype.annotations.AttributeDefinition;
import org.osgi.service.metatype.annotations.Designate;
import org.osgi.service.metatype.annotations.ObjectClassDefinition;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component
@Designate(ocd=Configuration.class)
public class AcHistoryServiceImpl
implements AcHistoryService {
    private static final Logger LOG = LoggerFactory.getLogger(AcHistoryServiceImpl.class);
    public static final String INSTALLED_CONFIGS_NODE_NAME = "installedConfigs";
    private int nrOfSavedHistories;
    private boolean wasLastPersistHistoryCallSuccessful = true;
    @Reference(policyOption=ReferencePolicyOption.GREEDY)
    private SlingRepository repository;

    @Activate
    public void activate(Configuration configuration) throws Exception {
        this.nrOfSavedHistories = configuration.AceService_nrOfSavedHistories();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void persistHistory(PersistableInstallationLogger installLog) {
        if (this.nrOfSavedHistories == 0) {
            installLog.addVerboseMessage(LOG, "History hasn't been persisted, configured number of histories is " + this.nrOfSavedHistories);
            return;
        }
        Session session = null;
        try {
            session = this.repository.loginService(null, null);
            Node historyNode = HistoryUtils.persistHistory(session, installLog, this.nrOfSavedHistories);
            String mergedAndProcessedConfig = installLog.getMergedAndProcessedConfig();
            if (StringUtils.isNotBlank((CharSequence)mergedAndProcessedConfig)) {
                JcrUtils.putFile((Node)historyNode, (String)"mergedConfig.yaml", (String)"text/yaml", (InputStream)new ByteArrayInputStream(mergedAndProcessedConfig.getBytes()));
            }
            if (installLog.isSuccess()) {
                this.persistInstalledConfigurations(session, historyNode, installLog);
            }
            session.save();
            this.wasLastPersistHistoryCallSuccessful = true;
        }
        catch (Exception e) {
            this.wasLastPersistHistoryCallSuccessful = false;
            LOG.error("Could not persist history: " + e, (Throwable)e);
        }
        finally {
            if (session != null) {
                session.logout();
            }
        }
    }

    @Override
    public String[] getInstallationLogPaths() {
        List<AcToolExecution> historyItems = this.getAcToolExecutions();
        String[] result = new String[historyItems.size()];
        int count = 0;
        Iterator<AcToolExecution> historyItemsIt = historyItems.iterator();
        while (historyItemsIt.hasNext()) {
            result[++count - 1] = count + ". " + historyItemsIt.next().toString();
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<AcToolExecution> getAcToolExecutions() {
        Session session = null;
        try {
            List<AcToolExecution> historyItems;
            session = this.repository.loginService(null, null);
            List<AcToolExecution> list = historyItems = HistoryUtils.getAcToolExecutions(session);
            return list;
        }
        catch (RepositoryException e) {
            LOG.error("Could not get history items: " + (Object)((Object)e), (Throwable)e);
            List<AcToolExecution> list = Collections.emptyList();
            return list;
        }
        finally {
            if (session != null) {
                session.logout();
            }
        }
    }

    private String getLogHtml(Session session, String path, boolean includeVerbose) {
        return HistoryUtils.getLogHtml(session, path, includeVerbose);
    }

    private String getLogTxt(Session session, String path, boolean includeVerbose) {
        return HistoryUtils.getLogTxt(session, path, includeVerbose);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getLastInstallationHistory() {
        Session session = null;
        String history = "";
        try {
            session = this.repository.loginService(null, null);
            Node statisticsRootNode = HistoryUtils.getAcHistoryRootNode(session);
            NodeIterator it = statisticsRootNode.getNodes();
            if (it.hasNext()) {
                Node lastHistoryNode = it.nextNode();
                if (lastHistoryNode != null) {
                    history = this.getLogHtml(session, lastHistoryNode.getName(), true);
                }
            } else {
                history = "no history found!";
            }
        }
        catch (RepositoryException e) {
            LOG.error("RepositoryException: {}", (Object)e, (Object)e);
        }
        finally {
            if (session != null) {
                session.logout();
            }
        }
        return history;
    }

    private void persistInstalledConfigurations(Session session, Node historyNode, PersistableInstallationLogger installLog) {
        try {
            Map<String, String> configFileContentsByName = installLog.getConfigFileContentsByName();
            if (configFileContentsByName == null) {
                return;
            }
            String commonPrefix = StringUtils.getCommonPrefix((String[])configFileContentsByName.keySet().toArray(new String[configFileContentsByName.size()]));
            for (String fullConfigFilePath : configFileContentsByName.keySet()) {
                File targetPathFile = new File("installedConfigs/" + StringUtils.substringAfter((String)fullConfigFilePath, (String)commonPrefix));
                File targetPathParentDir = targetPathFile.getParentFile();
                Node configFolder = JcrUtils.getOrCreateByPath((Node)historyNode, (String)(targetPathParentDir != null ? targetPathParentDir.getPath() : targetPathFile.getPath()), (boolean)false, (String)"nt:folder", (String)"nt:folder", (boolean)false);
                ByteArrayInputStream configFileInputStream = new ByteArrayInputStream(configFileContentsByName.get(fullConfigFilePath).getBytes());
                JcrUtils.putFile((Node)configFolder, (String)targetPathFile.getName(), (String)"text/yaml", (InputStream)configFileInputStream);
            }
            installLog.addVerboseMessage(LOG, "Saved installed configuration files under : " + historyNode.getPath() + "/" + INSTALLED_CONFIGS_NODE_NAME);
        }
        catch (RepositoryException e) {
            installLog.addError(LOG, "Exception while saving history node " + historyNode, e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getLogFromHistory(int n, boolean inHtmlFormat, boolean includeVerbose) {
        Session session = null;
        String history = "";
        try {
            session = this.repository.loginService(null, null);
            List<AcToolExecution> acToolExecutions = HistoryUtils.getAcToolExecutions(session);
            if (n <= acToolExecutions.size()) {
                AcToolExecution acToolExecution = acToolExecutions.get(n - 1);
                String path = acToolExecution.getLogsPath();
                history = inHtmlFormat ? this.getLogHtml(session, path, includeVerbose) : this.getLogTxt(session, path, includeVerbose);
            }
        }
        catch (RepositoryException e) {
            LOG.error("RepositoryException: ", (Throwable)e);
        }
        finally {
            if (session != null) {
                session.logout();
            }
        }
        return history;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void persistAcePurgeHistory(PersistableInstallationLogger installLog) {
        Session session = null;
        try {
            session = this.repository.loginService(null, null);
            Node acHistoryRootNode = HistoryUtils.getAcHistoryRootNode(session);
            Node purgeHistoryNode = acHistoryRootNode.addNode("purge_" + System.currentTimeMillis(), "nt:unstructured");
            NodeIterator nodeIt = acHistoryRootNode.getNodes();
            Node previousPurgeNode = null;
            while (nodeIt.hasNext()) {
                Node currNode = nodeIt.nextNode();
                if (!currNode.getName().contains("purge_")) continue;
                previousPurgeNode = currNode;
                break;
            }
            if (previousPurgeNode != null) {
                acHistoryRootNode.orderBefore(purgeHistoryNode.getName(), previousPurgeNode.getName());
            }
            installLog.addMessage(LOG, "Saved history in node: " + purgeHistoryNode.getPath());
            HistoryUtils.setHistoryNodeProperties(purgeHistoryNode, installLog, "purge");
            HistoryUtils.saveLogs(purgeHistoryNode, installLog);
            session.save();
        }
        catch (RepositoryException e) {
            LOG.error("RepositoryException: ", (Throwable)e);
        }
        finally {
            if (session != null) {
                session.logout();
            }
        }
    }

    @Override
    public boolean wasLastPersistHistoryCallSuccessful() {
        return this.wasLastPersistHistoryCallSuccessful;
    }

    @ObjectClassDefinition(name="AC Tool History Service", description="Service that writes & fetches Ac installation histories.", id="biz.netcentric.cq.tools.actool.history.impl.AcHistoryServiceImpl")
    protected static @interface Configuration {
        @AttributeDefinition(name="ACL number of histories to save")
        public int AceService_nrOfSavedHistories() default 7;
    }
}

