/*
 * Decompiled with CFR 0.152.
 */
package biz.netcentric.cq.tools.actool.history.impl;

import biz.netcentric.cq.tools.actool.comparators.TimestampPropertyComparator;
import biz.netcentric.cq.tools.actool.configuploadlistener.impl.UploadListenerServiceImpl;
import biz.netcentric.cq.tools.actool.helper.runtime.RuntimeHelper;
import biz.netcentric.cq.tools.actool.history.AcToolExecution;
import biz.netcentric.cq.tools.actool.history.PersistableInstallationLogger;
import biz.netcentric.cq.tools.actool.history.impl.AcToolExecutionImpl;
import biz.netcentric.cq.tools.actool.jmx.AceServiceMBeanImpl;
import biz.netcentric.cq.tools.actool.ui.AcToolTouchUiServlet;
import biz.netcentric.cq.tools.actool.ui.AcToolWebconsolePlugin;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.PathNotFoundException;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.ValueFormatException;
import javax.jcr.lock.LockException;
import javax.jcr.nodetype.ConstraintViolationException;
import javax.jcr.version.VersionException;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.jackrabbit.commons.JcrUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HistoryUtils {
    private static final Logger LOG = LoggerFactory.getLogger(HistoryUtils.class);
    public static final String LOG_FILE_NAME = "actool.log";
    public static final String LOG_FILE_NAME_VERBOSE = "actool-verbose.log";
    public static final String HISTORY_NODE_NAME_PREFIX = "history_";
    public static final String NODETYPE_NT_UNSTRUCTURED = "nt:unstructured";
    private static final String PROPERTY_SLING_RESOURCE_TYPE = "sling:resourceType";
    public static final String ACHISTORY_ROOT_NODE = "achistory";
    public static final String STATISTICS_ROOT_NODE = "var/statistics";
    public static final String ACHISTORY_PATH = "/var/statistics/achistory";
    private static final String AC_ROOT_PATH_IN_APPS = "/apps/netcentric";
    public static final String AC_HISTORY_PATH_IN_APPS = "/apps/netcentric/achistory";
    public static final String PROPERTY_TIMESTAMP = "timestamp";
    private static final String PROPERTY_MESSAGES = "messages";
    private static final String PROPERTY_EXECUTION_TIME = "executionTime";
    public static final String PROPERTY_SUCCESS = "success";
    private static final String PROPERTY_INSTALLATION_DATE = "installationDate";
    public static final String PROPERTY_INSTALLED_FROM = "installedFrom";
    public static final String PROPERTY_STARTLEVEL = "startlevel";
    public static final String PROPERTY_TRIGGER = "trigger";
    public static final String PROPERTY_CONFIG_ROOT_PATH = "configurationRootPath";
    public static final String PROPERTY_ACL_CHANGES = "aclsChanges";
    public static final String PROPERTY_AUTHORIZABLES_CHANGES = "authorizableChanges";
    private static final String AC_TOOL_STARTUPHOOK_CLASS = "biz.netcentric.cq.tools.actool.startuphook.impl.AcToolStartupHookServiceImpl";
    private static final String BUNDLE_START_TASK_CLASS = "org.apache.sling.installer.core.impl.tasks.BundleStartTask";

    public static Node getAcHistoryRootNode(Session session) throws RepositoryException {
        Node rootNode = session.getRootNode();
        Node statisticsRootNode = HistoryUtils.safeGetNode(rootNode, STATISTICS_ROOT_NODE, NODETYPE_NT_UNSTRUCTURED);
        Node acHistoryRootNode = HistoryUtils.safeGetNode(statisticsRootNode, ACHISTORY_ROOT_NODE, "sling:OrderedFolder");
        return acHistoryRootNode;
    }

    public static Node persistHistory(Session session, PersistableInstallationLogger installLog, int nrOfHistoriesToSave) throws RepositoryException {
        String trigger;
        Node acHistoryRootNode = HistoryUtils.getAcHistoryRootNode(session);
        String name = HISTORY_NODE_NAME_PREFIX + System.currentTimeMillis();
        StackTraceElement[] stackTrace = Thread.currentThread().getStackTrace();
        if (StringUtils.isNotBlank((CharSequence)installLog.getCrxPackageName())) {
            trigger = "installhook";
        } else if (HistoryUtils.isInStrackTracke(stackTrace, AceServiceMBeanImpl.class)) {
            trigger = "jmx";
        } else if (HistoryUtils.isInStrackTracke(stackTrace, AcToolTouchUiServlet.class)) {
            trigger = "aem_admin_ui";
        } else if (HistoryUtils.isInStrackTracke(stackTrace, UploadListenerServiceImpl.AcToolConfigUpdateListener.class)) {
            trigger = "changelistener";
        } else if (HistoryUtils.isInStrackTracke(stackTrace, AcToolWebconsolePlugin.class)) {
            trigger = "webconsole";
        } else if (HistoryUtils.isInStrackTracke(stackTrace, AC_TOOL_STARTUPHOOK_CLASS)) {
            if (HistoryUtils.isInStrackTracke(stackTrace, BUNDLE_START_TASK_CLASS)) {
                trigger = "startup_hook_pckmgr)";
            } else {
                boolean isImageBuild;
                boolean bl = isImageBuild = RuntimeHelper.isCloudReadyInstance() && !session.itemExists(AC_HISTORY_PATH_IN_APPS);
                trigger = isImageBuild ? "startup_hook_image_build" : "startup_hook";
            }
        } else {
            trigger = "api";
            name = name + "api";
        }
        name = name + "_via_" + trigger;
        Node newHistoryNode = HistoryUtils.safeGetNode(acHistoryRootNode, name, NODETYPE_NT_UNSTRUCTURED);
        String path = newHistoryNode.getPath();
        HistoryUtils.setHistoryNodeProperties(newHistoryNode, installLog, trigger);
        HistoryUtils.saveLogs(newHistoryNode, installLog);
        HistoryUtils.deleteObsoleteHistoryNodes(acHistoryRootNode, nrOfHistoriesToSave);
        Node previousHistoryNode = (Node)acHistoryRootNode.getNodes().next();
        if (previousHistoryNode != null) {
            acHistoryRootNode.orderBefore(newHistoryNode.getName(), previousHistoryNode.getName());
        }
        LOG.info("Saved history in node: {}", (Object)path);
        return newHistoryNode;
    }

    static void saveLogs(Node historyNode, PersistableInstallationLogger installLog) throws RepositoryException {
        JcrUtils.putFile((Node)historyNode, (String)LOG_FILE_NAME_VERBOSE, (String)"text/plain", (InputStream)new ByteArrayInputStream(installLog.getVerboseMessageHistory().getBytes()));
        JcrUtils.putFile((Node)historyNode, (String)LOG_FILE_NAME, (String)"text/plain", (InputStream)new ByteArrayInputStream(installLog.getMessageHistory().getBytes()));
    }

    private static boolean isInStrackTracke(StackTraceElement[] stackTrace, Class<?> classToSearch) {
        return HistoryUtils.isInStrackTracke(stackTrace, classToSearch.getName());
    }

    private static boolean isInStrackTracke(StackTraceElement[] stackTrace, String classToSearch) {
        for (StackTraceElement stackTraceElement : stackTrace) {
            if (!classToSearch.equals(stackTraceElement.getClassName())) continue;
            return true;
        }
        return false;
    }

    private static Node safeGetNode(Node baseNode, String name, String typeToCreate) throws RepositoryException {
        if (!baseNode.hasNode(name)) {
            LOG.debug("create node: {}", (Object)name);
            return baseNode.addNode(name, typeToCreate);
        }
        return baseNode.getNode(name);
    }

    public static void setHistoryNodeProperties(Node historyNode, PersistableInstallationLogger installLog, String trigger) throws ValueFormatException, VersionException, LockException, ConstraintViolationException, RepositoryException {
        historyNode.setProperty(PROPERTY_INSTALLATION_DATE, installLog.getInstallationDate().toString());
        historyNode.setProperty(PROPERTY_SUCCESS, installLog.isSuccess());
        historyNode.setProperty(PROPERTY_EXECUTION_TIME, installLog.getExecutionTime());
        historyNode.setProperty(PROPERTY_STARTLEVEL, (long)RuntimeHelper.getCurrentStartLevel());
        historyNode.setProperty(PROPERTY_TRIGGER, trigger);
        historyNode.setProperty(PROPERTY_ACL_CHANGES, (long)installLog.getCountAclsChanged());
        historyNode.setProperty(PROPERTY_AUTHORIZABLES_CHANGES, (long)installLog.getCountAuthorizablesCreated() + (long)installLog.getCountAuthorizablesMoved());
        historyNode.setProperty(PROPERTY_CONFIG_ROOT_PATH, HistoryUtils.getEffectiveConfigRootPath(installLog));
        historyNode.setProperty(PROPERTY_TIMESTAMP, installLog.getInstallationDate().getTime());
        historyNode.setProperty(PROPERTY_SLING_RESOURCE_TYPE, "/apps/netcentric/actool/components/historyRenderer");
        Map<String, String> configFileContentsByName = installLog.getConfigFileContentsByName();
        if (configFileContentsByName != null) {
            String crxPackageName = installLog.getCrxPackageName();
            historyNode.setProperty(PROPERTY_INSTALLED_FROM, StringUtils.defaultString((String)crxPackageName));
        }
    }

    private static String getEffectiveConfigRootPath(PersistableInstallationLogger installLog) {
        Map<String, String> configFileContentsByName = installLog.getConfigFileContentsByName();
        if (configFileContentsByName == null) {
            return null;
        }
        Set<String> configFiles = configFileContentsByName.keySet();
        String effectiveConfigRootPath = StringUtils.getCommonPrefix((String[])configFiles.toArray(new String[configFiles.size()]));
        effectiveConfigRootPath = StringUtils.removeStart((String)effectiveConfigRootPath, (String)"//jcr_root");
        effectiveConfigRootPath = StringUtils.removeEnd((String)effectiveConfigRootPath, (String)"/");
        return effectiveConfigRootPath;
    }

    private static void deleteObsoleteHistoryNodes(Node acHistoryRootNode, int nrOfHistoriesToSave) throws RepositoryException {
        NodeIterator childNodeIt = acHistoryRootNode.getNodes();
        TreeSet<Node> historyChildNodes = new TreeSet<Node>(new TimestampPropertyComparator());
        while (childNodeIt.hasNext()) {
            Node node = childNodeIt.nextNode();
            if (!node.getName().startsWith(HISTORY_NODE_NAME_PREFIX)) continue;
            historyChildNodes.add(node);
        }
        int index = 1;
        for (Node node : historyChildNodes) {
            if (index > nrOfHistoriesToSave) {
                LOG.debug("delete obsolete history node: ", (Object)node.getPath());
                node.remove();
            }
            ++index;
        }
    }

    static List<AcToolExecution> getAcToolExecutions(Session session) throws RepositoryException, PathNotFoundException {
        Node acHistoryRootNode = HistoryUtils.getAcHistoryRootNode(session);
        TreeSet<AcToolExecutionImpl> historyInfos = new TreeSet<AcToolExecutionImpl>();
        NodeIterator iterator = acHistoryRootNode.getNodes();
        while (iterator.hasNext()) {
            Node node = (Node)iterator.next();
            if (node == null || !node.getName().startsWith(HISTORY_NODE_NAME_PREFIX)) continue;
            String configRoot = node.hasProperty(PROPERTY_CONFIG_ROOT_PATH) ? node.getProperty(PROPERTY_CONFIG_ROOT_PATH).getString() : null;
            int authorizableChanges = node.hasProperty(PROPERTY_AUTHORIZABLES_CHANGES) ? (int)node.getProperty(PROPERTY_AUTHORIZABLES_CHANGES).getLong() : -1;
            int aclChanges = node.hasProperty(PROPERTY_ACL_CHANGES) ? (int)node.getProperty(PROPERTY_ACL_CHANGES).getLong() : -1;
            historyInfos.add(new AcToolExecutionImpl(node.getPath(), new Date(node.getProperty(PROPERTY_TIMESTAMP).getLong()), node.getProperty(PROPERTY_SUCCESS).getBoolean(), configRoot, authorizableChanges, aclChanges));
        }
        return new ArrayList<AcToolExecution>(historyInfos);
    }

    public static String getLogTxt(Session session, String path, boolean includeVerbose) {
        return HistoryUtils.getLog(session, path, "\n", includeVerbose).toString();
    }

    public static String getLogHtml(Session session, String path, boolean includeVerbose) {
        return HistoryUtils.getLog(session, path, "<br />", includeVerbose).toString();
    }

    public static String getLog(Session session, String path, String lineFeedSymbol, boolean includeVerbose) {
        StringBuilder sb = new StringBuilder();
        try {
            Node historyNode;
            Node node = historyNode = path.startsWith("/") ? session.getNode(path) : HistoryUtils.getAcHistoryRootNode(session).getNode(path);
            if (historyNode != null) {
                sb.append("Installation triggered: " + historyNode.getProperty(PROPERTY_INSTALLATION_DATE).getString());
                if (historyNode.hasProperty(PROPERTY_MESSAGES)) {
                    sb.append(lineFeedSymbol + historyNode.getProperty(PROPERTY_MESSAGES).getString().replace("\n", lineFeedSymbol));
                } else {
                    Node logFileNode = includeVerbose ? historyNode.getNode(LOG_FILE_NAME_VERBOSE) : historyNode.getNode(LOG_FILE_NAME);
                    sb.append(lineFeedSymbol + IOUtils.toString((InputStream)JcrUtils.readFile((Node)logFileNode)).replace("\n", lineFeedSymbol));
                }
                sb.append(lineFeedSymbol + "Execution time: " + historyNode.getProperty(PROPERTY_EXECUTION_TIME).getLong() + " ms");
                sb.append(lineFeedSymbol + "Success: " + historyNode.getProperty(PROPERTY_SUCCESS).getBoolean());
            }
        }
        catch (IOException | RepositoryException e) {
            sb.append(lineFeedSymbol + "ERROR while retrieving log: " + e);
            LOG.error("ERROR while retrieving log: " + e, e);
        }
        return sb.toString();
    }
}

