/*
 * Decompiled with CFR 0.152.
 */
package biz.netcentric.cq.tools.actool.installhook.impl;

import biz.netcentric.cq.tools.actool.configreader.ConfigFilesRetriever;
import biz.netcentric.cq.tools.actool.history.PersistableInstallationLogger;
import biz.netcentric.cq.tools.actool.history.ProgressTrackerListenerInstallationLogger;
import biz.netcentric.cq.tools.actool.impl.AcInstallationServiceInternal;
import biz.netcentric.cq.tools.actool.installhook.impl.AcToolInstallHookService;
import java.util.ArrayList;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import javax.jcr.Session;
import org.apache.jackrabbit.vault.fs.api.ProgressTrackerListener;
import org.apache.jackrabbit.vault.fs.io.Archive;
import org.apache.jackrabbit.vault.packaging.VaultPackage;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferencePolicyOption;

@Component
public class AcToolInstallHookServiceImpl
implements AcToolInstallHookService {
    public static final String ACL_HOOK_PATHS = "actool.installhook.configFilesPattern(.*)";
    private static final String JCR_ROOT_PREFIX = "/jcr_root";
    @Reference(policyOption=ReferencePolicyOption.GREEDY)
    private AcInstallationServiceInternal acInstallationService;
    @Reference(policyOption=ReferencePolicyOption.GREEDY)
    private ConfigFilesRetriever configFilesRetriever;

    @Override
    public PersistableInstallationLogger installYamlFilesFromPackage(VaultPackage vaultPackage, Session session, ProgressTrackerListener progressTrackerListener) throws Exception {
        Archive archive = vaultPackage.getArchive();
        Properties packageProperties = vaultPackage.getMetaInf().getProperties();
        ArrayList<String> configPathPatterns = new ArrayList<String>();
        Set<Object> propertiesKeys = packageProperties.keySet();
        for (Object property : propertiesKeys) {
            if (!property.toString().matches(ACL_HOOK_PATHS)) continue;
            configPathPatterns.add(JCR_ROOT_PREFIX + packageProperties.getProperty(property.toString()));
        }
        PersistableInstallationLogger history = progressTrackerListener != null ? new ProgressTrackerListenerInstallationLogger(progressTrackerListener) : new PersistableInstallationLogger();
        Map<String, String> configs = this.configFilesRetriever.getConfigFileContentFromPackage(archive, configPathPatterns);
        history.setCrxPackageName(this.getArchiveName(archive));
        String[] restrictedToPaths = null;
        this.acInstallationService.installConfigurationFiles(history, configs, restrictedToPaths, session);
        return history;
    }

    private String getArchiveName(Archive archive) {
        Properties properties = archive.getMetaInf().getProperties();
        String archiveName = properties != null ? properties.getProperty("name") + "-" + properties.getProperty("version") : null;
        return archiveName;
    }
}

