/*
 * Decompiled with CFR 0.152.
 */
package biz.netcentric.cq.tools.actool.authorizableinstaller.impl;

import biz.netcentric.cq.tools.actool.authorizableinstaller.AuthorizableCreatorException;
import biz.netcentric.cq.tools.actool.authorizableinstaller.AuthorizableInstallerService;
import biz.netcentric.cq.tools.actool.authorizableinstaller.impl.AuthInstallerUserManager;
import biz.netcentric.cq.tools.actool.authorizableinstaller.impl.AuthInstallerUserManagerPrefetchingImpl;
import biz.netcentric.cq.tools.actool.authorizableinstaller.impl.ExternalGroupInstallerServiceImpl;
import biz.netcentric.cq.tools.actool.authorizableinstaller.impl.ImpersonationInstallerServiceImpl;
import biz.netcentric.cq.tools.actool.configmodel.AcConfiguration;
import biz.netcentric.cq.tools.actool.configmodel.AuthorizableConfigBean;
import biz.netcentric.cq.tools.actool.configmodel.AuthorizablesConfig;
import biz.netcentric.cq.tools.actool.configmodel.pkcs.RandomPassword;
import biz.netcentric.cq.tools.actool.crypto.DecryptionService;
import biz.netcentric.cq.tools.actool.helper.AcHelper;
import biz.netcentric.cq.tools.actool.helper.AccessControlUtils;
import biz.netcentric.cq.tools.actool.helper.ContentHelper;
import biz.netcentric.cq.tools.actool.history.InstallationLogger;
import com.adobe.granite.keystore.KeyStoreNotInitialisedException;
import com.adobe.granite.keystore.KeyStoreService;
import java.io.IOException;
import java.security.GeneralSecurityException;
import java.security.Key;
import java.security.Principal;
import java.security.cert.Certificate;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import javax.jcr.Credentials;
import javax.jcr.LoginException;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.SimpleCredentials;
import javax.jcr.UnsupportedRepositoryOperationException;
import javax.jcr.ValueFactory;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.jackrabbit.api.security.user.Authorizable;
import org.apache.jackrabbit.api.security.user.AuthorizableExistsException;
import org.apache.jackrabbit.api.security.user.Group;
import org.apache.jackrabbit.api.security.user.User;
import org.apache.jackrabbit.oak.spi.security.principal.PrincipalImpl;
import org.apache.sling.api.SlingIOException;
import org.apache.sling.api.resource.PersistenceException;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.resource.ResourceResolverFactory;
import org.apache.sling.jcr.api.SlingRepository;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.osgi.service.component.annotations.ReferencePolicyOption;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component
public class AuthorizableInstallerServiceImpl
implements AuthorizableInstallerService {
    private static final Logger LOG = LoggerFactory.getLogger(AuthorizableInstallerServiceImpl.class);
    private static final String PATH_SEGMENT_SYSTEMUSERS = "system";
    public static final String REP_EXTERNAL_ID = "rep:externalId";
    private static final String USER_KEYSTORE_FOLDER = "keystore";
    @Reference(cardinality=ReferenceCardinality.OPTIONAL, policyOption=ReferencePolicyOption.GREEDY)
    ExternalGroupInstallerServiceImpl externalGroupCreatorService;
    @Reference(cardinality=ReferenceCardinality.OPTIONAL, policyOption=ReferencePolicyOption.GREEDY)
    ImpersonationInstallerServiceImpl impersonationInstallerService;
    @Reference(policyOption=ReferencePolicyOption.GREEDY)
    DecryptionService decryptionService;
    @Reference(cardinality=ReferenceCardinality.OPTIONAL, policy=ReferencePolicy.DYNAMIC, policyOption=ReferencePolicyOption.GREEDY)
    volatile KeyStoreService keyStoreService;
    @Reference(policyOption=ReferencePolicyOption.GREEDY)
    ResourceResolverFactory resourceResolverFactory;
    @Reference(policyOption=ReferencePolicyOption.GREEDY)
    SlingRepository repository;

    @Override
    public void installAuthorizables(AcConfiguration acConfiguration, AuthorizablesConfig authorizablesConfigBeans, Session session, InstallationLogger installLog) throws RepositoryException, AuthorizableCreatorException, org.apache.sling.api.resource.LoginException, IOException, GeneralSecurityException {
        AuthInstallerUserManagerPrefetchingImpl userManager = new AuthInstallerUserManagerPrefetchingImpl(AccessControlUtils.getUserManagerAutoSaveDisabled(session), session.getValueFactory(), installLog);
        Set<String> authorizablesFromConfigurations = authorizablesConfigBeans.getAuthorizableIds();
        for (AuthorizableConfigBean authorizableConfigBean : authorizablesConfigBeans) {
            this.installAuthorizableConfigurationBean(session, userManager, acConfiguration, authorizableConfigBean, installLog, authorizablesFromConfigurations);
        }
        installLog.addMessage(LOG, "Created " + installLog.getCountAuthorizablesCreated() + " authorizables (moved " + installLog.getCountAuthorizablesMoved() + " authorizables)");
    }

    private void installAuthorizableConfigurationBean(Session session, AuthInstallerUserManager userManager, AcConfiguration acConfiguration, AuthorizableConfigBean authorizableConfigBean, InstallationLogger installLog, Set<String> authorizablesFromConfigurations) throws RepositoryException, AuthorizableCreatorException, IOException, GeneralSecurityException, org.apache.sling.api.resource.LoginException {
        String authorizableId = authorizableConfigBean.getAuthorizableId();
        LOG.debug("- start installation of authorizable: {}", (Object)authorizableId);
        Authorizable authorizableToInstall = userManager.getAuthorizable(authorizableId);
        if (StringUtils.equals((CharSequence)authorizableId, (CharSequence)"everyone")) {
            if (ArrayUtils.isNotEmpty((Object[])authorizableConfigBean.getIsMemberOf()) || ArrayUtils.isNotEmpty((Object[])authorizableConfigBean.getMembers()) || StringUtils.isNotBlank((CharSequence)authorizableConfigBean.getMigrateFrom())) {
                throw new IllegalArgumentException("The special group everyone does not support setting properties 'members', 'isMemberOf' and 'migrateFrom'");
            }
            this.setAuthorizableProperties(authorizableToInstall, authorizableConfigBean, acConfiguration.getAuthorizablesConfig(), session, installLog);
            return;
        }
        if (authorizableToInstall == null) {
            authorizableToInstall = this.createNewAuthorizable(acConfiguration, authorizableConfigBean, installLog, userManager, session);
            installLog.incCountAuthorizablesCreated();
        } else {
            this.setAuthorizableProperties(authorizableToInstall, authorizableConfigBean, acConfiguration.getAuthorizablesConfig(), session, installLog);
            if (!authorizableToInstall.isGroup() && !authorizableConfigBean.isSystemUser() && StringUtils.isNotBlank((CharSequence)authorizableConfigBean.getPassword())) {
                this.setUserPassword(authorizableConfigBean, (User)authorizableToInstall, installLog);
            }
            this.handleRecreationOfAuthorizableIfNecessary(session, acConfiguration, authorizableConfigBean, installLog, userManager);
            this.applyGroupMembershipConfigIsMemberOf(installLog, acConfiguration, authorizableConfigBean, userManager, session, authorizablesFromConfigurations);
        }
        this.applyGroupMembershipConfigMembers(acConfiguration, authorizableConfigBean, installLog, authorizableId, userManager, authorizablesFromConfigurations);
        if (StringUtils.isNotBlank((CharSequence)authorizableConfigBean.getMigrateFrom()) && authorizableConfigBean.isGroup()) {
            this.migrateFromOldGroup(authorizableConfigBean, userManager, installLog);
        }
        if (authorizableConfigBean.getKeys() != null) {
            try {
                this.installKeys(authorizableConfigBean.isAppendToKeyStore(), (User)authorizableToInstall, authorizableConfigBean.getKeys(), authorizableId, this.decryptionService.decrypt(authorizableConfigBean.getKeyStorePassword()), session, installLog);
            }
            catch (UnsupportedOperationException e) {
                throw new AuthorizableCreatorException("Could not decrypt key store password for user " + authorizableConfigBean.getAuthorizableId() + ": " + e.getMessage(), e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void installKeys(boolean appendToKeyStore, User user, Map<String, biz.netcentric.cq.tools.actool.configmodel.pkcs.Key> keys, String userId, String keyStorePassword, Session session, InstallationLogger installLog) throws org.apache.sling.api.resource.LoginException, SlingIOException, SecurityException, KeyStoreNotInitialisedException, IOException, GeneralSecurityException, UnsupportedRepositoryOperationException, RepositoryException {
        HashMap<String, Session> authInfo = new HashMap<String, Session>();
        authInfo.put("user.jcr.session", session);
        try (ResourceResolver resolver = this.resourceResolverFactory.getResourceResolver(authInfo);){
            if (!appendToKeyStore) {
                this.removeKeyStore(resolver, user, installLog);
            }
            this.installKeys(keys, userId, keyStorePassword, resolver, installLog);
        }
    }

    private void removeKeyStore(ResourceResolver resolver, User user, InstallationLogger installLog) throws UnsupportedRepositoryOperationException, RepositoryException, PersistenceException {
        String keyStorePath = user.getPath() + "/" + USER_KEYSTORE_FOLDER;
        Resource keyStoreResource = resolver.getResource(keyStorePath);
        if (keyStoreResource != null) {
            installLog.addMessage(LOG, "Deleting old key store for user  '" + user.getID() + "'");
            resolver.delete(keyStoreResource);
        } else {
            installLog.addMessage(LOG, "No key store for user  '" + user.getID() + "' found to delete");
        }
    }

    private void installKeys(Map<String, biz.netcentric.cq.tools.actool.configmodel.pkcs.Key> keys, String userId, String keyStorePassword, ResourceResolver resourceResolver, InstallationLogger installLog) throws SlingIOException, SecurityException, KeyStoreNotInitialisedException, IOException, GeneralSecurityException {
        if (this.keyStoreService == null) {
            throw new IllegalStateException("Keys are used on the authorizable which require the AEM KeyStore Service which is missing.");
        }
        if (!this.keyStoreService.keyStoreExists(resourceResolver, userId)) {
            char[] keyStorePasswordCharArray;
            boolean isRandomPassword = false;
            if (keyStorePassword == null || keyStorePassword.isEmpty()) {
                keyStorePasswordCharArray = RandomPassword.generate(20);
                isRandomPassword = true;
            } else {
                keyStorePasswordCharArray = keyStorePassword.toCharArray();
            }
            this.keyStoreService.createKeyStore(resourceResolver, userId, keyStorePasswordCharArray);
            installLog.addMessage(LOG, "Created new key store with " + (isRandomPassword ? "random" : "predefined") + " password for user  '" + userId + "'");
        } else if (keyStorePassword != null) {
            installLog.addWarning(LOG, "Key store for user " + userId + " does already exist, ignoring configured 'keystorePassword'");
        }
        for (Map.Entry<String, biz.netcentric.cq.tools.actool.configmodel.pkcs.Key> entry : keys.entrySet()) {
            Certificate certificate = entry.getValue().getCertificate();
            if (certificate != null) {
                this.keyStoreService.addKeyStoreKeyEntry(resourceResolver, userId, entry.getKey(), (Key)entry.getValue().getPrivateKey(), new Certificate[]{certificate});
            } else {
                this.keyStoreService.addKeyStoreKeyPair(resourceResolver, userId, entry.getValue().getKeyPair(), entry.getKey());
            }
            installLog.addMessage(LOG, "Added key with alias '" + entry.getKey() + "' to keystore of user '" + userId + "'");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setUserPassword(AuthorizableConfigBean authorizableConfigBean, User authorizableToInstall, InstallationLogger installLog) throws RepositoryException, AuthorizableCreatorException {
        String userId = authorizableToInstall.getID();
        String password = this.getPassword(authorizableConfigBean);
        Session sessionForUser = null;
        try {
            sessionForUser = this.repository.login((Credentials)new SimpleCredentials(userId, password.toCharArray()));
            LOG.trace("Could obtain session {} for user {}, will not update password", (Object)sessionForUser, (Object)userId);
            installLog.addVerboseMessage(LOG, "Password of user " + userId + " has not changed");
        }
        catch (LoginException e) {
            LOG.trace("User {} could not log in with existing password", (Object)userId, (Object)e);
            authorizableToInstall.changePassword(password);
            installLog.addMessage(LOG, "Changed password of user " + userId);
        }
        finally {
            if (sessionForUser != null) {
                sessionForUser.logout();
            }
        }
    }

    private String getPassword(AuthorizableConfigBean authorizableConfigBean) throws AuthorizableCreatorException {
        try {
            String password = authorizableConfigBean.getPassword();
            return this.decryptionService.decrypt(password);
        }
        catch (UnsupportedOperationException e) {
            throw new AuthorizableCreatorException("Could not decrypt password for user " + authorizableConfigBean.getAuthorizableId() + ": " + e.getMessage(), e);
        }
    }

    void applyGroupMembershipConfigMembers(AcConfiguration acConfiguration, AuthorizableConfigBean authorizableConfigBean, InstallationLogger installLog, String authorizableId, AuthInstallerUserManager userManager, Set<String> authorizablesFromConfigurations) throws RepositoryException {
        if (authorizableConfigBean.isGroup()) {
            Authorizable memberGroup;
            String[] membersInConfigArr = authorizableConfigBean.getMembers();
            HashSet<String> membersInConfig = membersInConfigArr != null ? new HashSet<String>(Arrays.asList(membersInConfigArr)) : new HashSet();
            Set<String> relevantMembersInRepo = userManager.getDeclaredMembersWithoutRegularUsers(authorizableId);
            relevantMembersInRepo = new HashSet<String>(CollectionUtils.subtract(relevantMembersInRepo, authorizablesFromConfigurations));
            relevantMembersInRepo = this.removeExternalMembersUnmanagedByConfiguration(acConfiguration, authorizableConfigBean, relevantMembersInRepo, installLog);
            HashSet membersToAdd = new HashSet(CollectionUtils.subtract(membersInConfig, relevantMembersInRepo));
            HashSet membersToRemove = new HashSet(CollectionUtils.subtract(relevantMembersInRepo, membersInConfig));
            Group installedGroup = (Group)userManager.getAuthorizable(authorizableId);
            if (!membersToAdd.isEmpty()) {
                installLog.addVerboseMessage(LOG, "Adding " + membersToAdd.size() + " external members to group " + authorizableConfigBean.getAuthorizableId());
                for (String member : membersToAdd) {
                    memberGroup = userManager.getAuthorizable(member);
                    if (memberGroup == null) {
                        throw new IllegalStateException("Member " + member + " does not exist and cannot be added as external member to group " + authorizableConfigBean.getAuthorizableId());
                    }
                    installedGroup.addMember(memberGroup);
                    installLog.addVerboseMessage(LOG, "Adding " + member + " as external member to group " + authorizableConfigBean.getAuthorizableId());
                }
            }
            if (!membersToRemove.isEmpty()) {
                installLog.addVerboseMessage(LOG, "Removing " + membersToRemove.size() + " external members from group " + authorizableConfigBean.getAuthorizableId());
                for (String member : membersToRemove) {
                    memberGroup = userManager.getAuthorizable(member);
                    installedGroup.removeMember(memberGroup);
                    installLog.addVerboseMessage(LOG, "Removing " + member + " as external member from group " + authorizableConfigBean.getAuthorizableId());
                }
            }
        }
    }

    private Set<String> removeExternalMembersUnmanagedByConfiguration(AcConfiguration acConfiguration, AuthorizableConfigBean authorizableConfigBean, Set<String> relevantMembersInRepo, InstallationLogger installLog) {
        HashSet<String> relevantMembers = new HashSet<String>(relevantMembersInRepo);
        Pattern unmanagedExternalMembersRegex = authorizableConfigBean.getUnmanagedExternalMembersRegex();
        if (unmanagedExternalMembersRegex == null) {
            unmanagedExternalMembersRegex = acConfiguration.getGlobalConfiguration().getDefaultUnmanagedExternalMembersRegex();
        }
        HashSet<String> unmanagedMembers = new HashSet<String>();
        if (unmanagedExternalMembersRegex != null) {
            Iterator relevantMembersIt = relevantMembers.iterator();
            while (relevantMembersIt.hasNext()) {
                String member = (String)relevantMembersIt.next();
                if (!unmanagedExternalMembersRegex.matcher(member).matches()) continue;
                unmanagedMembers.add(member);
                relevantMembersIt.remove();
            }
        }
        if (!unmanagedMembers.isEmpty()) {
            installLog.addVerboseMessage(LOG, "Not removing members " + unmanagedMembers + " from " + authorizableConfigBean.getAuthorizableId() + " because of unmanagedExternalMembersRegex=" + unmanagedExternalMembersRegex);
        }
        return relevantMembers;
    }

    private void migrateFromOldGroup(AuthorizableConfigBean authorizableConfigBean, AuthInstallerUserManager userManager, InstallationLogger installLog) throws RepositoryException {
        Authorizable groupForMigration = userManager.getAuthorizable(authorizableConfigBean.getMigrateFrom());
        String authorizableId = authorizableConfigBean.getAuthorizableId();
        if (groupForMigration == null) {
            installLog.addMessage(LOG, "Group " + authorizableConfigBean.getMigrateFrom() + " does not exist (specified as migrateFrom in group " + authorizableId + ") - no action taken");
            return;
        }
        if (!groupForMigration.isGroup()) {
            installLog.addWarning(LOG, "Specifying a user in 'migrateFrom' does not make sense (migrateFrom=" + authorizableConfigBean.getMigrateFrom() + " in " + authorizableId + ")");
            return;
        }
        installLog.addMessage(LOG, "Migrating from group " + authorizableConfigBean.getMigrateFrom() + "  to " + authorizableId);
        HashSet<Authorizable> usersFromGroupToTakeOver = new HashSet<Authorizable>();
        Iterator membersIt = ((Group)groupForMigration).getMembers();
        while (membersIt.hasNext()) {
            Authorizable member = (Authorizable)membersIt.next();
            if (member.isGroup()) continue;
            usersFromGroupToTakeOver.add(member);
        }
        if (!usersFromGroupToTakeOver.isEmpty()) {
            installLog.addMessage(LOG, "- Taking over " + usersFromGroupToTakeOver.size() + " member users from group " + authorizableConfigBean.getMigrateFrom() + " to group " + authorizableId);
            Group currentGroup = (Group)userManager.getAuthorizable(authorizableId);
            for (Authorizable user : usersFromGroupToTakeOver) {
                currentGroup.addMember(user);
            }
        }
        userManager.removeAuthorizable(groupForMigration);
        installLog.addMessage(LOG, "- Deleted group " + authorizableConfigBean.getMigrateFrom());
    }

    private void handleRecreationOfAuthorizableIfNecessary(Session session, AcConfiguration acConfiguration, AuthorizableConfigBean principalConfigBean, InstallationLogger installLog, AuthInstallerUserManager userManager) throws RepositoryException, AuthorizableCreatorException {
        String externalIdConfig;
        String externalIdExistingAuthorizable;
        boolean externalIdHasChanged;
        boolean pathHasChanged;
        String authorizableId = principalConfigBean.getAuthorizableId();
        Authorizable existingAuthorizable = userManager.getAuthorizable(authorizableId);
        String intermediatedPathOfExistingAuthorizable = existingAuthorizable.getPath().substring(0, existingAuthorizable.getPath().lastIndexOf("/"));
        String authorizablePathFromBean = principalConfigBean.getPath();
        if (StringUtils.isNotEmpty((CharSequence)authorizablePathFromBean) && authorizablePathFromBean.charAt(0) != '/') {
            authorizablePathFromBean = (principalConfigBean.isGroup() ? "/home/groups" : "/home/users") + (principalConfigBean.isSystemUser() && !authorizablePathFromBean.startsWith(PATH_SEGMENT_SYSTEMUSERS) ? "/system" : "") + "/" + authorizablePathFromBean;
        }
        boolean bl = pathHasChanged = !StringUtils.equals((CharSequence)intermediatedPathOfExistingAuthorizable, (CharSequence)authorizablePathFromBean) && StringUtils.isNotBlank((CharSequence)principalConfigBean.getPath());
        if (pathHasChanged) {
            installLog.addMessage(LOG, "Found change of intermediate path for " + existingAuthorizable.getID() + ": " + intermediatedPathOfExistingAuthorizable + " -> " + authorizablePathFromBean);
        }
        boolean bl2 = externalIdHasChanged = !StringUtils.equals((CharSequence)(externalIdExistingAuthorizable = (String)StringUtils.defaultIfEmpty((CharSequence)AcHelper.valuesToString(existingAuthorizable.getProperty(REP_EXTERNAL_ID)), (CharSequence)"")), (CharSequence)(externalIdConfig = (String)StringUtils.defaultIfEmpty((CharSequence)principalConfigBean.getExternalId(), (CharSequence)"")));
        if (externalIdHasChanged) {
            installLog.addMessage(LOG, "Found change of external id of " + existingAuthorizable.getID() + ": '" + externalIdExistingAuthorizable + "' (current) is not '" + externalIdConfig + "' (in config)");
        }
        if (pathHasChanged || externalIdHasChanged) {
            HashSet<Authorizable> membersOfDeletedGroup = new HashSet<Authorizable>();
            if (existingAuthorizable.isGroup()) {
                Group existingGroup = (Group)existingAuthorizable;
                Iterator memberIt = existingGroup.getDeclaredMembers();
                while (memberIt.hasNext()) {
                    membersOfDeletedGroup.add((Authorizable)memberIt.next());
                }
            }
            userManager.removeAuthorizable(existingAuthorizable);
            Authorizable newAuthorizable = this.createNewAuthorizable(acConfiguration, principalConfigBean, installLog, userManager, session);
            int countMovedMembersOfGroup = 0;
            if (newAuthorizable.isGroup()) {
                Group newGroup = (Group)newAuthorizable;
                for (Authorizable authorizable : membersOfDeletedGroup) {
                    newGroup.addMember(authorizable);
                    ++countMovedMembersOfGroup;
                }
            }
            this.deleteOldIntermediatePath(session, session.getNode(intermediatedPathOfExistingAuthorizable));
            installLog.addMessage(LOG, "Recreated authorizable " + newAuthorizable + " at path " + newAuthorizable.getPath() + (newAuthorizable.isGroup() ? "(retained " + countMovedMembersOfGroup + " members of group)" : ""));
            installLog.incCountAuthorizablesMoved();
        }
    }

    private void deleteOldIntermediatePath(Session session, Node oldIntermediateNode) throws RepositoryException {
        while (!(StringUtils.equals((CharSequence)"/home/groups", (CharSequence)oldIntermediateNode.getPath()) || StringUtils.equals((CharSequence)"/home/users", (CharSequence)oldIntermediateNode.getPath()) || oldIntermediateNode.hasNodes())) {
            Node parent = oldIntermediateNode.getParent();
            session.removeItem(oldIntermediateNode.getPath());
            oldIntermediateNode = parent;
        }
    }

    private void applyGroupMembershipConfigIsMemberOf(InstallationLogger installLog, AcConfiguration acConfiguration, AuthorizableConfigBean authorizableConfigBean, AuthInstallerUserManager userManager, Session session, Set<String> authorizablesFromConfigurations) throws RepositoryException, AuthorizableCreatorException {
        String authId = authorizableConfigBean.getAuthorizableId();
        Set<String> membershipGroupsFromConfig = this.getMembershipGroupsFromConfig(authorizableConfigBean.getIsMemberOf());
        Set<String> membershipGroupsFromRepository = userManager.getDeclaredIsMemberOf(authId);
        this.applyGroupMembershipConfigIsMemberOf(authorizableConfigBean, acConfiguration, installLog, userManager, session, membershipGroupsFromConfig, membershipGroupsFromRepository, authorizablesFromConfigurations);
    }

    private Authorizable createNewAuthorizable(AcConfiguration acConfiguration, AuthorizableConfigBean principalConfigBean, InstallationLogger installLog, AuthInstallerUserManager userManager, Session session) throws AuthorizableExistsException, RepositoryException, AuthorizableCreatorException {
        boolean isGroup = principalConfigBean.isGroup();
        String authorizableId = principalConfigBean.getAuthorizableId();
        Authorizable newAuthorizable = null;
        if (isGroup) {
            newAuthorizable = this.createNewGroup(userManager, acConfiguration.getAuthorizablesConfig(), principalConfigBean, installLog, session);
            LOG.info("Successfully created new group: {}", (Object)authorizableId);
        } else {
            if (StringUtils.isNotEmpty((CharSequence)principalConfigBean.getExternalId())) {
                throw new IllegalStateException("External IDs are not supported for users (" + principalConfigBean.getAuthorizableId() + " is using '" + principalConfigBean.getExternalId() + "') - use a ootb sync handler to have users automatically created.");
            }
            newAuthorizable = this.createNewUser(userManager, acConfiguration.getAuthorizablesConfig(), principalConfigBean, installLog, session);
            LOG.info("Successfully created new user: {}", (Object)authorizableId);
        }
        return newAuthorizable;
    }

    private Set<String> getMembershipGroupsFromConfig(String[] memberOf) {
        HashSet<String> membershipGroupsFromConfig = new HashSet<String>();
        if (memberOf != null) {
            for (String s : memberOf) {
                membershipGroupsFromConfig.add(s);
            }
        }
        return membershipGroupsFromConfig;
    }

    void applyGroupMembershipConfigIsMemberOf(AuthorizableConfigBean authorizableConfigBean, AcConfiguration acConfiguration, InstallationLogger installLog, AuthInstallerUserManager userManager, Session session, Set<String> membershipGroupsFromConfig, Set<String> membershipGroupsFromRepository, Set<String> authorizablesFromConfigurations) throws RepositoryException, AuthorizableExistsException, AuthorizableCreatorException {
        Authorizable targetAuthorizable;
        membershipGroupsFromConfig.remove("everyone");
        membershipGroupsFromRepository.remove("everyone");
        String authorizableId = authorizableConfigBean.getAuthorizableId();
        installLog.addVerboseMessage(LOG, "Authorizable " + authorizableId + " isMemberOf(repo)=" + membershipGroupsFromRepository);
        installLog.addVerboseMessage(LOG, "Authorizable " + authorizableId + " isMemberOf(config)=" + membershipGroupsFromConfig);
        Set<String> validatedMembershipGroupsFromConfig = this.validateAssignedGroups(userManager, acConfiguration.getAuthorizablesConfig(), session, authorizableId, membershipGroupsFromConfig, installLog);
        Collection unChangedMembers = CollectionUtils.intersection(membershipGroupsFromRepository, validatedMembershipGroupsFromConfig);
        installLog.addVerboseMessage(LOG, "Authorizable " + authorizableId + " remains member of groups " + unChangedMembers);
        Collection toBeAddedMembers = CollectionUtils.subtract(validatedMembershipGroupsFromConfig, membershipGroupsFromRepository);
        installLog.addVerboseMessage(LOG, "Authorizable " + authorizableId + " will be added as member of " + toBeAddedMembers);
        Collection toBeRemovedMembers = CollectionUtils.subtract(membershipGroupsFromRepository, validatedMembershipGroupsFromConfig);
        HashSet<String> unmanagedMembers = new HashSet<String>();
        Pattern unmanagedExternalIsMemberOfRegex = authorizableConfigBean.getUnmanagedExternalIsMemberOfRegex();
        if (unmanagedExternalIsMemberOfRegex == null) {
            unmanagedExternalIsMemberOfRegex = acConfiguration.getGlobalConfiguration().getDefaultUnmanagedExternalIsMemberOfRegex();
        }
        Iterator toBeRemovedMembersIt = toBeRemovedMembers.iterator();
        while (toBeRemovedMembersIt.hasNext()) {
            String groupId = (String)toBeRemovedMembersIt.next();
            if (authorizablesFromConfigurations.contains(groupId) || unmanagedExternalIsMemberOfRegex == null || !unmanagedExternalIsMemberOfRegex.matcher(groupId).matches()) continue;
            unmanagedMembers.add(groupId);
            toBeRemovedMembersIt.remove();
        }
        installLog.addVerboseMessage(LOG, "Authorizable " + authorizableId + " will be removed from members of " + toBeRemovedMembers);
        if (!unmanagedMembers.isEmpty()) {
            installLog.addVerboseMessage(LOG, "Authorizable " + authorizableId + " remains member of groups " + unmanagedMembers + " (due to configured unmanagedExternalIsMemberOfRegex=" + unmanagedExternalIsMemberOfRegex + ")");
        }
        Authorizable currentAuthorizable = userManager.getAuthorizable(authorizableId);
        for (String groupId : toBeAddedMembers) {
            LOG.debug("Membership Change: Adding {} to members of group {} in repository", (Object)authorizableId, (Object)groupId);
            targetAuthorizable = userManager.getAuthorizable(groupId);
            ((Group)targetAuthorizable).addMember(currentAuthorizable);
        }
        for (String groupId : toBeRemovedMembers) {
            LOG.debug("Membership Change: Removing {} from members of group {} in repository", (Object)authorizableId, (Object)groupId);
            targetAuthorizable = userManager.getAuthorizable(groupId);
            ((Group)targetAuthorizable).removeMember(currentAuthorizable);
        }
        if (!toBeAddedMembers.isEmpty() && !toBeRemovedMembers.isEmpty()) {
            installLog.addVerboseMessage(LOG, "Membership Change: Authorizable " + authorizableId + " was added to " + toBeAddedMembers.size() + " and removed from " + toBeRemovedMembers.size() + " groups");
        }
    }

    private Authorizable createNewGroup(AuthInstallerUserManager userManager, AuthorizablesConfig authorizablesConfig, AuthorizableConfigBean principalConfigBean, InstallationLogger installLog, Session session) throws AuthorizableExistsException, RepositoryException, AuthorizableCreatorException {
        String groupID = principalConfigBean.getAuthorizableId();
        String intermediatePath = principalConfigBean.getPath();
        Group newGroup = null;
        try {
            if (StringUtils.isNotEmpty((CharSequence)principalConfigBean.getExternalId())) {
                if (this.externalGroupCreatorService == null) {
                    throw new IllegalStateException("External IDs are not available for your AEM version (" + principalConfigBean.getAuthorizableId() + " is using '" + principalConfigBean.getExternalId() + "')");
                }
                newGroup = (Group)this.externalGroupCreatorService.createGroupWithExternalId(userManager.getOakUserManager(), principalConfigBean, installLog, session);
                LOG.info("Successfully created new external group: {}", (Object)groupID);
            } else {
                PrincipalImpl principalForNewGroup = new PrincipalImpl(groupID);
                newGroup = StringUtils.isNotBlank((CharSequence)intermediatePath) ? userManager.createGroup((Principal)principalForNewGroup, intermediatePath) : userManager.createGroup((Principal)principalForNewGroup);
            }
        }
        catch (AuthorizableExistsException e) {
            LOG.warn("Group {} already exists in system!", (Object)groupID);
            newGroup = (Group)userManager.getAuthorizable(groupID);
        }
        this.addMembersToReferencingAuthorizables((Authorizable)newGroup, authorizablesConfig, principalConfigBean, userManager, session, installLog);
        this.setAuthorizableProperties((Authorizable)newGroup, principalConfigBean, authorizablesConfig, session, installLog);
        return newGroup;
    }

    void setAuthorizableProperties(Authorizable authorizable, AuthorizableConfigBean principalConfigBean, AuthorizablesConfig authorizablesConfig, Session session, InstallationLogger installationLog) throws RepositoryException {
        List<String> impersonationAllowedFor;
        String socialContent;
        String preferencesContent;
        String profileContent = principalConfigBean.getProfileContent();
        if (StringUtils.isNotBlank((CharSequence)profileContent)) {
            ContentHelper.importContent(session, authorizable.getPath() + "/profile", profileContent);
        }
        if (StringUtils.isNotBlank((CharSequence)(preferencesContent = principalConfigBean.getPreferencesContent()))) {
            ContentHelper.importContent(session, authorizable.getPath() + "/preferences", preferencesContent);
        }
        if (StringUtils.isNotBlank((CharSequence)(socialContent = principalConfigBean.getSocialContent()))) {
            ContentHelper.importContent(session, authorizable.getPath() + "/social", socialContent);
        }
        ValueFactory vf = session.getValueFactory();
        String name = principalConfigBean.getName();
        if (StringUtils.isNotBlank((CharSequence)name)) {
            if (authorizable.isGroup()) {
                authorizable.setProperty("profile/givenName", vf.createValue(name));
            } else {
                String givenName;
                String familyName;
                if (name.contains(",")) {
                    String[] nameParts = name.split("\\s*,\\s*", 2);
                    familyName = nameParts[0];
                    givenName = nameParts[1];
                } else {
                    givenName = StringUtils.substringBeforeLast((String)name, (String)" ");
                    familyName = StringUtils.substringAfterLast((String)name, (String)" ");
                }
                authorizable.setProperty("profile/givenName", vf.createValue(givenName));
                authorizable.setProperty("profile/familyName", vf.createValue(familyName));
            }
        } else if (StringUtils.isBlank((CharSequence)profileContent)) {
            authorizable.removeProperty("profile/givenName");
            authorizable.removeProperty("profile/familyName");
        }
        String email = principalConfigBean.getEmail();
        if (StringUtils.isNotBlank((CharSequence)email)) {
            authorizable.setProperty("profile/email", vf.createValue(email));
        } else if (StringUtils.isBlank((CharSequence)profileContent)) {
            authorizable.removeProperty("profile/email");
        }
        String description = principalConfigBean.getDescription();
        if (StringUtils.isNotBlank((CharSequence)description)) {
            authorizable.setProperty("profile/aboutMe", vf.createValue(description));
        } else if (StringUtils.isBlank((CharSequence)profileContent)) {
            authorizable.removeProperty("profile/aboutMe");
        }
        String disabled = principalConfigBean.getDisabled();
        if (StringUtils.isNotBlank((CharSequence)disabled)) {
            boolean toBeDisabled;
            if (authorizable.isGroup()) {
                throw new IllegalStateException("Property 'disabled' cannot be set on groups");
            }
            String disabledReason = StringUtils.equalsIgnoreCase((CharSequence)disabled, (CharSequence)"false") ? null : (StringUtils.equalsIgnoreCase((CharSequence)disabled, (CharSequence)"true") ? "User disabled by AC Tool" : disabled);
            User user = (User)authorizable;
            boolean currentlyDisabled = user.isDisabled();
            boolean bl = toBeDisabled = disabledReason != null;
            if (currentlyDisabled && !toBeDisabled) {
                installationLog.addMessage(LOG, "Enabling user " + user.getID());
            } else if (!currentlyDisabled && toBeDisabled) {
                installationLog.addMessage(LOG, "Disabling user " + user.getID() + " with reason: " + disabledReason);
            }
            if (currentlyDisabled || toBeDisabled) {
                user.disable(disabledReason);
            }
        }
        if ((impersonationAllowedFor = principalConfigBean.getImpersonationAllowedFor()) != null) {
            if (authorizable.isGroup()) {
                throw new IllegalStateException("Property 'impersonationAllowedFor' cannot be set on groups");
            }
            this.impersonationInstallerService.setupImpersonation((User)authorizable, impersonationAllowedFor, authorizablesConfig, installationLog);
        }
    }

    private Authorizable createNewUser(AuthInstallerUserManager userManager, AuthorizablesConfig authorizablesConfig, AuthorizableConfigBean principalConfigBean, InstallationLogger installLog, Session session) throws AuthorizableExistsException, RepositoryException, AuthorizableCreatorException {
        String authorizableId = principalConfigBean.getAuthorizableId();
        String password = this.getPassword(principalConfigBean);
        boolean isSystemUser = principalConfigBean.isSystemUser();
        String intermediatePath = principalConfigBean.getPath();
        User newUser = null;
        if (isSystemUser) {
            String systemPrefix = "system/";
            if (intermediatePath != null && !intermediatePath.startsWith(systemPrefix) && !intermediatePath.startsWith("/")) {
                intermediatePath = systemPrefix + intermediatePath;
            }
            newUser = userManager.createSystemUser(authorizableId, intermediatePath);
        } else {
            newUser = userManager.createUser(authorizableId, password, (Principal)new PrincipalImpl(authorizableId), intermediatePath);
        }
        this.setAuthorizableProperties((Authorizable)newUser, principalConfigBean, authorizablesConfig, session, installLog);
        this.addMembersToReferencingAuthorizables((Authorizable)newUser, authorizablesConfig, principalConfigBean, userManager, session, installLog);
        return newUser;
    }

    private void addMembersToReferencingAuthorizables(Authorizable authorizable, AuthorizablesConfig authorizablesConfig, AuthorizableConfigBean principalConfigBean, AuthInstallerUserManager userManager, Session session, InstallationLogger installLog) throws RepositoryException, AuthorizableCreatorException {
        Set<String> referencingAuthorizablesToBeChanged;
        String authorizableId = principalConfigBean.getAuthorizableId();
        String[] memberOf = principalConfigBean.getIsMemberOf();
        if (authorizable != null && memberOf != null && memberOf.length > 0 && !(referencingAuthorizablesToBeChanged = this.validateAssignedGroups(userManager, authorizablesConfig, session, authorizableId, new HashSet<String>(Arrays.asList(memberOf)), installLog)).isEmpty()) {
            LOG.debug("start adding {} to assignedGroups", (Object)authorizableId);
            for (String referencingAuthorizableToBeChangedId : referencingAuthorizablesToBeChanged) {
                Group referencingAuthorizableToBeChanged = (Group)userManager.getAuthorizable(referencingAuthorizableToBeChangedId);
                referencingAuthorizableToBeChanged.addMember(authorizable);
                LOG.debug("added to {} ", (Object)referencingAuthorizableToBeChanged);
            }
        }
    }

    Set<String> validateAssignedGroups(AuthInstallerUserManager userManager, AuthorizablesConfig authorizablesConfig, Session session, String authorizablelId, Set<String> isMemberOf, InstallationLogger installLog) throws RepositoryException, AuthorizableCreatorException {
        HashSet<String> authorizableSet = new HashSet<String>();
        for (String memberOfAuthorizable : isMemberOf) {
            if (StringUtils.equals((CharSequence)authorizablelId, (CharSequence)memberOfAuthorizable)) {
                throw new AuthorizableCreatorException("Cannot add authorizable " + authorizablelId + " as member of itself.");
            }
            Authorizable authorizable = userManager.getAuthorizable(memberOfAuthorizable);
            if (authorizable != null) {
                if (authorizable.isGroup()) {
                    authorizableSet.add(authorizable.getID());
                    continue;
                }
                throw new AuthorizableCreatorException("Invalid isMemberOf in in config of '" + authorizablelId + "': Cannot add '" + memberOfAuthorizable + "' because it is a user and not a group!");
            }
            AuthorizableConfigBean configBeanForIsMemberOf = authorizablesConfig.getAuthorizableConfig(memberOfAuthorizable);
            if (configBeanForIsMemberOf != null) {
                Group newGroup = (Group)this.createNewGroup(userManager, authorizablesConfig, configBeanForIsMemberOf, installLog, session);
                authorizableSet.add(newGroup.getID());
                LOG.info("Created group to be able to add {} to group {} ", (Object)authorizablelId, (Object)memberOfAuthorizable);
                continue;
            }
            throw new AuthorizableCreatorException("Invalid isMemberOf group '" + memberOfAuthorizable + "' in config of '" + authorizablelId + "': Neither found '" + memberOfAuthorizable + "' as already existing group in repository nor in AC Tool config itself!");
        }
        return authorizableSet;
    }
}

