/*
 * Decompiled with CFR 0.152.
 */
package biz.netcentric.cq.tools.actool.configuploadlistener.impl;

import biz.netcentric.cq.tools.actool.api.AcInstallationService;
import biz.netcentric.cq.tools.actool.configuploadlistener.UploadListenerService;
import biz.netcentric.cq.tools.actool.impl.AcInstallationServiceImpl;
import java.util.ArrayList;
import java.util.Date;
import java.util.Dictionary;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.sling.api.resource.observation.ResourceChange;
import org.apache.sling.api.resource.observation.ResourceChangeListener;
import org.apache.sling.commons.scheduler.ScheduleOptions;
import org.apache.sling.commons.scheduler.Scheduler;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.ConfigurationPolicy;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicyOption;
import org.osgi.service.metatype.annotations.AttributeDefinition;
import org.osgi.service.metatype.annotations.Designate;
import org.osgi.service.metatype.annotations.ObjectClassDefinition;
import org.osgi.service.metatype.annotations.Option;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(configurationPolicy=ConfigurationPolicy.REQUIRE, immediate=true)
@Designate(ocd=Configuration.class)
public class UploadListenerServiceImpl
implements UploadListenerService {
    private static final Logger LOG = LoggerFactory.getLogger(UploadListenerServiceImpl.class);
    private static final String CONFIG_PID = "biz.netcentric.cq.tools.actool.configuploadlistener.impl.UploadListenerServiceImpl";
    private List<String> configurationPaths;
    private boolean enabled;
    private int executionDelayInMs;
    @Reference(policyOption=ReferencePolicyOption.GREEDY)
    AcInstallationService acInstallationService;
    @Reference(policyOption=ReferencePolicyOption.GREEDY, cardinality=ReferenceCardinality.OPTIONAL)
    Scheduler scheduler;
    private List<AcToolConfigUpdateListener> updateListeners = new ArrayList<AcToolConfigUpdateListener>();

    @Activate
    public void activate(BundleContext bundleContext, Configuration configuration) throws Exception {
        this.configurationPaths = ((AcInstallationServiceImpl)this.acInstallationService).getConfigurationRootPaths();
        this.enabled = StringUtils.equals((CharSequence)configuration.AceUploadListener_setStatusService(), (CharSequence)"enabled");
        this.executionDelayInMs = configuration.AceUploadListener_triggerDelayMs();
        if (!this.enabled) {
            LOG.debug("UploadListenerServiceImpl is not active, not registering listener(s)");
            return;
        }
        if (this.configurationPaths.isEmpty()) {
            LOG.warn("UploadListenerServiceImpl requires PID biz.netcentric.cq.tools.actool.impl.AcInstallationServiceImpl/'configurationRootPaths' to be configured");
            return;
        }
        for (String configurationRootPath : this.configurationPaths) {
            this.updateListeners.add(new AcToolConfigUpdateListener(configurationRootPath, bundleContext));
        }
    }

    @Deactivate
    public void deactivate() {
        Iterator<AcToolConfigUpdateListener> updateListenersIt = this.updateListeners.iterator();
        while (updateListenersIt.hasNext()) {
            updateListenersIt.next().unregisterListener();
            updateListenersIt.remove();
        }
    }

    public final class AcToolConfigUpdateListener
    implements Runnable,
    ResourceChangeListener {
        private final String configurationRootPath;
        private ServiceRegistration<ResourceChangeListener> resourceChangeListenerRegistration;
        private volatile boolean isScheduled = false;

        public AcToolConfigUpdateListener(String configurationRootPath, BundleContext bundleContext) {
            this.configurationRootPath = configurationRootPath;
            this.registerListener(configurationRootPath, bundleContext);
        }

        private void registerListener(String configurationRootPath, BundleContext bundleContext) {
            Hashtable<String, Object> changeListenerProperties = new Hashtable<String, Object>();
            ((Dictionary)changeListenerProperties).put("resource.change.types", new String[]{"ADDED", "CHANGED", "REMOVED"});
            ((Dictionary)changeListenerProperties).put("resource.paths", configurationRootPath);
            ((Dictionary)changeListenerProperties).put(AcToolConfigUpdateListener.class.getSimpleName(), Boolean.TRUE);
            this.resourceChangeListenerRegistration = bundleContext.registerService(ResourceChangeListener.class, (Object)this, changeListenerProperties);
            LOG.info("Registered event handler for AC configuration root path: {}", (Object)configurationRootPath);
        }

        private void unregisterListener() {
            try {
                this.resourceChangeListenerRegistration.unregister();
                LOG.info("Unregistered event handler for AC configuration root path: {}", (Object)this.configurationRootPath);
            }
            catch (Exception e) {
                LOG.error("Exception while unregistering event handler in UploadListenerService: " + e, (Throwable)e);
            }
        }

        @Override
        public void run() {
            this.isScheduled = false;
            LOG.info("Applying config for AC Tool root path {}", (Object)this.configurationRootPath);
            UploadListenerServiceImpl.this.acInstallationService.apply(this.configurationRootPath);
        }

        public void onChange(List<ResourceChange> changes) {
            LOG.trace("UploadListener ResourceChangeListener triggered with '{}'", changes);
            for (ResourceChange change : changes) {
                String path = change.getPath();
                if (path.endsWith(".yaml")) {
                    if (UploadListenerServiceImpl.this.scheduler != null) {
                        LOG.info("Received change event for yaml file {}", (Object)path);
                        this.scheduleExecution();
                        continue;
                    }
                    LOG.warn("Received change event for yaml file {}, but service org.apache.sling.commons.scheduler.Scheduler is not available (Skipping execution)", (Object)path);
                    continue;
                }
                LOG.debug("Observed resource event path is not ending with '.yaml': '{}'", (Object)path);
            }
        }

        private synchronized void scheduleExecution() {
            if (!this.isScheduled) {
                ScheduleOptions options = UploadListenerServiceImpl.this.scheduler.AT(new Date(System.currentTimeMillis() + (long)UploadListenerServiceImpl.this.executionDelayInMs));
                options.name("UploadListener-Process-Change");
                UploadListenerServiceImpl.this.scheduler.schedule((Object)this, options);
                this.isScheduled = true;
                LOG.debug("Scheduled execution for path {}", (Object)this.configurationRootPath);
            } else {
                LOG.debug("Execution for path {} is already scheduled", (Object)this.configurationRootPath);
            }
        }
    }

    @ObjectClassDefinition(name="AC Tool Configuration Upload Listener Service", description="Listens for ACL configuration uploads and triggers ACL Service.", id="biz.netcentric.cq.tools.actool.configuploadlistener.impl.UploadListenerServiceImpl")
    protected static @interface Configuration {
        @AttributeDefinition(name="Service status", description="Enable/disable AC Configuration Upload Listener Service", options={@Option(label="disabled", value="disabled"), @Option(label="enabled", value="enabled")})
        public String AceUploadListener_setStatusService() default "disabled";

        @AttributeDefinition(name="Execution delay", description="Defer execution of the ACTool after detecting the first changed YAML file by this amount of milliseconds")
        public int AceUploadListener_triggerDelayMs() default 5000;
    }
}

