/*
 * Decompiled with CFR 0.152.
 */
package biz.netcentric.cq.tools.actool.jmx;

import biz.netcentric.cq.tools.actool.dumpservice.ConfigDumpService;
import biz.netcentric.cq.tools.actool.history.AcHistoryService;
import biz.netcentric.cq.tools.actool.history.AcToolExecution;
import biz.netcentric.cq.tools.actool.impl.AcInstallationServiceInternal;
import biz.netcentric.cq.tools.actool.jmx.AceServiceMBean;
import com.adobe.granite.jmx.annotation.AnnotatedStandardMBean;
import java.util.List;
import java.util.Set;
import javax.management.NotCompliantMBeanException;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.time.StopWatch;
import org.apache.sling.jcr.api.SlingRepository;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferencePolicyOption;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(property={"jmx.objectname=biz.netcentric.cq.tools:type=ACTool", "pattern=/.*"})
public class AceServiceMBeanImpl
extends AnnotatedStandardMBean
implements AceServiceMBean {
    private static final Logger LOG = LoggerFactory.getLogger(AceServiceMBeanImpl.class);
    @Reference(policyOption=ReferencePolicyOption.GREEDY)
    AcInstallationServiceInternal acInstallationService;
    @Reference(policyOption=ReferencePolicyOption.GREEDY)
    AcHistoryService acHistoryService;
    @Reference(policyOption=ReferencePolicyOption.GREEDY)
    ConfigDumpService dumpService;
    @Reference(policyOption=ReferencePolicyOption.GREEDY)
    SlingRepository repository;

    public AceServiceMBeanImpl() throws NotCompliantMBeanException {
        super(AceServiceMBean.class);
    }

    @Override
    public String apply() {
        return this.acInstallationService.apply().toString();
    }

    @Override
    public String applyRestrictedToPaths(String paths) {
        String[] restrictedToPaths = this.commaSeparatedStringToArr(paths);
        return this.acInstallationService.apply(restrictedToPaths).toString();
    }

    @Override
    public String apply(String configurationRootPath) {
        return this.acInstallationService.apply(configurationRootPath).toString();
    }

    @Override
    public String applyRestrictedToPaths(String configurationRootPath, String paths) {
        String[] restrictedToPaths = this.commaSeparatedStringToArr(paths);
        return this.acInstallationService.apply(configurationRootPath, restrictedToPaths).toString();
    }

    @Override
    public String applyRestrictedToPaths(String configurationRootPath, String paths, boolean skipIfConfigUnchanged) {
        String[] restrictedToPaths = this.commaSeparatedStringToArr(paths);
        return this.acInstallationService.apply(configurationRootPath, restrictedToPaths, skipIfConfigUnchanged).toString();
    }

    @Override
    public String purgeACL(String path) {
        return this.acInstallationService.purgeACL(path);
    }

    @Override
    public String purgeACLs(String path) {
        return this.acInstallationService.purgeACLs(path);
    }

    @Override
    public String[] getConfigurationFiles() {
        Set<String> paths = this.acInstallationService.getCurrentConfigurationPaths();
        StringBuilder sb = new StringBuilder();
        int cnt = 1;
        for (String path : paths) {
            sb.append(cnt + ". " + path + " \n");
            ++cnt;
        }
        return paths.toArray(new String[paths.size()]);
    }

    @Override
    public String[] getSavedLogs() {
        List<AcToolExecution> executions = this.acHistoryService.getAcToolExecutions();
        if (executions.isEmpty()) {
            return new String[]{"no executions found"};
        }
        return (String[])executions.stream().map(AcToolExecution::getLogsPath).toArray(String[]::new);
    }

    @Override
    public String pathBasedDump() {
        StopWatch sw = new StopWatch();
        sw.start();
        String dump = this.dumpService.getCompletePathBasedDumpsAsString();
        sw.stop();
        LOG.info("path based dump took: " + sw.getTime() + " ms");
        return dump;
    }

    @Override
    public String groupBasedDump() {
        StopWatch sw = new StopWatch();
        sw.start();
        String dump = this.dumpService.getCompletePrincipalBasedDumpsAsString();
        sw.stop();
        LOG.info("group based dump took: " + sw.getTime() + " ms");
        return dump;
    }

    @Override
    public String showInstallationLog(String n, boolean verbose) {
        int i;
        String[] logs = this.getSavedLogs();
        if (logs.length == 0) {
            return "no logs found";
        }
        int numberOfFoundLogs = logs.length;
        String errorMessage = "please enter a valid log number (between 1 and " + numberOfFoundLogs + ")";
        try {
            i = Integer.parseInt(n);
        }
        catch (NumberFormatException e) {
            return errorMessage;
        }
        if (i < 1 || i > numberOfFoundLogs) {
            return errorMessage;
        }
        return this.acHistoryService.getLogFromHistory(i, false, verbose);
    }

    @Override
    public String purgeAllAuthorizablesFromConfiguration() {
        return this.acInstallationService.purgeAuthorizablesFromConfig();
    }

    @Override
    public String purgeAllAuthorizablesFromConfiguration(String configurationRootPath) {
        return this.acInstallationService.purgeAuthorizablesFromConfig(configurationRootPath);
    }

    @Override
    public String purgeAuthorizables(String authorizableIds) {
        return this.acInstallationService.purgeAuthorizables(this.commaSeparatedStringToArr(authorizableIds));
    }

    private String[] commaSeparatedStringToArr(String str) {
        String[] restrictedToPaths = null;
        if (StringUtils.isNotBlank((CharSequence)str)) {
            restrictedToPaths = str.trim().split("[ \t]*,[ \t]*");
        }
        return restrictedToPaths;
    }

    @Override
    public String getVersion() {
        return this.acInstallationService.getVersion();
    }
}

