/*
 * Decompiled with CFR 0.152.
 */
package biz.netcentric.cq.tools.actool.ui;

import biz.netcentric.cq.tools.actool.ui.AcToolUiService;
import biz.netcentric.cq.tools.actool.ui.WebConsoleConfigTracker;
import java.io.IOException;
import java.util.Iterator;
import javax.servlet.Servlet;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.jackrabbit.api.security.user.Group;
import org.apache.jackrabbit.api.security.user.User;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.SlingHttpServletResponse;
import org.apache.sling.api.servlets.SlingAllMethodsServlet;
import org.apache.sling.servlets.annotations.SlingServletResourceTypes;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferencePolicyOption;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(service={Servlet.class})
@SlingServletResourceTypes(resourceTypes={"/apps/netcentric/actool/components/overview"}, methods={"GET", "POST"})
public class AcToolTouchUiServlet
extends SlingAllMethodsServlet {
    private static final Logger LOG = LoggerFactory.getLogger(AcToolTouchUiServlet.class);
    @Reference(policyOption=ReferencePolicyOption.GREEDY)
    private WebConsoleConfigTracker webConsoleConfigTracker;
    @Reference(policyOption=ReferencePolicyOption.GREEDY)
    private AcToolUiService acToolUiService;

    protected void doGet(SlingHttpServletRequest req, SlingHttpServletResponse resp) throws ServletException, IOException {
        if (StringUtils.isBlank((CharSequence)req.getRequestPathInfo().getSuffix())) {
            String targetUrl = req.getResourceResolver().resolve(req.getPathInfo()).getPath() + ".html/" + "actool";
            resp.getWriter().println("<script type=\"text/javascript\">location.href='" + targetUrl + "'</script>");
            return;
        }
        this.acToolUiService.doGet((HttpServletRequest)req, (HttpServletResponse)resp, req.getRequestPathInfo().getResourcePath(), true);
    }

    protected void doPost(SlingHttpServletRequest req, SlingHttpServletResponse resp) throws ServletException, IOException {
        if (!this.mayApplyConfig((User)req.getResourceResolver().adaptTo(User.class))) {
            resp.sendError(403, "You do not have sufficent permissions to apply the configuration");
            return;
        }
        this.acToolUiService.doPost((HttpServletRequest)req, (HttpServletResponse)resp);
        LOG.debug("Applied AC tool config via Touch UI by user {}", (Object)req.getUserPrincipal());
    }

    private boolean mayApplyConfig(User requestUser) {
        try {
            if (requestUser != null) {
                if (StringUtils.equals((CharSequence)requestUser.getID(), (CharSequence)"admin")) {
                    LOG.debug("Admin user is allowed to apply AC Tool");
                    return true;
                }
                if (ArrayUtils.contains((Object[])this.webConsoleConfigTracker.getAllowedUsers(), (Object)requestUser.getID())) {
                    LOG.debug("User {} is allowed to apply AC Tool (allowed users: {})", (Object)requestUser.getID(), (Object)ArrayUtils.toString((Object)this.webConsoleConfigTracker.getAllowedUsers()));
                    return true;
                }
                Iterator memberOfIt = requestUser.memberOf();
                while (memberOfIt.hasNext()) {
                    Group memberOfGroup = (Group)memberOfIt.next();
                    if (!ArrayUtils.contains((Object[])this.webConsoleConfigTracker.getAllowedGroups(), (Object)memberOfGroup.getID())) continue;
                    LOG.debug("Group {} is allowed to apply AC Tool (allowed groups: {})", (Object)memberOfGroup.getID(), (Object)ArrayUtils.toString((Object)this.webConsoleConfigTracker.getAllowedGroups()));
                    return true;
                }
            }
            return false;
        }
        catch (Exception e) {
            throw new IllegalStateException("Could not check if user may apply AC Tool configuration: " + e, e);
        }
    }
}

