/*
 * Decompiled with CFR 0.152.
 */
package biz.netcentric.cq.tools.actool.validators.impl;

import biz.netcentric.cq.tools.actool.configmodel.AuthorizableConfigBean;
import biz.netcentric.cq.tools.actool.validators.AuthorizableValidator;
import biz.netcentric.cq.tools.actool.validators.Validators;
import biz.netcentric.cq.tools.actool.validators.exceptions.AcConfigBeanValidationException;
import biz.netcentric.cq.tools.actool.validators.exceptions.InvalidAuthorizableException;
import biz.netcentric.cq.tools.actool.validators.exceptions.InvalidGroupNameException;
import biz.netcentric.cq.tools.actool.validators.exceptions.InvalidIntermediatePathException;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AuthorizableValidatorImpl
implements AuthorizableValidator {
    private static final Logger LOG = LoggerFactory.getLogger(AuthorizableValidatorImpl.class);
    private boolean enabled = true;
    AuthorizableConfigBean authorizableConfigBean;
    final String groupsPath;
    final String usersPath;

    public AuthorizableValidatorImpl(String groupsPath, String usersPath) {
        this.groupsPath = groupsPath;
        this.usersPath = usersPath;
    }

    @Override
    public boolean validate(AuthorizableConfigBean authorizableConfigBean) throws AcConfigBeanValidationException {
        boolean success = true;
        if (this.enabled) {
            success = this.validateAuthorizableProperties(authorizableConfigBean) && this.validateMemberOf(authorizableConfigBean) && this.validateMembers(authorizableConfigBean) && this.validateAuthorizableId(authorizableConfigBean) && this.validateIntermediatePath(authorizableConfigBean);
        }
        return success;
    }

    public boolean validateIntermediatePath(AuthorizableConfigBean authorizableConfigBean) throws InvalidAuthorizableException, InvalidIntermediatePathException {
        boolean isGroup = authorizableConfigBean.isGroup();
        String intermediatePath = authorizableConfigBean.getPath();
        String currentAuthorizableId = authorizableConfigBean.getAuthorizableId();
        String basicErrorMessage = "Validation error while validating intermediate path of authorizable: " + currentAuthorizableId;
        if (intermediatePath.startsWith("/")) {
            if (!intermediatePath.startsWith(this.groupsPath) && !intermediatePath.startsWith(this.usersPath)) {
                String message = basicErrorMessage + " - the intermediate path either has to be relative (not starting with '/') or has to start with the authorizable root!";
                LOG.error(message);
                throw new InvalidIntermediatePathException(message);
            }
            if (!isGroup && intermediatePath.startsWith(this.groupsPath)) {
                String message = basicErrorMessage + " - the intermediate path for the user must not be the groups path: " + this.groupsPath;
                LOG.error(message);
                throw new InvalidIntermediatePathException(message);
            }
            if (isGroup && intermediatePath.startsWith(this.usersPath)) {
                String message = basicErrorMessage + " - the intermediate path for the group must not be the users path: " + this.usersPath;
                LOG.error(message);
                throw new InvalidIntermediatePathException(message);
            }
            if (intermediatePath.equals(this.groupsPath) || intermediatePath.equals(this.usersPath) || intermediatePath.equals(this.groupsPath + "/") || intermediatePath.equals(this.usersPath + "/")) {
                String message = basicErrorMessage + " - the intermediate path must not be equal to the authorizable root but has to specify a subfolder of it!";
                LOG.error(message);
                throw new InvalidIntermediatePathException(message);
            }
        }
        return true;
    }

    public boolean validateAuthorizableProperties(AuthorizableConfigBean authorizableConfigBean) throws InvalidAuthorizableException {
        if (authorizableConfigBean.isGroup()) {
            if (StringUtils.isNotBlank((CharSequence)authorizableConfigBean.getPassword())) {
                String message = "Group " + authorizableConfigBean.getAuthorizableId() + " may not be configured with password";
                LOG.error(message);
                throw new InvalidAuthorizableException(message);
            }
            if (StringUtils.isNotBlank((CharSequence)authorizableConfigBean.getDisabled())) {
                String message = "Groups cannot be disabled - property 'disable' is used on " + authorizableConfigBean.getAuthorizableId();
                LOG.error(message);
                throw new InvalidAuthorizableException(message);
            }
        } else {
            if (authorizableConfigBean.isSystemUser() && StringUtils.isNotBlank((CharSequence)authorizableConfigBean.getPassword())) {
                String message = "System user " + authorizableConfigBean.getAuthorizableId() + " may not be configured with password";
                LOG.error(message);
                throw new InvalidAuthorizableException(message);
            }
            if (StringUtils.isNotBlank((CharSequence)authorizableConfigBean.getMigrateFrom())) {
                String message = "migrateFrom can only be used with groups (found in " + authorizableConfigBean.getAuthorizableId() + ")";
                LOG.error(message);
                throw new InvalidAuthorizableException(message);
            }
        }
        return true;
    }

    public boolean validateMemberOf(AuthorizableConfigBean authorizableConfigBean) throws InvalidGroupNameException {
        String currentAuthorizable = authorizableConfigBean.getAuthorizableId();
        String[] isMemberOfGroups = authorizableConfigBean.getIsMemberOf();
        if (isMemberOfGroups != null && isMemberOfGroups.length > 0) {
            for (int i = 0; i < isMemberOfGroups.length; ++i) {
                if (Validators.isValidAuthorizableId(isMemberOfGroups[i])) continue;
                LOG.error("Validation error while reading group property of authorizable:{}, invalid authorizable name: {}", (Object)currentAuthorizable, (Object)isMemberOfGroups[i]);
                throw new InvalidGroupNameException("Validation error while reading group property of authorizable: " + currentAuthorizable + ", invalid group name: " + isMemberOfGroups[i]);
            }
        }
        return true;
    }

    public boolean validateMembers(AuthorizableConfigBean authorizableConfigBean) throws InvalidGroupNameException {
        String currentAuthorizable = authorizableConfigBean.getAuthorizableId();
        String[] members = authorizableConfigBean.getMembers();
        if (members != null && members.length > 0) {
            for (int i = 0; i < members.length; ++i) {
                if (Validators.isValidAuthorizableId(members[i])) continue;
                LOG.error("Validation error while reading group property of authorizable:{}, invalid authorizable name: {}", (Object)currentAuthorizable, (Object)members[i]);
                throw new InvalidGroupNameException("Validation error while reading group property of authorizable: " + currentAuthorizable + ", invalid group name: " + members[i]);
            }
        }
        return true;
    }

    public boolean validateAuthorizableId(AuthorizableConfigBean authorizableConfigBean) throws InvalidGroupNameException {
        String authorizableId = authorizableConfigBean.getAuthorizableId();
        if (!Validators.isValidAuthorizableId(authorizableId)) {
            String message = "Validation error while reading group data: invalid group name: " + authorizableId;
            LOG.error(message);
            throw new InvalidGroupNameException(message);
        }
        authorizableConfigBean.setAuthorizableId(authorizableId);
        return true;
    }

    @Override
    public void disable() {
        this.enabled = false;
    }
}

