/*
 * Decompiled with CFR 0.152.
 */
package biz.netcentric.cq.tools.actool.api;

import biz.netcentric.cq.tools.actool.api.InstallationOptions;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

public final class InstallationOptionsBuilder {
    private String configurationRootPath;
    private List<String> restrictedToPaths;
    private boolean skipIfConfigUnchanged;
    private boolean updateExistingExternalGroups;

    public InstallationOptionsBuilder(Map<String, Object> properties) {
        this.configurationRootPath = (String)properties.get("configurationRootPath");
        String[] restrictedToPathsArray = (String[])properties.get("restrictedToPaths");
        this.restrictedToPaths = restrictedToPathsArray != null ? new LinkedList<String>(Arrays.asList(restrictedToPathsArray)) : new LinkedList<String>();
        this.skipIfConfigUnchanged = (Boolean)properties.getOrDefault("skipIfConfigUnchanged", Boolean.FALSE);
        this.updateExistingExternalGroups = (Boolean)properties.getOrDefault("updateExistingExternalGroups", Boolean.FALSE);
    }

    public InstallationOptionsBuilder() {
        this.configurationRootPath = null;
        this.restrictedToPaths = new LinkedList<String>();
        this.skipIfConfigUnchanged = false;
        this.updateExistingExternalGroups = false;
    }

    public InstallationOptionsBuilder(InstallationOptions options) {
        this.configurationRootPath = options.getConfigurationRootPath().orElse(null);
        this.restrictedToPaths = new LinkedList<String>();
        this.restrictedToPaths.addAll(options.getRestrictedToPaths());
        this.skipIfConfigUnchanged = options.shouldSkipIfConfigUnchanged();
        this.updateExistingExternalGroups = options.shouldUpdateExistingExternalGroups();
    }

    public InstallationOptionsBuilder withConfigurationRootPath(String configurationRootPath) {
        this.configurationRootPath = configurationRootPath;
        return this;
    }

    public InstallationOptionsBuilder withRestrictedToPaths(String ... restrictedToPaths) {
        this.restrictedToPaths.addAll(Arrays.asList(restrictedToPaths));
        return this;
    }

    public InstallationOptionsBuilder withRestrictedToPaths(Collection<String> restrictedToPaths) {
        this.restrictedToPaths.addAll(restrictedToPaths);
        return this;
    }

    public InstallationOptionsBuilder skipIfConfigUnchanged() {
        this.skipIfConfigUnchanged = true;
        return this;
    }

    public InstallationOptionsBuilder updateExistingExternalGroups() {
        this.updateExistingExternalGroups = true;
        return this;
    }

    public InstallationOptions build() {
        return new InstallationOptionsImpl(this);
    }

    private static final class InstallationOptionsImpl
    implements InstallationOptions {
        private final String configurationRootPath;
        private final List<String> restrictedToPaths;
        private final boolean skipIfConfigUnchanged;
        private final boolean updateExistingExternalGroups;

        InstallationOptionsImpl(InstallationOptionsBuilder builder) {
            this.configurationRootPath = builder.configurationRootPath;
            this.restrictedToPaths = builder.restrictedToPaths;
            this.skipIfConfigUnchanged = builder.skipIfConfigUnchanged;
            this.updateExistingExternalGroups = builder.updateExistingExternalGroups;
        }

        @Override
        public Optional<String> getConfigurationRootPath() {
            return Optional.ofNullable(this.configurationRootPath);
        }

        @Override
        public List<String> getRestrictedToPaths() {
            return this.restrictedToPaths;
        }

        @Override
        public boolean shouldSkipIfConfigUnchanged() {
            return this.skipIfConfigUnchanged;
        }

        @Override
        public boolean shouldUpdateExistingExternalGroups() {
            return this.updateExistingExternalGroups;
        }

        public int hashCode() {
            return Objects.hash(this.configurationRootPath, this.restrictedToPaths, this.skipIfConfigUnchanged, this.updateExistingExternalGroups);
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            InstallationOptionsImpl other = (InstallationOptionsImpl)obj;
            return Objects.equals(this.configurationRootPath, other.configurationRootPath) && Objects.equals(this.restrictedToPaths, other.restrictedToPaths) && this.skipIfConfigUnchanged == other.skipIfConfigUnchanged && this.updateExistingExternalGroups == other.updateExistingExternalGroups;
        }

        public String toString() {
            return "InstallationOptionsImpl [configurationRootPath=" + this.configurationRootPath + ", restrictedToPaths=" + this.restrictedToPaths + ", skipIfConfigUnchanged=" + this.skipIfConfigUnchanged + ", updateExistingExternalGroups=" + this.updateExistingExternalGroups + "]";
        }

        @Override
        public Map<String, Object> getPersistableProperties() {
            HashMap<String, Object> properties = new HashMap<String, Object>();
            properties.put("configurationRootPath", this.configurationRootPath);
            properties.put("restrictedToPaths", this.restrictedToPaths.toArray(new String[0]));
            properties.put("skipIfConfigUnchanged", this.skipIfConfigUnchanged);
            properties.put("updateExistingExternalGroups", this.updateExistingExternalGroups);
            return properties;
        }
    }
}

