/*
 * Decompiled with CFR 0.152.
 */
package biz.netcentric.cq.tools.actool.configmodel.pkcs;

import biz.netcentric.cq.tools.actool.configmodel.pkcs.Key;
import biz.netcentric.cq.tools.actool.configmodel.pkcs.PrivateKeyDecryptor;
import java.io.IOException;
import java.security.AlgorithmParameters;
import java.security.GeneralSecurityException;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.spec.PKCS8EncodedKeySpec;
import javax.crypto.Cipher;
import javax.crypto.EncryptedPrivateKeyInfo;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.PBEKeySpec;
import org.osgi.service.component.annotations.Component;

@Component
public class JcaPkcs8EncryptedPrivateKeyDecryptor
implements PrivateKeyDecryptor {
    @Override
    public PrivateKey decrypt(char[] password, byte[] derData) throws GeneralSecurityException, IOException {
        Cipher cipher;
        EncryptedPrivateKeyInfo encryptPKInfo;
        try {
            encryptPKInfo = new EncryptedPrivateKeyInfo(derData);
        }
        catch (IOException e) {
            if (e.getMessage().startsWith("ObjectIdentifier() -- data isn't an object ID ")) {
                throw new NoSuchAlgorithmException("Java < 11 does no properly support all PBES2 algorithms. Try again after installing Bouncycastle or upgrading to Java 11", e);
            }
            throw e;
        }
        try {
            cipher = Cipher.getInstance(encryptPKInfo.getAlgName());
        }
        catch (NoSuchAlgorithmException e) {
            throw new NoSuchAlgorithmException("JCA does no properly support all PBES2 algorithms. Try again after installing Bouncycastle", e);
        }
        PBEKeySpec pbeKeySpec = new PBEKeySpec(password);
        SecretKeyFactory secFac = SecretKeyFactory.getInstance(encryptPKInfo.getAlgName());
        SecretKey pbeKey = secFac.generateSecret(pbeKeySpec);
        AlgorithmParameters algParams = encryptPKInfo.getAlgParameters();
        cipher.init(2, (java.security.Key)pbeKey, algParams);
        PKCS8EncodedKeySpec keySpec = encryptPKInfo.getKeySpec(cipher);
        return Key.getPrivateKey(keySpec);
    }
}

