/*
 * Decompiled with CFR 0.152.
 */
package biz.netcentric.cq.tools.actool.history.impl;

import biz.netcentric.cq.tools.actool.api.InstallationResult;
import biz.netcentric.cq.tools.actool.comparators.TimestampPropertyComparator;
import biz.netcentric.cq.tools.actool.configuploadlistener.impl.UploadListenerServiceImpl;
import biz.netcentric.cq.tools.actool.helper.runtime.RuntimeHelper;
import biz.netcentric.cq.tools.actool.history.AcToolExecution;
import biz.netcentric.cq.tools.actool.history.impl.AcToolExecutionImpl;
import biz.netcentric.cq.tools.actool.history.impl.PersistableInstallationLogger;
import biz.netcentric.cq.tools.actool.jmx.AceServiceMBeanImpl;
import biz.netcentric.cq.tools.actool.ui.AcToolWebconsolePlugin;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringReader;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.PathNotFoundException;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.ValueFormatException;
import javax.jcr.lock.LockException;
import javax.jcr.nodetype.ConstraintViolationException;
import javax.jcr.version.VersionException;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.text.WordUtils;
import org.apache.jackrabbit.commons.JcrUtils;
import org.apache.jackrabbit.util.Text;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HistoryUtils {
    private static final Logger LOG = LoggerFactory.getLogger(HistoryUtils.class);
    public static final String LOG_FILE_NAME = "actool.log";
    public static final String LOG_FILE_NAME_VERBOSE = "actool-verbose.log";
    public static final String HISTORY_NODE_NAME_PREFIX = "history_";
    public static final String NODETYPE_NT_UNSTRUCTURED = "nt:unstructured";
    public static final String ACHISTORY_ROOT_NODE_NAME = "achistory";
    public static final String STATISTICS_ROOT_NODE_PATH = "/var/statistics";
    public static final String ACHISTORY_PATH = "/var/statistics/achistory";
    private static final String AC_ROOT_PATH_IN_APPS = "/apps/netcentric";
    public static final String AC_HISTORY_PATH_IN_APPS = "/apps/netcentric/achistory";
    public static final String PROPERTY_TIMESTAMP = "timestamp";
    private static final String PROPERTY_MESSAGES = "messages";
    private static final String PROPERTY_EXECUTION_TIME = "executionTime";
    public static final String PROPERTY_SUCCESS = "success";
    private static final String PROPERTY_INSTALLATION_DATE = "installationDate";
    public static final String PROPERTY_INSTALLED_FROM = "installedFrom";
    public static final String PROPERTY_STARTLEVEL = "startlevel";
    public static final String PROPERTY_TRIGGER = "trigger";
    public static final String PROPERTY_CONFIG_ROOT_PATH = "configurationRootPath";
    public static final String PROPERTY_ACL_CHANGES = "aclsChanges";
    public static final String PROPERTY_AUTHORIZABLES_CHANGES = "authorizableChanges";
    private static final String AC_TOOL_STARTUPHOOK_CLASS = "biz.netcentric.cq.tools.actool.startuphook.impl.AcToolStartupHookServiceImpl";
    private static final String BUNDLE_START_TASK_CLASS = "org.apache.sling.installer.core.impl.tasks.BundleStartTask";
    private static final String AC_TOOL_TOUCH_UI_SERVLET_CLASS = "biz.netcentric.cq.tools.actool.ui.AcToolTouchUiServlet";

    public static Node getAcHistoryRootNode(Session session) throws RepositoryException {
        Node statisticsRootNode = JcrUtils.getOrCreateByPath((String)STATISTICS_ROOT_NODE_PATH, (String)NODETYPE_NT_UNSTRUCTURED, (Session)session);
        return JcrUtils.getOrAddNode((Node)statisticsRootNode, (String)ACHISTORY_ROOT_NODE_NAME, (String)"sling:OrderedFolder");
    }

    public static Node persistHistory(Session session, PersistableInstallationLogger installLog, int nrOfHistoriesToSave) throws RepositoryException {
        String trigger;
        Node acHistoryRootNode = HistoryUtils.getAcHistoryRootNode(session);
        String name = HISTORY_NODE_NAME_PREFIX + System.currentTimeMillis();
        StackTraceElement[] stackTrace = Thread.currentThread().getStackTrace();
        if (StringUtils.isNotBlank((CharSequence)installLog.getCrxPackageName())) {
            trigger = "installhook";
        } else if (HistoryUtils.isInStrackTracke(stackTrace, AceServiceMBeanImpl.class)) {
            trigger = "jmx";
        } else if (HistoryUtils.isInStrackTracke(stackTrace, AC_TOOL_TOUCH_UI_SERVLET_CLASS)) {
            trigger = "aem_admin_ui";
        } else if (HistoryUtils.isInStrackTracke(stackTrace, UploadListenerServiceImpl.AcToolConfigUpdateListener.class)) {
            trigger = "changelistener";
        } else if (HistoryUtils.isInStrackTracke(stackTrace, AcToolWebconsolePlugin.class)) {
            trigger = "webconsole";
        } else if (HistoryUtils.isInStrackTracke(stackTrace, AC_TOOL_STARTUPHOOK_CLASS)) {
            if (HistoryUtils.isInStrackTracke(stackTrace, BUNDLE_START_TASK_CLASS)) {
                trigger = "startup_hook_pckmgr)";
            } else {
                boolean isImageBuild;
                boolean bl = isImageBuild = RuntimeHelper.isCloudReadyInstance() && !session.itemExists(AC_HISTORY_PATH_IN_APPS);
                trigger = isImageBuild ? "startup_hook_image_build" : "startup_hook";
            }
        } else {
            trigger = "api";
            name = name + "api";
        }
        name = name + "_via_" + trigger;
        Node newHistoryNode = JcrUtils.getOrAddNode((Node)acHistoryRootNode, (String)name, (String)NODETYPE_NT_UNSTRUCTURED);
        String path = newHistoryNode.getPath();
        HistoryUtils.setHistoryNodeProperties(newHistoryNode, installLog, trigger);
        HistoryUtils.saveLogs(newHistoryNode, installLog);
        HistoryUtils.deleteObsoleteHistoryNodes(acHistoryRootNode, nrOfHistoriesToSave);
        Node previousHistoryNode = (Node)acHistoryRootNode.getNodes().next();
        if (previousHistoryNode != null) {
            acHistoryRootNode.orderBefore(newHistoryNode.getName(), previousHistoryNode.getName());
        }
        LOG.info("Saved history in node: {}", (Object)path);
        return newHistoryNode;
    }

    static void saveLogs(Node historyNode, InstallationResult installLog) throws RepositoryException {
        JcrUtils.putFile((Node)historyNode, (String)LOG_FILE_NAME_VERBOSE, (String)"text/plain", (InputStream)new ByteArrayInputStream(installLog.getVerboseMessageHistory().getBytes()));
        JcrUtils.putFile((Node)historyNode, (String)LOG_FILE_NAME, (String)"text/plain", (InputStream)new ByteArrayInputStream(installLog.getMessageHistory().getBytes()));
    }

    private static boolean isInStrackTracke(StackTraceElement[] stackTrace, Class<?> classToSearch) {
        return HistoryUtils.isInStrackTracke(stackTrace, classToSearch.getName());
    }

    private static boolean isInStrackTracke(StackTraceElement[] stackTrace, String classToSearch) {
        for (StackTraceElement stackTraceElement : stackTrace) {
            if (!classToSearch.equals(stackTraceElement.getClassName())) continue;
            return true;
        }
        return false;
    }

    public static void setHistoryNodeProperties(Node historyNode, PersistableInstallationLogger installLog, String trigger) throws ValueFormatException, VersionException, LockException, ConstraintViolationException, RepositoryException {
        historyNode.setProperty(PROPERTY_INSTALLATION_DATE, installLog.getInstallationDate().toString());
        historyNode.setProperty(PROPERTY_SUCCESS, installLog.isSuccess());
        historyNode.setProperty(PROPERTY_EXECUTION_TIME, installLog.getExecutionTime());
        historyNode.setProperty(PROPERTY_STARTLEVEL, (long)RuntimeHelper.getCurrentStartLevel());
        historyNode.setProperty(PROPERTY_TRIGGER, trigger);
        historyNode.setProperty(PROPERTY_ACL_CHANGES, (long)installLog.getCountAclsChanged());
        historyNode.setProperty(PROPERTY_AUTHORIZABLES_CHANGES, (long)installLog.getCountAuthorizablesCreated() + (long)installLog.getCountAuthorizablesMoved());
        historyNode.setProperty(PROPERTY_CONFIG_ROOT_PATH, HistoryUtils.getEffectiveConfigRootPath(installLog));
        historyNode.setProperty(PROPERTY_TIMESTAMP, installLog.getInstallationDate().getTime());
        Map<String, String> configFileContentsByName = installLog.getConfigFileContentsByName();
        if (configFileContentsByName != null) {
            String crxPackageName = installLog.getCrxPackageName();
            historyNode.setProperty(PROPERTY_INSTALLED_FROM, StringUtils.defaultString((String)crxPackageName));
        }
    }

    private static String getEffectiveConfigRootPath(PersistableInstallationLogger installLog) {
        Map<String, String> configFileContentsByName = installLog.getConfigFileContentsByName();
        if (configFileContentsByName == null) {
            return null;
        }
        Set<String> configFiles = configFileContentsByName.keySet();
        String effectiveConfigRootPath = StringUtils.getCommonPrefix((String[])configFiles.toArray(new String[configFiles.size()]));
        effectiveConfigRootPath = StringUtils.removeStart((String)effectiveConfigRootPath, (String)"//jcr_root");
        effectiveConfigRootPath = StringUtils.removeEnd((String)effectiveConfigRootPath, (String)"/");
        return effectiveConfigRootPath;
    }

    private static void deleteObsoleteHistoryNodes(Node acHistoryRootNode, int nrOfHistoriesToSave) throws RepositoryException {
        NodeIterator childNodeIt = acHistoryRootNode.getNodes();
        TreeSet<Node> historyChildNodes = new TreeSet<Node>(new TimestampPropertyComparator());
        while (childNodeIt.hasNext()) {
            Node node = childNodeIt.nextNode();
            if (!node.getName().startsWith(HISTORY_NODE_NAME_PREFIX)) continue;
            historyChildNodes.add(node);
        }
        int index = 1;
        for (Node node : historyChildNodes) {
            if (index > nrOfHistoriesToSave) {
                LOG.debug("delete obsolete history node: ", (Object)node.getPath());
                node.remove();
            }
            ++index;
        }
    }

    static List<AcToolExecution> getAcToolExecutions(Session session) throws RepositoryException, PathNotFoundException {
        Node acHistoryRootNode = HistoryUtils.getAcHistoryRootNode(session);
        TreeSet<AcToolExecutionImpl> historyInfos = new TreeSet<AcToolExecutionImpl>();
        NodeIterator iterator = acHistoryRootNode.getNodes();
        while (iterator.hasNext()) {
            Node node = (Node)iterator.next();
            if (node == null || !node.getName().startsWith(HISTORY_NODE_NAME_PREFIX)) continue;
            String configRoot = node.hasProperty(PROPERTY_CONFIG_ROOT_PATH) ? node.getProperty(PROPERTY_CONFIG_ROOT_PATH).getString() : null;
            int authorizableChanges = node.hasProperty(PROPERTY_AUTHORIZABLES_CHANGES) ? (int)node.getProperty(PROPERTY_AUTHORIZABLES_CHANGES).getLong() : -1;
            int aclChanges = node.hasProperty(PROPERTY_ACL_CHANGES) ? (int)node.getProperty(PROPERTY_ACL_CHANGES).getLong() : -1;
            historyInfos.add(new AcToolExecutionImpl(HistoryUtils.getIdFromPath(node.getPath()), node.getPath(), new Date(node.getProperty(PROPERTY_TIMESTAMP).getLong()), node.getProperty(PROPERTY_SUCCESS).getBoolean(), configRoot, authorizableChanges, aclChanges));
        }
        return new ArrayList<AcToolExecution>(historyInfos);
    }

    static String getIdFromPath(String path) {
        return StringUtils.removeStart((String)Text.getName((String)path), (String)HISTORY_NODE_NAME_PREFIX);
    }

    static String getPathFromId(String id, String rootPath) {
        return rootPath + "/" + HISTORY_NODE_NAME_PREFIX + id;
    }

    public static String getLogTxt(Session session, String path, boolean includeVerbose, int maxLineWidth) {
        return HistoryUtils.getLog(session, path, "\n", includeVerbose, maxLineWidth);
    }

    public static String getLogHtml(Session session, String path, boolean includeVerbose, int maxLineWidth) {
        return HistoryUtils.getLog(session, path, "<br />", includeVerbose, maxLineWidth);
    }

    public static String getLog(Session session, String path, String lineFeedSymbol, boolean includeVerbose, int maxLineWidth) {
        StringBuilder sb = new StringBuilder();
        try {
            String line;
            Node historyNode;
            Node node = historyNode = path.startsWith("/") ? session.getNode(path) : HistoryUtils.getAcHistoryRootNode(session).getNode(path);
            if (historyNode != null) {
                sb.append("Installation triggered: " + historyNode.getProperty(PROPERTY_INSTALLATION_DATE).getString());
                if (historyNode.hasProperty(PROPERTY_MESSAGES)) {
                    sb.append("\n");
                    sb.append(historyNode.getProperty(PROPERTY_MESSAGES).getString());
                } else {
                    Node logFileNode = includeVerbose ? historyNode.getNode(LOG_FILE_NAME_VERBOSE) : historyNode.getNode(LOG_FILE_NAME);
                    sb.append("\n");
                    sb.append(IOUtils.toString((InputStream)JcrUtils.readFile((Node)logFileNode), (Charset)StandardCharsets.UTF_8));
                }
                sb.append(lineFeedSymbol + "Execution time: " + PersistableInstallationLogger.msHumanReadable(historyNode.getProperty(PROPERTY_EXECUTION_TIME).getLong()));
                sb.append(lineFeedSymbol + "Success: " + historyNode.getProperty(PROPERTY_SUCCESS).getBoolean());
            }
            StringReader reader = new StringReader(sb.toString());
            BufferedReader bufferedReader = new BufferedReader(reader);
            StringBuilder normalizingLineFeedStringBuilder = new StringBuilder();
            while ((line = bufferedReader.readLine()) != null) {
                if (maxLineWidth > 0 && line.length() > maxLineWidth) {
                    line = WordUtils.wrap((String)line, (int)maxLineWidth, (String)lineFeedSymbol, (boolean)false);
                }
                normalizingLineFeedStringBuilder.append(line);
                normalizingLineFeedStringBuilder.append(lineFeedSymbol);
            }
            return normalizingLineFeedStringBuilder.toString();
        }
        catch (IOException | RepositoryException e) {
            LOG.error("ERROR while retrieving log: " + e, e);
            return "ERROR while retrieving log: " + e;
        }
    }
}

