/*
 * Decompiled with CFR 0.152.
 */
package biz.netcentric.cq.tools.actool.history.impl;

import biz.netcentric.cq.tools.actool.api.HistoryEntry;
import biz.netcentric.cq.tools.actool.api.InstallationLog;
import biz.netcentric.cq.tools.actool.api.InstallationLogLevel;
import biz.netcentric.cq.tools.actool.api.InstallationResult;
import biz.netcentric.cq.tools.actool.comparators.HistoryEntryComparator;
import biz.netcentric.cq.tools.actool.history.InstallationLogger;
import java.io.Closeable;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.sql.Timestamp;
import java.text.DateFormat;
import java.text.NumberFormat;
import java.text.SimpleDateFormat;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import org.slf4j.Logger;

public class PersistableInstallationLogger
implements InstallationLogger,
InstallationLog,
InstallationResult,
Closeable {
    static final String EOL = "\n";
    protected static final String MSG_IDENTIFIER_ERROR = "ERROR: ";
    protected static final String MSG_IDENTIFIER_WARNING = "WARNING: ";
    private Set<HistoryEntry> warnings = new HashSet<HistoryEntry>();
    private Set<HistoryEntry> messages = new HashSet<HistoryEntry>();
    private Set<HistoryEntry> errors = new HashSet<HistoryEntry>();
    private Set<HistoryEntry> verboseMessages = new HashSet<HistoryEntry>();
    private boolean success = true;
    private final Date installationDate;
    private long executionTime;
    private long msgIndex = 0L;
    private String mergedAndProcessedConfig;
    private Map<String, String> configFileContentsByName;
    private String crxPackageName;
    private int countAclsNoChange = 0;
    private int countAclsChanged = 0;
    private int countAclsPathDoesNotExist = 0;
    private int countActionCacheHit = 0;
    private int countActionCacheMiss = 0;
    private int countAuthorizablesCreated = 0;
    private int countAuthorizablesMoved = 0;
    private int missingParentPathsForInitialContent = 0;
    private DateFormat timestampFormat = new SimpleDateFormat("HH:mm:ss.SSS");
    private final Collection<BiConsumer<InstallationLogLevel, String>> listeners = new CopyOnWriteArrayList<BiConsumer<InstallationLogLevel, String>>();
    private final Collection<Consumer<Boolean>> finishListeners = new CopyOnWriteArrayList<Consumer<Boolean>>();

    public PersistableInstallationLogger() {
        this.installationDate = new Date();
    }

    public Date getInstallationDate() {
        return this.installationDate;
    }

    public long getExecutionTime() {
        return this.executionTime;
    }

    public void setExecutionTime(long time) {
        this.executionTime = time;
    }

    public Set<HistoryEntry> getWarnings() {
        return this.warnings;
    }

    public String getMergedAndProcessedConfig() {
        return this.mergedAndProcessedConfig;
    }

    public void setMergedAndProcessedConfig(String mergedAndProcessedConfig) {
        this.mergedAndProcessedConfig = mergedAndProcessedConfig;
    }

    public Map<String, String> getConfigFileContentsByName() {
        return this.configFileContentsByName;
    }

    public void setConfigFileContentsByName(Map<String, String> configFileContentsByName) {
        this.configFileContentsByName = configFileContentsByName;
    }

    @Override
    public String getCrxPackageName() {
        return this.crxPackageName;
    }

    public void setCrxPackageName(String crxPackageName) {
        this.crxPackageName = crxPackageName;
    }

    @Override
    public void addWarning(Logger log, String warning) {
        log.warn(warning);
        this.addWarning(warning);
    }

    protected void addWarning(String warning) {
        this.warnings.add(new HistoryEntry(this.msgIndex, new Timestamp(new Date().getTime()), MSG_IDENTIFIER_WARNING + warning));
        this.listeners.forEach(l -> l.accept(InstallationLogLevel.WARNING, warning));
        ++this.msgIndex;
    }

    @Override
    public void addMessage(Logger log, String message) {
        log.info(message);
        this.addMessage(message);
    }

    protected void addMessage(String message) {
        this.messages.add(new HistoryEntry(this.msgIndex, new Timestamp(new Date().getTime()), " " + message));
        this.listeners.forEach(l -> l.accept(InstallationLogLevel.INFO, message));
        ++this.msgIndex;
    }

    @Override
    public void addError(Logger log, String error, Throwable e) {
        if (e != null) {
            log.error(error, e);
        } else {
            log.error(error);
        }
        this.addError(error, e);
    }

    @Override
    public void addError(String error, Throwable e) {
        String fullErrorValue = error;
        if (e != null) {
            fullErrorValue = fullErrorValue + " / e=" + e;
        }
        this.errors.add(new HistoryEntry(this.msgIndex, new Timestamp(new Date().getTime()), MSG_IDENTIFIER_ERROR + fullErrorValue));
        this.listeners.forEach(l -> l.accept(InstallationLogLevel.ERROR, error));
        this.success = false;
        ++this.msgIndex;
        if (e != null) {
            StringWriter sw = new StringWriter();
            e.printStackTrace(new PrintWriter(sw));
            this.addVerboseMessage(sw.toString());
        }
    }

    @Override
    public void addVerboseMessage(Logger log, String message) {
        log.debug(message);
        this.addVerboseMessage(message);
    }

    protected void addVerboseMessage(String message) {
        this.verboseMessages.add(new HistoryEntry(this.msgIndex, new Timestamp(new Date().getTime()), " " + message));
        this.listeners.forEach(l -> l.accept(InstallationLogLevel.TRACE, message));
        ++this.msgIndex;
    }

    @Override
    public Set<HistoryEntry> getMessages() {
        return this.messages;
    }

    @Override
    public Set<HistoryEntry> getErrors() {
        return this.errors;
    }

    @Override
    public boolean isSuccess() {
        return this.success;
    }

    public void setSuccess(boolean success) {
        this.success = success;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(EOL + this.getMessageHistory() + EOL);
        sb.append("\nExecution time: " + PersistableInstallationLogger.msHumanReadable(this.executionTime) + EOL);
        sb.append("\nSuccess: " + this.success);
        return sb.toString();
    }

    @Override
    public String getMessageHistory() {
        return this.getMessageString(this.getMessageSet(this.warnings, this.messages, this.errors));
    }

    @Override
    public String getVerboseMessageHistory() {
        return this.getMessageString(this.getMessageSet(this.warnings, this.messages, this.verboseMessages, this.errors));
    }

    private Set<HistoryEntry> getMessageSet(Set<HistoryEntry> ... sets) {
        TreeSet<HistoryEntry> resultSet = new TreeSet<HistoryEntry>(new HistoryEntryComparator());
        for (Set<HistoryEntry> set : sets) {
            for (HistoryEntry entry : set) {
                resultSet.add(entry);
            }
        }
        return resultSet;
    }

    private String getMessageString(Set<HistoryEntry> messageHistorySet) {
        StringBuilder sb = new StringBuilder();
        if (!messageHistorySet.isEmpty()) {
            for (HistoryEntry entry : messageHistorySet) {
                sb.append(EOL + this.timestampFormat.format(entry.getTimestamp()) + ": " + entry.getMessage());
            }
        }
        return sb.toString();
    }

    public static String msHumanReadable(long millis) {
        double number;
        double currentDivisor;
        String[] units = new String[]{"ms", "sec", "min", "h", "days"};
        double[] divisors = new double[]{1000.0, 60.0, 60.0, 24.0};
        int magnitude = 0;
        for (number = (double)millis; !(number < (currentDivisor = divisors[Math.min(magnitude, divisors.length - 1)])); number /= currentDivisor) {
            if (++magnitude < units.length - 1) continue;
        }
        NumberFormat format = NumberFormat.getNumberInstance(Locale.UK);
        format.setMinimumFractionDigits(0);
        format.setMaximumFractionDigits(1);
        String result = format.format(number) + units[magnitude];
        return result;
    }

    @Override
    public void incCountAclsNoChange() {
        ++this.countAclsNoChange;
    }

    @Override
    public int getCountAclsUnchanged() {
        return this.countAclsNoChange;
    }

    @Override
    public void incCountAclsChanged() {
        ++this.countAclsChanged;
    }

    @Override
    public int getCountAclsChanged() {
        return this.countAclsChanged;
    }

    @Override
    public void incCountAclsPathDoesNotExist() {
        ++this.countAclsPathDoesNotExist;
    }

    @Override
    public int getCountAclsPathDoesNotExist() {
        return this.countAclsPathDoesNotExist;
    }

    @Override
    public void incCountActionCacheMiss() {
        ++this.countActionCacheMiss;
    }

    @Override
    public int getCountActionCacheMiss() {
        return this.countActionCacheMiss;
    }

    @Override
    public void incCountActionCacheHit() {
        ++this.countActionCacheHit;
    }

    @Override
    public int getCountActionCacheHit() {
        return this.countActionCacheHit;
    }

    @Override
    public void incMissingParentPathsForInitialContent() {
        ++this.missingParentPathsForInitialContent;
    }

    @Override
    public int getMissingParentPathsForInitialContent() {
        return this.missingParentPathsForInitialContent;
    }

    @Override
    public void incCountAuthorizablesCreated() {
        ++this.countAuthorizablesCreated;
    }

    @Override
    public void incCountAuthorizablesMoved() {
        ++this.countAuthorizablesMoved;
    }

    @Override
    public int getCountAuthorizablesCreated() {
        return this.countAuthorizablesCreated;
    }

    @Override
    public int getCountAuthorizablesMoved() {
        return this.countAuthorizablesMoved;
    }

    @Override
    public void close() throws IOException {
        this.finishListeners.forEach(l -> l.accept(this.success));
    }

    public void attachMessageListener(BiConsumer<InstallationLogLevel, String> messageListener) {
        this.listeners.add(messageListener);
    }

    public void attachFinishListener(Consumer<Boolean> finishListener) {
        this.finishListeners.add(finishListener);
    }
}

