/*
 * Decompiled with CFR 0.152.
 */
package biz.netcentric.cq.tools.actool.ims;

import biz.netcentric.cq.tools.actool.api.InstallationOptions;
import biz.netcentric.cq.tools.actool.configmodel.AuthorizableConfigBean;
import biz.netcentric.cq.tools.actool.externalusermanagement.ExternalGroupManagement;
import biz.netcentric.cq.tools.actool.ims.request.ActionCommand;
import biz.netcentric.cq.tools.actool.ims.request.AddGroupMembers;
import biz.netcentric.cq.tools.actool.ims.request.AddGroupMembership;
import biz.netcentric.cq.tools.actool.ims.request.CreateGroupStep;
import biz.netcentric.cq.tools.actool.ims.request.RemoveGroupMembership;
import biz.netcentric.cq.tools.actool.ims.request.Step;
import biz.netcentric.cq.tools.actool.ims.request.UserActionCommand;
import biz.netcentric.cq.tools.actool.ims.request.UserGroupActionCommand;
import biz.netcentric.cq.tools.actool.ims.response.AccessToken;
import biz.netcentric.cq.tools.actool.ims.response.ActionCommandResponse;
import biz.netcentric.cq.tools.actool.ims.response.GroupResponse;
import biz.netcentric.cq.tools.actool.ims.response.IMSGroup;
import biz.netcentric.cq.tools.actool.ims.response.IMSUser;
import biz.netcentric.cq.tools.actool.ims.response.UsersInGroupResponse;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Locale;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.http.Consts;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpEntityEnclosingRequest;
import org.apache.http.HttpMessage;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;
import org.apache.http.StatusLine;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.HttpResponseException;
import org.apache.http.client.ResponseHandler;
import org.apache.http.client.ServiceUnavailableRetryStrategy;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.osgi.services.HttpClientBuilderFactory;
import org.apache.http.protocol.HttpContext;
import org.apache.http.util.EntityUtils;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.ConfigurationPolicy;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.metatype.annotations.AttributeDefinition;
import org.osgi.service.metatype.annotations.AttributeType;
import org.osgi.service.metatype.annotations.Designate;
import org.osgi.service.metatype.annotations.ObjectClassDefinition;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(configurationPolicy=ConfigurationPolicy.REQUIRE)
@Designate(ocd=Configuration.class)
public class IMSUserManagement
implements ExternalGroupManagement {
    public static final Logger LOG = LoggerFactory.getLogger(IMSUserManagement.class);
    private static final int MAX_NUM_COMMANDS_PER_REQUEST = 10;
    private static final int MAX_NUM_GROUPS_PER_ADD_STEP = 10;
    private final Configuration config;
    private final CloseableHttpClient client;

    @Activate
    public IMSUserManagement(Configuration config, @Reference HttpClientBuilderFactory httpClientBuilderFactory) {
        this.config = config;
        RequestConfig requestConfig = RequestConfig.custom().setConnectTimeout(config.connectTimeout()).setConnectionRequestTimeout(config.socketTimeout()).setSocketTimeout(config.socketTimeout()).build();
        this.client = httpClientBuilderFactory.newBuilder().setDefaultRequestConfig(requestConfig).setServiceUnavailableRetryStrategy((ServiceUnavailableRetryStrategy)new TooManyRequestsRetryStrategy(3, 5)).build();
    }

    @Deactivate
    public void deactivate() throws IOException {
        this.client.close();
    }

    private URI getUserManagementActionUrl() throws URISyntaxException {
        return new URI(this.config.umapiBaseUrl()).resolve(new URI(null, null, "action/" + this.config.organizationId(), this.config.isTestOnly() ? "testOnly=true" : null, null));
    }

    private URI getUserManagementGroupsUrl(int page) throws URISyntaxException {
        return new URI(this.config.umapiBaseUrl()).resolve(new URI(null, null, "groups/" + this.config.organizationId() + "/" + page, null));
    }

    private URI getUserManagementUsersInGroupUrl(int page, String groupName) throws URISyntaxException {
        return new URI(this.config.umapiBaseUrl()).resolve(new URI(null, null, "users/" + this.config.organizationId() + "/" + page + "/" + groupName, null));
    }

    @Override
    public String getLabel() {
        return "Adobe IMS";
    }

    private boolean requireGroupUpdate(Map<String, IMSGroup> existingImsGroups, AuthorizableConfigBean groupConfig) {
        IMSGroup existingImsGroup = existingImsGroups.get(groupConfig.getAuthorizableId().toLowerCase(Locale.ROOT));
        if (existingImsGroup == null) {
            LOG.debug("Group {} does not exist yet", (Object)groupConfig.getAuthorizableId());
            return true;
        }
        return false;
    }

    List<ActionCommand> updateGroupAdminsCommands(String token, Collection<String> groups, boolean isAddOnly) throws IOException {
        LinkedList<ActionCommand> actionCommands = new LinkedList<ActionCommand>();
        if (this.config.groupAdmins() != null && this.config.groupAdmins().length > 0) {
            LinkedHashSet<String> groupAdmins = new LinkedHashSet<String>(Arrays.asList(this.config.groupAdmins()));
            HashMap<Object, UserMembershipChanges> usersMembershipChanges = new HashMap<Object, UserMembershipChanges>();
            Set<String> adminGroupNames = groups.stream().map(n -> "_admin_" + n).collect(Collectors.toSet());
            if (!isAddOnly) {
                for (String adminGroupName : adminGroupNames) {
                    Map<String, IMSUser> usersInAdminGroup = this.getUsersInGroup(token, adminGroupName);
                    LinkedHashSet<String> usersToRemove = new LinkedHashSet<String>(usersInAdminGroup.keySet());
                    usersToRemove.removeAll(groupAdmins);
                    for (String userToRemove : usersToRemove) {
                        UserMembershipChanges changes = usersMembershipChanges.computeIfAbsent(userToRemove, UserMembershipChanges::new);
                        changes.removeGroup(adminGroupName);
                    }
                    LinkedHashSet<String> usersToAdd = new LinkedHashSet<String>(groupAdmins);
                    usersToAdd.removeAll(usersInAdminGroup.keySet());
                    for (String userToAdd : usersToAdd) {
                        UserMembershipChanges changes = usersMembershipChanges.computeIfAbsent(userToAdd, UserMembershipChanges::new);
                        changes.addGroup(adminGroupName);
                    }
                }
            } else {
                for (String admin : this.config.groupAdmins()) {
                    UserMembershipChanges userMembershipChanges = new UserMembershipChanges(admin);
                    userMembershipChanges.addGroups(adminGroupNames);
                    usersMembershipChanges.put(admin, userMembershipChanges);
                }
            }
            for (UserMembershipChanges changes : usersMembershipChanges.values()) {
                int actionCommandsIndex = actionCommands.size();
                this.addMembershipSteps(changes.userName, actionCommands.listIterator(actionCommandsIndex), false, changes.groupsToRemove);
                this.addMembershipSteps(changes.userName, actionCommands.listIterator(actionCommandsIndex), true, changes.groupsToAdd);
            }
        }
        return actionCommands;
    }

    private void addMembershipSteps(String userName, ListIterator<ActionCommand> actionCommandsIterator, boolean isAdd, Collection<String> groupNames) {
        AtomicInteger groupCounter = new AtomicInteger();
        Collection<List<String>> groupNamesBatches = groupNames.stream().collect(Collectors.groupingBy(it -> groupCounter.getAndIncrement() / 10)).values();
        for (List<String> groupNamesBatch : groupNamesBatches) {
            ActionCommand actionCommand;
            if (actionCommandsIterator.hasNext()) {
                actionCommand = actionCommandsIterator.next();
            } else {
                actionCommand = new UserActionCommand(userName);
                actionCommandsIterator.add(actionCommand);
            }
            Step step = isAdd ? new AddGroupMembership(groupNamesBatch) : new RemoveGroupMembership(groupNamesBatch);
            actionCommand.addStep(step);
        }
    }

    @Override
    public int updateGroups(Collection<AuthorizableConfigBean> groupConfigs, InstallationOptions options) throws IOException {
        boolean isDiffMode;
        String token = this.getOAuthServer2ServerToken();
        Map<String, IMSGroup> existingImsGroups = Collections.emptyMap();
        boolean bl = isDiffMode = this.config.isDifferentialUpdates() && !options.shouldUpdateExistingExternalGroups();
        if (isDiffMode) {
            LOG.info("Executing IMS group update in differential update mode");
            existingImsGroups = this.getGroups(token);
        }
        long startEpoch = System.currentTimeMillis();
        LinkedList<ActionCommand> actionCommands = new LinkedList<ActionCommand>();
        LinkedList<String> updatedGroupNames = new LinkedList<String>();
        for (AuthorizableConfigBean groupConfig : groupConfigs) {
            if (isDiffMode && !this.requireGroupUpdate(existingImsGroups, groupConfig)) {
                LOG.info("Skip updating IMS group {} as considered up to date", (Object)groupConfig.getAuthorizableId());
                continue;
            }
            UserGroupActionCommand actionCommand = new UserGroupActionCommand(groupConfig.getAuthorizableId());
            CreateGroupStep createGroupStep = new CreateGroupStep();
            createGroupStep.description = groupConfig.getDescription();
            actionCommand.addStep(createGroupStep);
            if (this.config.productProfiles() != null && this.config.productProfiles().length > 0) {
                AddGroupMembers addMembers = new AddGroupMembers();
                addMembers.productProfileIds = new HashSet<String>(Arrays.asList(this.config.productProfiles()));
                actionCommand.addStep(addMembers);
            }
            updatedGroupNames.add(groupConfig.getAuthorizableId());
            actionCommands.add(actionCommand);
        }
        actionCommands.addAll(this.updateGroupAdminsCommands(token, updatedGroupNames, !options.shouldUpdateExistingExternalGroups()));
        AtomicInteger counter = new AtomicInteger();
        Collection<List<ActionCommand>> actionCommandsBatches = actionCommands.stream().collect(Collectors.groupingBy(it -> counter.getAndIncrement() / 10)).values();
        for (List<ActionCommand> actionCommandBatch : actionCommandsBatches) {
            ActionCommandResponse response = this.sendActionCommand(token, actionCommandBatch);
            if (!response.errors.isEmpty()) {
                throw new IOException("Errors updating groups: " + response.errors + " for request " + IMSUserManagement.getRequestInfo((HttpRequest)response.associatedRequest));
            }
            if (!response.warnings.isEmpty()) {
                LOG.warn("Some warnings during updating groups with request {}", (Object)IMSUserManagement.getRequestInfo((HttpRequest)response.associatedRequest));
                response.warnings.stream().forEach(w -> LOG.warn("Warning updating a group: {}", w));
            }
            if (this.config.overallTimeout() <= 0L || System.currentTimeMillis() - startEpoch <= this.config.overallTimeout()) continue;
            throw new IOException("Timeout updating IMS groups, exceeded overall timeout of " + this.config.overallTimeout() + " ms");
        }
        return updatedGroupNames.size();
    }

    static String getRequestInfo(HttpRequest request) throws IOException {
        if (request == null) {
            return "Unknown";
        }
        StringBuilder requestInfo = new StringBuilder();
        requestInfo.append(request);
        if (request instanceof HttpEntityEnclosingRequest) {
            HttpEntity entity = ((HttpEntityEnclosingRequest)request).getEntity();
            ByteArrayOutputStream bs = new ByteArrayOutputStream();
            entity.writeTo((OutputStream)bs);
            requestInfo.append("\nwith payload:\n").append(new String(bs.toByteArray()));
        }
        return requestInfo.toString();
    }

    private void setHttpAuthenticationHeaders(HttpMessage httpMessage, String token) {
        httpMessage.setHeader("Authorization", "Bearer " + token);
        httpMessage.setHeader("X-Api-Key", this.config.clientId());
    }

    Map<String, IMSGroup> getGroups(String token) throws IOException {
        int page = 0;
        boolean isLastPage = false;
        HashMap<String, IMSGroup> groups = new HashMap<String, IMSGroup>();
        while (!isLastPage) {
            GroupResponse response = this.getGroups(token, page++);
            isLastPage = response.isLastPage;
            groups.putAll(response.groups.stream().filter(g -> "USER_GROUP".equals(g.type)).collect(Collectors.toMap(g -> g.getGroupName().toLowerCase(Locale.ROOT), Function.identity(), (a, b) -> {
                LOG.warn("Duplicate group name {} found, keeping first occurrence", (Object)a.getGroupName());
                return a;
            })));
        }
        return groups;
    }

    GroupResponse getGroups(String token, int page) throws IOException {
        HttpGet httpGet;
        final ObjectMapper objectMapper = new ObjectMapper();
        try {
            httpGet = new HttpGet(this.getUserManagementGroupsUrl(page));
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException("Could not create valid URI from configuration", e);
        }
        this.setHttpAuthenticationHeaders((HttpMessage)httpGet, token);
        ResponseHandler<GroupResponse> rh = new ResponseHandler<GroupResponse>(){

            public GroupResponse handleResponse(HttpResponse response) throws IOException {
                StatusLine statusLine = response.getStatusLine();
                HttpEntity entity = response.getEntity();
                if (statusLine.getStatusCode() >= 300) {
                    throw new HttpResponseException(statusLine.getStatusCode(), statusLine.getReasonPhrase() + ", body:" + EntityUtils.toString((HttpEntity)entity) + ", for request " + IMSUserManagement.getRequestInfo((HttpRequest)httpGet));
                }
                if (entity == null) {
                    throw new ClientProtocolException("Response contains no content for request " + IMSUserManagement.getRequestInfo((HttpRequest)httpGet));
                }
                GroupResponse groupResponse = (GroupResponse)objectMapper.readValue(entity.getContent(), GroupResponse.class);
                groupResponse.associatedRequest = httpGet;
                return groupResponse;
            }
        };
        LOG.debug("Calling UMAPI via {}", (Object)httpGet);
        return (GroupResponse)this.client.execute((HttpUriRequest)httpGet, (ResponseHandler)rh);
    }

    Map<String, IMSUser> getUsersInGroup(String token, String name) throws IOException {
        UsersInGroupResponse response;
        int page = 0;
        boolean isLastPage = false;
        HashMap<String, IMSUser> users = new HashMap<String, IMSUser>();
        while (!isLastPage && (response = this.getUsersInGroup(token, name, page++)) != null) {
            isLastPage = response.isLastPage;
            users.putAll(response.users.stream().collect(Collectors.toMap(IMSUser::getUsername, Function.identity())));
        }
        return users;
    }

    UsersInGroupResponse getUsersInGroup(String token, final String name, int page) throws IOException {
        HttpGet httpGet;
        final ObjectMapper objectMapper = new ObjectMapper();
        try {
            httpGet = new HttpGet(this.getUserManagementUsersInGroupUrl(page, name));
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException("Could not create valid URI from configuration", e);
        }
        this.setHttpAuthenticationHeaders((HttpMessage)httpGet, token);
        ResponseHandler<UsersInGroupResponse> rh = new ResponseHandler<UsersInGroupResponse>(){

            public UsersInGroupResponse handleResponse(HttpResponse response) throws IOException {
                StatusLine statusLine = response.getStatusLine();
                HttpEntity entity = response.getEntity();
                if (statusLine.getStatusCode() == 404) {
                    LOG.debug("Group {} does not exist", (Object)name);
                    return null;
                }
                if (statusLine.getStatusCode() >= 300) {
                    throw new HttpResponseException(statusLine.getStatusCode(), statusLine.getReasonPhrase() + ", body:" + EntityUtils.toString((HttpEntity)entity) + ", for request " + IMSUserManagement.getRequestInfo((HttpRequest)httpGet));
                }
                if (entity == null) {
                    throw new ClientProtocolException("Response contains no content for request " + IMSUserManagement.getRequestInfo((HttpRequest)httpGet));
                }
                UsersInGroupResponse groupResponse = (UsersInGroupResponse)objectMapper.readValue(entity.getContent(), UsersInGroupResponse.class);
                groupResponse.associatedRequest = httpGet;
                return groupResponse;
            }
        };
        LOG.debug("Calling UMAPI via {}", (Object)httpGet);
        return (UsersInGroupResponse)this.client.execute((HttpUriRequest)httpGet, (ResponseHandler)rh);
    }

    private ActionCommandResponse sendActionCommand(String token, Collection<ActionCommand> actions) throws IOException {
        HttpPost httpPost;
        final ObjectMapper objectMapper = new ObjectMapper();
        try {
            httpPost = new HttpPost(this.getUserManagementActionUrl());
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException("Could not create valid URI from configuration", e);
        }
        String jsonPayload = objectMapper.writeValueAsString(actions);
        httpPost.setEntity((HttpEntity)new StringEntity(jsonPayload, ContentType.create((String)"application/json")));
        this.setHttpAuthenticationHeaders((HttpMessage)httpPost, token);
        ResponseHandler<ActionCommandResponse> rh = new ResponseHandler<ActionCommandResponse>(){

            public ActionCommandResponse handleResponse(HttpResponse response) throws IOException {
                StatusLine statusLine = response.getStatusLine();
                HttpEntity entity = response.getEntity();
                if (statusLine.getStatusCode() >= 300) {
                    throw new HttpResponseException(statusLine.getStatusCode(), statusLine.getReasonPhrase() + ", body:" + EntityUtils.toString((HttpEntity)entity) + ", for request " + IMSUserManagement.getRequestInfo((HttpRequest)httpPost));
                }
                if (entity == null) {
                    throw new ClientProtocolException("Response contains no content for request " + IMSUserManagement.getRequestInfo((HttpRequest)httpPost));
                }
                ActionCommandResponse actionCommandResponse = (ActionCommandResponse)objectMapper.readValue(entity.getContent(), ActionCommandResponse.class);
                actionCommandResponse.associatedRequest = httpPost;
                return actionCommandResponse;
            }
        };
        LOG.debug("Calling UMAPI via {}", (Object)httpPost);
        return (ActionCommandResponse)this.client.execute((HttpUriRequest)httpPost, (ResponseHandler)rh);
    }

    String getOAuthServer2ServerToken() throws IOException {
        HttpPost httpPost = new HttpPost(this.config.imsTokenEndpointUrl());
        ArrayList<BasicNameValuePair> params = new ArrayList<BasicNameValuePair>();
        params.add(new BasicNameValuePair("client_id", this.config.clientId()));
        params.add(new BasicNameValuePair("client_secret", this.config.clientSecret()));
        params.add(new BasicNameValuePair("grant_type", "client_credentials"));
        params.add(new BasicNameValuePair("scope", String.join((CharSequence)",", this.config.scopes())));
        UrlEncodedFormEntity entity = new UrlEncodedFormEntity(params, Consts.UTF_8);
        httpPost.setEntity((HttpEntity)entity);
        ResponseHandler<AccessToken> rh = new ResponseHandler<AccessToken>(){

            public AccessToken handleResponse(HttpResponse response) throws IOException {
                StatusLine statusLine = response.getStatusLine();
                HttpEntity entity = response.getEntity();
                if (statusLine.getStatusCode() >= 300) {
                    throw new HttpResponseException(statusLine.getStatusCode(), statusLine.getReasonPhrase() + ", body:" + EntityUtils.toString((HttpEntity)entity));
                }
                if (entity == null) {
                    throw new ClientProtocolException("Response contains no content");
                }
                ObjectMapper objectMapper = new ObjectMapper();
                ContentType contentType = ContentType.getOrDefault((HttpEntity)entity);
                Charset charset = contentType.getCharset();
                try (InputStreamReader reader = new InputStreamReader(entity.getContent(), charset);){
                    AccessToken accessToken = (AccessToken)objectMapper.readValue((Reader)reader, AccessToken.class);
                    return accessToken;
                }
            }
        };
        AccessToken token = (AccessToken)this.client.execute((HttpUriRequest)httpPost, (ResponseHandler)rh);
        return token.token;
    }

    private static final class UserMembershipChanges {
        private final String userName;
        private final Set<String> groupsToRemove;
        private final Set<String> groupsToAdd;

        public UserMembershipChanges(String userName) {
            this.userName = userName;
            this.groupsToRemove = new LinkedHashSet<String>();
            this.groupsToAdd = new LinkedHashSet<String>();
        }

        public boolean removeGroup(String group) {
            return this.groupsToRemove.add(group);
        }

        public boolean addGroup(String group) {
            return this.groupsToAdd.add(group);
        }

        public boolean addGroups(Collection<String> groups) {
            return this.groupsToAdd.addAll(groups);
        }
    }

    static final class TooManyRequestsRetryStrategy
    implements ServiceUnavailableRetryStrategy {
        private static final double DEFAULT_MULTIPLIER = 1.5;
        private final int maxRetryCount;
        private final int defaultRetryDelayInSeconds;
        private long retryDelayInMilliseconds;
        private final Random random = new Random();

        public TooManyRequestsRetryStrategy(int maxRetryCount, int defaultRetryDelayInSeconds) {
            this.maxRetryCount = maxRetryCount;
            this.defaultRetryDelayInSeconds = defaultRetryDelayInSeconds;
            this.retryDelayInMilliseconds = (long)defaultRetryDelayInSeconds * 1000L;
        }

        public boolean retryRequest(HttpResponse response, int executionCount, HttpContext context) {
            boolean shouldRetry;
            this.retryDelayInMilliseconds = (long)this.defaultRetryDelayInSeconds * 1000L;
            boolean bl = shouldRetry = executionCount <= this.maxRetryCount && response.getStatusLine().getStatusCode() == 429;
            if (shouldRetry) {
                Header retryAfterHeader = response.getFirstHeader("Retry-After");
                if (retryAfterHeader != null) {
                    this.retryDelayInMilliseconds = (long)Integer.parseInt(retryAfterHeader.getValue()) * 1000L;
                    LOG.info("Received 429 status with Retry-After header {}", (Object)retryAfterHeader.getValue());
                }
                this.retryDelayInMilliseconds = (long)((double)this.retryDelayInMilliseconds * Math.pow(1.5, executionCount));
                long jitter = (long)this.random.nextInt(this.defaultRetryDelayInSeconds) * 1000L;
                this.retryDelayInMilliseconds += jitter;
                LOG.info("Schedule retry {} of {} in {} ms (with jitter of {} ms) due to 429 response", new Object[]{executionCount, this.maxRetryCount, this.retryDelayInMilliseconds, jitter});
            }
            return shouldRetry;
        }

        public long getRetryInterval() {
            return this.retryDelayInMilliseconds;
        }
    }

    @ObjectClassDefinition(name="AC Tool Adobe IMS User Management", description="Settings of the API for user management tasks (UMAPI) in the Adobe IMS")
    protected static @interface Configuration {
        @AttributeDefinition(name="UMAPI Base URL", description="UMAPI Endpoint Base URL (the common part of all UMAPI endpoints)")
        public String umapiBaseUrl() default "https://usermanagement.adobe.io/v2/usermanagement/";

        @AttributeDefinition(name="Organization ID", description="The unique identifier for an organization. This is a string of the form A495E53@AdobeOrg where the prefix before the @ is a hexadecimal number. You can find this value as part of the URL path for the organization in the Adobe Admin Console or in the Adobe Developer Console for your User Management integration.")
        public String organizationId();

        @AttributeDefinition(name="Test Only", description="If true, parameter syntactic and (limited) semantic checking is done, but the specified operations are not performed, so no user/group accounts or group memberships are created, changed, or deleted.")
        public boolean isTestOnly();

        @AttributeDefinition(name="IMS Token Endpoint URL", description="The URL from which to retrieve the access token.")
        public String imsTokenEndpointUrl() default "https://ims-na1.adobelogin.com/ims/token/v3";

        @AttributeDefinition(name="Client ID", description="The client ID exposed in the Adobe IO Console for the UMAPI integration used to authorize the session. Also used as \"X-Api-Key\" header value.")
        public String clientId();

        @AttributeDefinition(name="Client Secret", description="The client secret exposed in the Adobe IO Console for the UMAPI integration used to authorize the session.", type=AttributeType.PASSWORD)
        public String clientSecret();

        @AttributeDefinition(name="OAuth Scopes", description="Scopes for which the access token is requested.")
        public String[] scopes() default {"openid", "AdobeID", "user_management_sdk"};

        @AttributeDefinition(name="Connect Timeout", description="The maximum time to establish the connection with the remote host in milliseconds.")
        public int connectTimeout() default 2000;

        @AttributeDefinition(name="Socket Timeout", description="The time waiting for data \u2013 after establishing the connection; maximum time of inactivity between two data packets. Given in milliseconds.")
        public int socketTimeout() default 10000;

        @AttributeDefinition(name="Overall Timeout", description="The maximum time updating groups in IMS should take. If expired the operation fails with an exception. Negative values mean no timeout. Given in milliseconds.")
        public long overallTimeout() default -1L;

        @AttributeDefinition(name="AEM Product Profiles", description="The given product profile names are automatically added to each synchronized IMS group. The given product profile names must exist for an AEM product!")
        public String[] productProfiles() default {};

        @AttributeDefinition(name="Group Administrators", description="The given users are automatically added to each synchronized IMS group as administrator. The given user ids must already exist!")
        public String[] groupAdmins() default {};

        @AttributeDefinition(name="Differential Updates", description="If true, only groups that have changed are updated. This is only a heuristics and currently leads to only adding new groups but never updating existing group (with same names). Also in some cases the additional request to get all groups may be more expensive than just updating all groups.")
        public boolean isDifferentialUpdates() default false;
    }
}

