/*
 * Decompiled with CFR 0.152.
 */
package biz.netcentric.cq.tools.actool.ui;

import biz.netcentric.cq.tools.actool.api.AcInstallationService;
import biz.netcentric.cq.tools.actool.api.InstallationLogLevel;
import biz.netcentric.cq.tools.actool.api.InstallationOptionsBuilder;
import biz.netcentric.cq.tools.actool.dumpservice.ConfigDumpService;
import biz.netcentric.cq.tools.actool.helper.UncheckedRepositoryException;
import biz.netcentric.cq.tools.actool.history.AcHistoryService;
import biz.netcentric.cq.tools.actool.history.AcToolExecution;
import biz.netcentric.cq.tools.actool.impl.AcInstallationServiceImpl;
import biz.netcentric.cq.tools.actool.impl.AcInstallationServiceInternal;
import biz.netcentric.cq.tools.actool.ui.BoundPrincipals;
import biz.netcentric.cq.tools.actool.ui.HtmlWriter;
import biz.netcentric.cq.tools.actool.user.UserProcessor;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.UncheckedIOException;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.Value;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringEscapeUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.jackrabbit.api.JackrabbitSession;
import org.apache.jackrabbit.api.security.user.User;
import org.apache.sling.api.SlingHttpServletRequest;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferencePolicyOption;
import org.osgi.service.metatype.annotations.AttributeDefinition;
import org.osgi.service.metatype.annotations.Designate;
import org.osgi.service.metatype.annotations.ObjectClassDefinition;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(service={AcToolUiService.class})
@Designate(ocd=Configuration.class)
public class AcToolUiService {
    private static final String CONTENT_DISPOSITION = "Content-Disposition";
    private static final Logger LOG = LoggerFactory.getLogger(AcToolUiService.class);
    public static final String PARAM_CONFIGURATION_ROOT_PATH = "configurationRootPath";
    public static final String PARAM_APPLY_ONLY_IF_CHANGED = "applyOnlyIfChanged";
    private static final String PARAM_UPDATE_EXISTING_EXTERNAL_GROUPS = "updateExistingExternalGroups";
    public static final String PARAM_BASE_PATHS = "basePaths";
    public static final String PARAM_SHOW_LOG_ID = "showLogId";
    public static final String PARAM_SHOW_LOG_VERBOSE = "showLogVerbose";
    public static final String PAGE_NAME = "actool";
    static final String SUFFIX_DUMP_YAML = "dump.yaml";
    static final String SUFFIX_USERS_CSV = "users.csv";
    static final String SUFFIX_DOWNLOAD_LOG = "download.log";
    static final String SUFFIX_STREAM_LOG = "streamlog";
    private static final int MAX_LINE_WIDTH = 180;
    @Reference(policyOption=ReferencePolicyOption.GREEDY)
    private ConfigDumpService dumpService;
    @Reference(policyOption=ReferencePolicyOption.GREEDY)
    private UserProcessor userProcessor;
    @Reference(policyOption=ReferencePolicyOption.GREEDY)
    AcInstallationServiceInternal acInstallationService;
    @Reference(policyOption=ReferencePolicyOption.GREEDY)
    private AcHistoryService acHistoryService;
    private final Map<String, String> countryCodePerName;
    private final Configuration config;
    private BlockingQueue<String> messages;

    @Activate
    public AcToolUiService(Configuration config) {
        this.config = config;
        this.countryCodePerName = new HashMap<String, String>();
        for (String iso : Locale.getISOCountries()) {
            Locale l = new Locale(Locale.ENGLISH.getLanguage(), iso);
            this.countryCodePerName.put(l.getDisplayCountry(), iso);
        }
    }

    protected void doGet(HttpServletRequest req, HttpServletResponse resp, String basePath, boolean isTouchUi) throws ServletException, IOException {
        if (req.getRequestURI().startsWith(basePath)) {
            if (req.getRequestURI().endsWith(SUFFIX_DUMP_YAML)) {
                this.callWhenReadAccessGranted(req, resp, this::streamDumpToResponse);
                return;
            }
            if (req.getRequestURI().endsWith(SUFFIX_USERS_CSV)) {
                this.callWhenReadAccessGranted(req, resp, this::streamUsersCsvToResponse);
                return;
            }
            if (req.getRequestURI().endsWith(SUFFIX_DOWNLOAD_LOG)) {
                this.downloadLog(req, resp);
                return;
            }
            if (req.getRequestURI().endsWith(SUFFIX_STREAM_LOG)) {
                this.streamLog(req, resp);
                return;
            }
            String resourcePath = req.getRequestURI().substring(basePath.length());
            if (resourcePath.startsWith("/res/")) {
                if (!this.spoolResource(req, resourcePath, resp)) {
                    resp.sendError(404);
                }
                return;
            }
        }
        this.renderUi(req, resp, basePath, isTouchUi);
    }

    protected final boolean spoolResource(HttpServletRequest request, String resourcePath, HttpServletResponse response) throws IOException {
        URL url = this.getClass().getResource(resourcePath);
        if (url == null) {
            return false;
        }
        URLConnection connection = url.openConnection();
        try (InputStream ins = connection.getInputStream();){
            int rd;
            if (ins == null) {
                boolean bl = false;
                return bl;
            }
            long lastModified = connection.getLastModified();
            if (lastModified > 0L) {
                long ifModifiedSince = request.getDateHeader("If-Modified-Since");
                if (ifModifiedSince >= lastModified / 1000L * 1000L) {
                    response.setStatus(304);
                    boolean bl = true;
                    return bl;
                }
                response.setDateHeader("Last-Modified", lastModified);
            }
            response.setContentType(request.getServletContext().getMimeType(request.getPathInfo()));
            if (connection.getContentLength() != -1) {
                response.setContentLength(connection.getContentLength());
            }
            response.setStatus(200);
            ServletOutputStream out = response.getOutputStream();
            byte[] buf = new byte[2048];
            while ((rd = ins.read(buf)) >= 0) {
                out.write(buf, 0, rd);
            }
        }
        return true;
    }

    private void callWhenReadAccessGranted(HttpServletRequest req, HttpServletResponse resp, Consumer<HttpServletResponse> responseConsumer) throws IOException, ServletException {
        if (!this.isOneOfPrincipalNamesBound(req, this.config.readAccessPrincipalNames())) {
            resp.sendError(403, "You do not have sufficent permissions to export users/groups/permissions");
            return;
        }
        try {
            responseConsumer.accept(resp);
        }
        catch (UncheckedIOException e) {
            throw e.getCause();
        }
    }

    protected void doPost(HttpServletRequest req, HttpServletResponse resp) throws IOException, ServletException {
        if (!this.isOneOfPrincipalNamesBound(req, this.config.writeAccessPrincipalNames())) {
            resp.sendError(403, "You do not have sufficent permissions to apply the configuration");
            return;
        }
        RequestParameters reqParams = RequestParameters.fromRequest(req, this.acInstallationService);
        LOG.info("Received POST request to apply AC Tool config with configurationRootPath={} basePaths={}", (Object)reqParams.configurationRootPath, reqParams.basePaths);
        InstallationOptionsBuilder builder = new InstallationOptionsBuilder();
        if (StringUtils.isNotBlank((CharSequence)reqParams.configurationRootPath)) {
            builder.withConfigurationRootPath(reqParams.configurationRootPath);
        }
        if (!reqParams.getBasePathsArr().isEmpty()) {
            builder.withRestrictedToPaths(reqParams.getBasePathsArr());
        }
        if (reqParams.applyOnlyIfChanged) {
            builder.skipIfConfigUnchanged();
        }
        if (reqParams.updateExistingExternalGroups) {
            builder.updateExistingExternalGroups();
        }
        try {
            String jobId = this.acInstallationService.applyAsynchronously(builder.build());
            this.messages = new LinkedBlockingQueue<String>();
            this.acInstallationService.attachLogListener(jobId, (level, message) -> {
                try {
                    if (!reqParams.showLogVerbose && level == InstallationLogLevel.TRACE) {
                        return;
                    }
                    this.messages.put((Object)level + ": " + message);
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                }
            }, success -> {
                try {
                    this.messages.put("FINISHED: " + success);
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                }
            });
            resp.setContentType("text/plain");
            String streamLogUrl = req.getRequestURI() + "/" + SUFFIX_STREAM_LOG + "?jobId=" + URLEncoder.encode(jobId, StandardCharsets.UTF_8.toString()) + "&" + PARAM_SHOW_LOG_VERBOSE + "=" + reqParams.showLogVerbose;
            resp.getWriter().print(streamLogUrl);
        }
        catch (IllegalStateException e) {
            LOG.warn("Could not apply configuration: {}", (Object)e.getMessage());
            resp.sendError(400, e.getMessage());
            return;
        }
    }

    private boolean isOneOfPrincipalNamesBound(HttpServletRequest req, String[] principalNames) throws ServletException {
        if (!(req instanceof SlingHttpServletRequest)) {
            LOG.debug("Outside Sling no additional security checks are performed!");
            return true;
        }
        Session session = (Session)((SlingHttpServletRequest)SlingHttpServletRequest.class.cast(req)).getResourceResolver().adaptTo(Session.class);
        return this.isOneOfPrincipalNamesBound((JackrabbitSession)JackrabbitSession.class.cast(session), principalNames);
    }

    private boolean isOneOfPrincipalNamesBound(JackrabbitSession session, String[] principalNames) throws ServletException {
        BoundPrincipals boundPrincipals;
        try {
            boundPrincipals = new BoundPrincipals((JackrabbitSession)JackrabbitSession.class.cast(session));
        }
        catch (RepositoryException e) {
            throw new ServletException("Could not determine bound principals", (Throwable)e);
        }
        return boundPrincipals.containsOneOf(Arrays.asList(principalNames));
    }

    private void renderUi(HttpServletRequest req, HttpServletResponse resp, String basePath, boolean isTouchUi) throws ServletException, IOException {
        RequestParameters reqParams = RequestParameters.fromRequest(req, this.acInstallationService);
        PrintWriter out = resp.getWriter();
        HtmlWriter writer = new HtmlWriter(out, isTouchUi);
        this.printCss(isTouchUi, writer);
        this.printJs(basePath, writer);
        this.printVersion(writer);
        this.printImportSection(writer, reqParams, basePath, isTouchUi, this.isOneOfPrincipalNamesBound(req, this.config.writeAccessPrincipalNames()));
        this.printExportSection(writer, reqParams, basePath, isTouchUi, this.isOneOfPrincipalNamesBound(req, this.config.readAccessPrincipalNames()));
        try {
            this.printInstallationLogsSection(writer, reqParams, basePath, req.getRequestURI(), isTouchUi);
        }
        catch (RepositoryException e) {
            throw new ServletException("Could not read log from repository", (Throwable)e);
        }
        if (!isTouchUi) {
            String jmxUrl = basePath + "/../jmx/" + URLEncoder.encode("biz.netcentric.cq.tools:type=ACTool", StandardCharsets.UTF_8.toString());
            out.println("More operations are available at <a href='" + jmxUrl + "' " + this.forceValidLink(isTouchUi) + ">AC Tool JMX Bean</a><br/>\n<br/>\n");
        }
    }

    void downloadLog(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        RequestParameters reqParams = RequestParameters.fromRequest(req, this.acInstallationService);
        try {
            if (StringUtils.isBlank((CharSequence)reqParams.showLogId)) {
                resp.sendError(400, "No log id provided");
                return;
            }
            Map acToolExecutions = this.acHistoryService.getAcToolExecutions().stream().collect(Collectors.toMap(AcToolExecution::getId, Function.identity(), (u, v) -> {
                throw new IllegalStateException(String.format("Duplicate key %s", u));
            }, LinkedHashMap::new));
            AcToolExecution acToolExecution = (AcToolExecution)acToolExecutions.get(reqParams.showLogId);
            if (acToolExecution == null) {
                resp.sendError(404);
                return;
            }
            String filename = "actool-execution-" + reqParams.showLogId + ".log";
            String logPlain = this.acHistoryService.getLogFromHistory(reqParams.showLogId, false, reqParams.showLogVerbose, -1);
            resp.setContentType("text/plain");
            resp.setHeader(CONTENT_DISPOSITION, "attachment; filename=\"" + filename + "\"");
            resp.getWriter().print(logPlain);
        }
        catch (RepositoryException e) {
            throw new IllegalStateException("Could not read log from repository", e);
        }
    }

    private void streamLog(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        resp.setContentType("text/event-stream;charset=utf-8");
        String jobId = req.getParameter("jobId");
        if (StringUtils.isBlank((CharSequence)jobId)) {
            LOG.warn("No jobId provided as request parameter");
            resp.setStatus(400);
            return;
        }
        if (!this.acInstallationService.isRunning(jobId) && (this.messages == null || this.messages.isEmpty())) {
            LOG.debug("Asynchronous installation with id {} is not running anymore and no messages are available", (Object)jobId);
            resp.setStatus(204);
            return;
        }
        long startTime = System.currentTimeMillis();
        try {
            boolean isActive = true;
            while (isActive) {
                String message = this.messages.poll(30L, TimeUnit.SECONDS);
                if (message == null) {
                    message = "...";
                    isActive = false;
                }
                if (message.startsWith("FINISHED: ")) {
                    isActive = false;
                } else {
                    resp.getWriter().println("data: " + message);
                    resp.getWriter().println();
                    resp.getWriter().flush();
                }
                if (System.currentTimeMillis() - startTime <= this.config.maxLogStreamRequestRuntimeInMs()) continue;
                LOG.debug("Reached maximum runtime of {} ms for log stream request, finishing response", (Object)this.config.maxLogStreamRequestRuntimeInMs());
                isActive = false;
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
    }

    void streamDumpToResponse(HttpServletResponse resp) {
        resp.setContentType("application/x-yaml");
        resp.setHeader(CONTENT_DISPOSITION, "inline; filename=\"actool-dump.yaml\"");
        String dumpAsString = this.dumpService.getCompletePrincipalBasedDumpsAsString();
        try {
            PrintWriter out = resp.getWriter();
            out.println(dumpAsString);
            out.flush();
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    private void streamUsersCsvToResponse(HttpServletResponse resp) {
        resp.setContentType("text/csv");
        resp.setHeader(CONTENT_DISPOSITION, "inline; filename=\"users.csv\"");
        try {
            PrintWriter out = resp.getWriter();
            out.println("Identity Type,Username,Domain,Email,First Name,Last Name,Country Code,ID,Product Configurations,Admin Roles,Product Configurations Administered,User Groups,User Groups Administered,Products Administered,Developer Access");
            try {
                this.userProcessor.forEachNonSystemUser(u -> {
                    try {
                        out.println(String.format(",%s,,%s,%s,%s,%s,,,,,%s", u.getID(), AcToolUiService.escapeAsCsvValue(AcToolUiService.getUserPropertyAsString(u, "profile/email")), AcToolUiService.escapeAsCsvValue(AcToolUiService.getUserPropertyAsString(u, "profile/givenName")), AcToolUiService.escapeAsCsvValue(AcToolUiService.getUserPropertyAsString(u, "profile/familyName")), AcToolUiService.escapeAsCsvValue(this.getCountyCodeFromName(AcToolUiService.getUserPropertyAsString(u, "profile/country"))), AcToolUiService.escapeAsCsvValue(AcToolUiService.getDeclaredMemberOfAsStrings(u))));
                    }
                    catch (RepositoryException e) {
                        throw new UncheckedRepositoryException(e);
                    }
                });
            }
            catch (UncheckedRepositoryException | RepositoryException e) {
                throw new IOException("Could not access users or their properties", e);
            }
            out.println();
            out.flush();
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    private String getCountyCodeFromName(String countryName) {
        String countryCode = this.countryCodePerName.get(countryName);
        return countryCode != null ? countryCode : "";
    }

    private static String escapeAsCsvValue(String text) {
        if (text.contains(",")) {
            return "\"" + text.replace("\"", "\"\"") + "\"";
        }
        return text;
    }

    private static String getDeclaredMemberOfAsStrings(User user) throws RepositoryException {
        LinkedList groupNames = new LinkedList();
        try {
            user.declaredMemberOf().forEachRemaining(g -> {
                try {
                    if (!"everyone".equals(g.getID())) {
                        groupNames.add(g.getID());
                    }
                }
                catch (RepositoryException e) {
                    throw new UncheckedRepositoryException(e);
                }
            });
        }
        catch (UncheckedRepositoryException e) {
            throw e.getCause();
        }
        return String.join((CharSequence)",", groupNames);
    }

    private static String getUserPropertyAsString(User user, String propertyName) throws RepositoryException {
        Value[] values = user.getProperty(propertyName);
        if (values == null) {
            return "";
        }
        try {
            return Arrays.stream(values).map(t -> {
                try {
                    return t.getString();
                }
                catch (RepositoryException e) {
                    throw new UncheckedRepositoryException(new RepositoryException("Could not convert property \"" + propertyName + "\" of user \"" + user + "\" to string", (Throwable)e));
                }
            }).collect(Collectors.joining(", "));
        }
        catch (UncheckedRepositoryException e) {
            throw e.getCause();
        }
    }

    private void printVersion(HtmlWriter writer) {
        writer.openTable("version");
        writer.tableHeader("Version", 1);
        writer.tr();
        writer.td("v" + this.acInstallationService.getVersion());
        writer.closeTd();
        writer.closeTr();
        writer.closeTable();
    }

    private void printInstallationLogsSection(HtmlWriter writer, RequestParameters reqParams, String basePath, String currentPath, boolean isTouchUi) throws RepositoryException {
        Map acToolExecutions = this.acHistoryService.getAcToolExecutions().stream().collect(Collectors.toMap(AcToolExecution::getId, Function.identity(), (u, v) -> {
            throw new IllegalStateException(String.format("Duplicate key %s", u));
        }, LinkedHashMap::new));
        writer.openTable("previousLogs");
        writer.tableHeader("Execution Logs", 5);
        if (acToolExecutions.isEmpty()) {
            writer.tr();
            writer.td("No logs found on this instance (yet)");
            writer.closeTr();
            writer.closeTable();
            return;
        }
        for (AcToolExecution acToolExecution : acToolExecutions.values()) {
            String linkToLog = currentPath + "?" + PARAM_SHOW_LOG_ID + "=" + acToolExecution.getId();
            String downloadLinkToLog = basePath + "/" + SUFFIX_DOWNLOAD_LOG + "?" + PARAM_SHOW_LOG_ID + "=" + acToolExecution.getId();
            writer.tr();
            writer.openTd();
            writer.println(this.getExecutionDateStr(acToolExecution));
            writer.closeTd();
            writer.openTd();
            writer.println(StringUtils.defaultString((String)acToolExecution.getConfigurationRootPath(), (String)""));
            writer.closeTd();
            writer.openTd();
            writer.println("via " + StringUtils.defaultString((String)acToolExecution.getTrigger(), (String)"<unknown>"));
            writer.closeTd();
            writer.openTd();
            writer.println(this.getExecutionStatusStr(acToolExecution));
            writer.closeTd();
            writer.openTd();
            writer.println("[<a href='" + linkToLog + "'>short</a>] [<a href='" + linkToLog + "&showLogVerbose=true'>verbose</a>] [<a href='" + downloadLinkToLog + "&showLogVerbose=true'>download verbose</a>]");
            writer.closeTd();
            writer.closeTr();
        }
        writer.closeTable();
        if (StringUtils.isNotBlank((CharSequence)reqParams.showLogId)) {
            AcToolExecution acToolExecution = (AcToolExecution)acToolExecutions.get(reqParams.showLogId);
            if (acToolExecution == null) {
                writer.println("No log found for id " + reqParams.showLogId);
                return;
            }
            String logLabel = "Execution Log " + reqParams.showLogId + ": " + this.getExecutionLabel(acToolExecution);
            String logHtml = this.acHistoryService.getLogFromHistory(reqParams.showLogId, true, reqParams.showLogVerbose, 180);
            writer.openTable("logTable");
            writer.tableHeader(logLabel, 1, false);
            writer.tr();
            writer.openTd();
            writer.println(logHtml);
            writer.closeTd();
            writer.closeTr();
            writer.closeTable();
        }
    }

    private String getExecutionLabel(AcToolExecution acToolExecution) {
        String statusString = this.getExecutionStatusStr(acToolExecution);
        String configRootPath = acToolExecution.getConfigurationRootPath();
        return this.getExecutionDateStr(acToolExecution) + (configRootPath != null ? " " + configRootPath : "") + " via " + acToolExecution.getTrigger() + ": " + statusString;
    }

    private String getExecutionDateStr(AcToolExecution acToolExecution) {
        return this.getDateFormat().format(acToolExecution.getInstallationDate());
    }

    private String getExecutionStatusStr(AcToolExecution acToolExecution) {
        int authorizableChanges = acToolExecution.getAuthorizableChanges();
        int aclChanges = acToolExecution.getAclChanges();
        String changedStr = authorizableChanges > -1 && aclChanges > -1 ? " (" + authorizableChanges + " authorizables/" + aclChanges + " ACLs changed)" : "";
        String statusString = this.getExecutionStatusHtml(acToolExecution) + (acToolExecution.isSuccess() ? changedStr : "");
        return statusString;
    }

    private SimpleDateFormat getDateFormat() {
        return new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
    }

    private String getExecutionStatusHtml(AcToolExecution acToolExecution) {
        return acToolExecution.isSuccess() ? "SUCCESS" : "<span style='color:red;font-weight: bold;'>FAILED</span>";
    }

    private void printImportSection(HtmlWriter writer, RequestParameters reqParams, String basePath, boolean isTouchUI, boolean hasWritePermission) throws IOException {
        writer.print("<form id='acForm' action='" + basePath + "'>");
        writer.openTable("acFormTable");
        writer.tableHeader("Import", 2);
        writer.tr();
        writer.openTd();
        writer.print("<b>Configuration Root Path</b>");
        if (!isTouchUI) {
            writer.print("<br/> (default from <a href='" + basePath + "/../configMgr/biz.netcentric.cq.tools.actool.impl.AcInstallationServiceImpl' " + this.forceValidLink(isTouchUI) + ">OSGi config</a>)");
        }
        writer.closeTd();
        writer.openTd();
        writer.print("<input type='text' name='configurationRootPath' value='");
        if (reqParams.configurationRootPath != null) {
            writer.print(StringEscapeUtils.escapeHtml4((String)reqParams.configurationRootPath));
        }
        writer.println("' class='input' size='70'>");
        writer.closeTd();
        writer.closeTr();
        writer.tr();
        writer.openTd();
        writer.println("<b>Base Path(s)</b> to restrict where ACLs are installed<br/>  (comma-separated, leave empty to apply the whole configuration)");
        writer.closeTd();
        writer.openTd();
        writer.print("<input type='text' name='basePaths' value='");
        if (reqParams.basePaths != null) {
            writer.print(StringEscapeUtils.escapeHtml4((String)StringUtils.join(reqParams.basePaths, (String)",")));
        }
        writer.println("' class='input' size='70'>");
        writer.closeTd();
        writer.closeTr();
        writer.tr();
        writer.openTd();
        writer.println("<b>Advanced Options</b>");
        writer.closeTd();
        writer.openTd();
        writer.print("<input type='checkbox' name='applyOnlyIfChanged' value='true'" + (reqParams.applyOnlyIfChanged ? " checked='checked'" : "") + " /> Apply only if config changed");
        writer.println("<br/>");
        writer.print("<input type='checkbox' name='updateExistingExternalGroups' value='true'" + (reqParams.updateExistingExternalGroups ? " checked='checked'" : "") + " /> Also update existing external groups");
        writer.println("<br/>");
        writer.print("<input type='checkbox' name='showLogVerbose' value='true'" + (reqParams.showLogVerbose ? " checked='checked'" : "") + " /> Show verbose log");
        writer.closeTd();
        writer.closeTr();
        writer.tr();
        writer.openTd();
        String onClick = "applyAcToolConfig(" + !isTouchUI + ", $('#acForm')); return false;";
        writer.println("<button " + this.getCoralButtonAtts(isTouchUI) + (!hasWritePermission ? " disabled" : "") + " onclick=\"" + onClick + "\"> Apply AC Tool Configuration </button>");
        writer.closeTd();
        writer.openTd();
        writer.println("<div id='applySpinner' style='display:none' class='spinner'><div></div><div></div><div></div></div>");
        writer.closeTd();
        writer.closeTr();
        writer.println("</form>");
        writer.closeTable();
    }

    private void printExportSection(HtmlWriter writer, RequestParameters reqParams, String basePath, boolean isTouchUI, boolean hasReadPermission) throws IOException {
        writer.openTable("acExportTable");
        writer.tableHeader("Export", 2);
        writer.tr();
        writer.openTd();
        writer.print("Export in AC Tool YAML format. This includes groups and permissions (in form of ACEs).");
        writer.closeTd();
        writer.openTd();
        writer.println("<button " + this.getCoralButtonAtts(isTouchUI) + (!hasReadPermission ? " disabled" : "") + " id='downloadDumpButton' onclick=\"window.open('" + basePath + "/" + SUFFIX_DUMP_YAML + "', '_blank');return false;\"> Download YAML </button>");
        writer.closeTd();
        writer.closeTr();
        writer.tr();
        writer.openTd();
        writer.print("Export Users in Admin Console CSV format. This includes non-system users, their profiles and their direct group memberships.");
        writer.closeTd();
        writer.openTd();
        writer.println("<button " + this.getCoralButtonAtts(isTouchUI) + (!hasReadPermission ? " disabled" : "") + " id='downloadCsvButton' onclick=\"window.open('" + basePath + "/" + SUFFIX_USERS_CSV + "', '_blank');return false;\"> Download CSV </button>");
        writer.closeTd();
        writer.closeTr();
        writer.closeTable();
    }

    private void printJs(String resourceUrlPrefix, HtmlWriter writer) {
        String url = resourceUrlPrefix + "/res/actooluiservice.js";
        writer.print("<script type=\"text/javascript\" src=\"");
        writer.print(url);
        writer.println("\"></script>");
    }

    private void printCss(boolean isTouchUI, HtmlWriter writer) {
        StringBuilder css = new StringBuilder();
        css.append(".spinner{display:inline-block;position:relative;width:32px;height:32px}.spinner div{display:inline-block;position:absolute;left:3px;width:7px;background:#777;animation:spinner 1.2s cubic-bezier(0,.5,.5,1) infinite}.spinner div:nth-child(1){left:3px;animation-delay:-.24s}.spinner div:nth-child(2){left:13px;animation-delay:-.12s}.spinner div:nth-child(3){left:23px;animation-delay:0}@keyframes spinner{0%{top:3px;height:26px}100%,50%{top:10px;height:13px}}");
        if (!isTouchUI) {
            css.append("#applyButton {margin:10px 4px 10px 4px}");
        }
        writer.println("<style>" + css + "</style>");
    }

    private String getCoralButtonAtts(boolean isTouchUI) {
        return isTouchUI ? " is='coral-button' variant='primary' iconsize='S'" : "";
    }

    private String forceValidLink(boolean isTouchUI) {
        return isTouchUI ? "x-cq-linkchecker='valid'" : "";
    }

    static class RequestParameters {
        final String configurationRootPath;
        final List<String> basePaths;
        final String showLogId;
        final boolean showLogVerbose;
        final boolean applyOnlyIfChanged;
        private boolean updateExistingExternalGroups;

        static RequestParameters fromRequest(HttpServletRequest req, AcInstallationService acInstallationService) {
            List<String> allConfigRootPaths = ((AcInstallationServiceImpl)acInstallationService).getConfigurationRootPaths();
            String defaultConfigRootPath = allConfigRootPaths.size() > 0 ? allConfigRootPaths.get(allConfigRootPaths.size() - 1) : "";
            String configRootPath = RequestParameters.getParam(req, AcToolUiService.PARAM_CONFIGURATION_ROOT_PATH, defaultConfigRootPath);
            String basePathsParam = req.getParameter(AcToolUiService.PARAM_BASE_PATHS);
            return new RequestParameters(configRootPath, StringUtils.isNotBlank((CharSequence)basePathsParam) ? Arrays.asList(basePathsParam.split(" *, *")) : null, RequestParameters.getParam(req, AcToolUiService.PARAM_SHOW_LOG_ID, null), Boolean.valueOf(req.getParameter(AcToolUiService.PARAM_SHOW_LOG_VERBOSE)), Boolean.valueOf(req.getParameter(AcToolUiService.PARAM_APPLY_ONLY_IF_CHANGED)), Boolean.valueOf(req.getParameter(AcToolUiService.PARAM_UPDATE_EXISTING_EXTERNAL_GROUPS)));
        }

        public RequestParameters(String configurationRootPath, List<String> basePaths, String showLogId, boolean showLogVerbose, boolean applyOnlyIfChanged, boolean updateExistingExternalGroups) {
            this.configurationRootPath = configurationRootPath;
            this.basePaths = basePaths;
            this.showLogId = showLogId;
            this.showLogVerbose = showLogVerbose;
            this.applyOnlyIfChanged = applyOnlyIfChanged;
            this.updateExistingExternalGroups = updateExistingExternalGroups;
        }

        public Collection<String> getBasePathsArr() {
            if (this.basePaths == null) {
                return Collections.emptyList();
            }
            return this.basePaths;
        }

        static String getParam(HttpServletRequest req, String name, String defaultValue) {
            String result = req.getParameter(name);
            if (result == null) {
                result = defaultValue;
            }
            return StringUtils.trim((String)result);
        }
    }

    @ObjectClassDefinition(name="AC Tool UI Service", description="Service that allows to apply AC Tool configuration and gather status of users/groups and permissions from a Web UI (either Touch UI or Web Console Plugin).")
    protected static @interface Configuration {
        @AttributeDefinition(name="Read access", description="Principal names allowed to export all users/groups and permissions in the system. Only leveraged for Touch UI but not for Web Console Plugin.")
        public String[] readAccessPrincipalNames() default {"administrators", "admin"};

        @AttributeDefinition(name="Write access", description="Principal names allowed to modify users/groups and permissions in the system via ACTool configuration files. Only leveraged for Touch UI but not for Web Console Plugin.")
        public String[] writeAccessPrincipalNames() default {"administrators", "admin"};

        @AttributeDefinition(name="Log stream request maximum runtime", description="Maximum time in milliseconds until the log stream request should be answered. Must be less than the timeout of the CDN (60 seconds for Fastly used by AEMaaCS).")
        public long maxLogStreamRequestRuntimeInMs() default 30000L;
    }
}

