/*
 * Decompiled with CFR 0.152.
 */
package black.door.jose.adopted;

import java.security.SignatureException;

public final class DerTools$ {
    public static DerTools$ MODULE$;

    static {
        new DerTools$();
    }

    public byte[] transcodeSignatureToConcat(byte[] derSignature, int outputLength) throws SignatureException {
        int sLength;
        int j;
        int rLength;
        int i;
        if (derSignature.length < 8 || derSignature[0] != 48) {
            throw new SignatureException("Invalid ECDSA signature format");
        }
        int offset = 0;
        if (derSignature[1] > 0) {
            offset = 2;
        } else if (derSignature[1] == (byte)129) {
            offset = 3;
        } else {
            throw new SignatureException("Invalid ECDSA signature format");
        }
        for (i = rLength = derSignature[offset + 1]; i > 0 && derSignature[offset + 2 + rLength - i] == 0; --i) {
        }
        for (j = sLength = derSignature[offset + 2 + rLength + 1]; j > 0 && derSignature[offset + 2 + rLength + 2 + sLength - j] == 0; --j) {
        }
        int rawLen = Math.max(i, j);
        rawLen = Math.max(rawLen, outputLength / 2);
        if ((derSignature[offset - 1] & 0xFF) != derSignature.length - offset || (derSignature[offset - 1] & 0xFF) != 2 + rLength + 2 + sLength || derSignature[offset] != 2 || derSignature[offset + 2 + rLength] != 2) {
            throw new SignatureException("Invalid ECDSA signature format");
        }
        byte[] concatSignature = new byte[2 * rawLen];
        System.arraycopy(derSignature, offset + 2 + rLength - i, concatSignature, rawLen - i, i);
        System.arraycopy(derSignature, offset + 2 + rLength + 2 + sLength - j, concatSignature, 2 * rawLen - j, j);
        return concatSignature;
    }

    public byte[] transcodeSignatureToDER(byte[] jwsSignature) throws SignatureException {
        int len;
        int k;
        int rawLen;
        int i;
        for (i = rawLen = jwsSignature.length / 2; i > 0 && jwsSignature[rawLen - i] == 0; --i) {
        }
        int j = i;
        if (jwsSignature[rawLen - i] < 0) {
            ++j;
        }
        for (k = rawLen; k > 0 && jwsSignature[2 * rawLen - k] == 0; --k) {
        }
        int l = k;
        if (jwsSignature[2 * rawLen - k] < 0) {
            ++l;
        }
        if ((len = 2 + j + 2 + l) > 255) {
            throw new SignatureException("Invalid ECDSA signature format");
        }
        int offset = 0;
        byte[] derSignature = null;
        if (len < 128) {
            derSignature = new byte[4 + j + 2 + l];
            offset = 1;
        } else {
            derSignature = new byte[5 + j + 2 + l];
            derSignature[1] = (byte)129;
            offset = 2;
        }
        derSignature[0] = 48;
        derSignature[++offset - 1] = (byte)len;
        derSignature[++offset - 1] = 2;
        derSignature[++offset - 1] = (byte)j;
        System.arraycopy(jwsSignature, rawLen - i, derSignature, offset + j - i, i);
        offset += j;
        derSignature[++offset - 1] = 2;
        derSignature[++offset - 1] = (byte)l;
        System.arraycopy(jwsSignature, 2 * rawLen - k, derSignature, offset + l - k, k);
        return derSignature;
    }

    private DerTools$() {
        MODULE$ = this;
    }
}

