/*
 * Decompiled with CFR 0.152.
 */
package br.com.anteros.security.store;

import br.com.anteros.security.store.domain.IAction;
import br.com.anteros.security.store.domain.IResource;
import br.com.anteros.security.store.domain.ISystem;
import br.com.anteros.security.store.domain.IUser;
import java.util.Collection;
import java.util.List;
import org.springframework.security.oauth2.common.OAuth2AccessToken;
import org.springframework.security.oauth2.common.OAuth2RefreshToken;
import org.springframework.security.oauth2.provider.ClientDetails;
import org.springframework.security.oauth2.provider.OAuth2Authentication;
import org.springframework.security.oauth2.provider.approval.Approval;
import org.springframework.security.oauth2.provider.token.AuthenticationKeyGenerator;

public interface SecurityDataStore {
    public IResource getResourceByName(String var1, String var2);

    public ISystem getSystemByName(String var1);

    public ISystem addSystem(String var1, String var2);

    public IResource addResource(ISystem var1, String var2, String var3) throws Exception;

    public IAction addAction(ISystem var1, IResource var2, String var3, String var4, String var5, String var6) throws Exception;

    public IAction saveAction(IAction var1) throws Exception;

    public IResource refreshResource(IResource var1) throws Exception;

    public void removeActionByAllUsers(IAction var1) throws Exception;

    public IUser getUserByUserName(String var1);

    public void addApprovals(Collection<Approval> var1);

    public void revokeApprovals(Collection<Approval> var1);

    public Collection<Approval> getApprovals(String var1, String var2);

    public void setHandleRevocationsAsExpiry(boolean var1);

    public void storeAccessToken(OAuth2AccessToken var1, OAuth2Authentication var2, AuthenticationKeyGenerator var3);

    public OAuth2Authentication readAuthentication(String var1);

    public OAuth2AccessToken readAccessToken(String var1);

    public void removeAccessToken(OAuth2AccessToken var1);

    public void storeRefreshToken(OAuth2RefreshToken var1, OAuth2Authentication var2);

    public OAuth2RefreshToken readRefreshToken(String var1);

    public OAuth2Authentication readAuthenticationForRefreshToken(OAuth2RefreshToken var1);

    public void removeRefreshToken(OAuth2RefreshToken var1);

    public void removeAccessTokenUsingRefreshToken(OAuth2RefreshToken var1);

    public OAuth2AccessToken getAccessToken(OAuth2Authentication var1, AuthenticationKeyGenerator var2);

    public Collection<OAuth2AccessToken> findTokensByClientIdAndUserName(String var1, String var2);

    public Collection<OAuth2AccessToken> findTokensByClientId(String var1);

    public void addClientDetails(ClientDetails var1);

    public void updateClientDetails(ClientDetails var1);

    public void updateClientSecret(String var1, String var2);

    public void removeClientDetails(String var1);

    public List<ClientDetails> listClientDetails();

    public ClientDetails loadClientByClientId(String var1);

    public void initializeCurrentSession() throws Exception;

    public void clearCurrentSession() throws Exception;
}

