/*
 * Decompiled with CFR 0.152.
 */
package br.com.objectos.auto.functional;

import br.com.objectos.auto.functional.AbstractHasIsPredicate;
import br.com.objectos.auto.functional.IsPredicate;
import br.com.objectos.code.MethodInfoCodeWriter;
import com.google.common.collect.ImmutableList;
import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.CodeBlock;
import com.squareup.javapoet.FieldSpec;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.ParameterSpec;
import com.squareup.javapoet.TypeName;
import com.squareup.javapoet.TypeSpec;
import java.util.List;
import javax.lang.model.element.Modifier;

abstract class IsPredicateStatic
extends AbstractHasIsPredicate {
    IsPredicateStatic(IsPredicate predicate) {
        super(predicate);
    }

    public static IsPredicateStatic wrap(IsPredicate predicate) {
        List<ParameterSpec> parameterSpecList = predicate.parameterSpecList;
        return parameterSpecList.isEmpty() ? new ParameterLess(predicate) : new WithParameter(predicate);
    }

    public abstract List<FieldSpec> fieldList();

    public abstract List<MethodSpec> methodList();

    void addFieldListTo(TypeSpec.Builder type) {
        List<FieldSpec> fieldList = this.fieldList();
        for (FieldSpec field : fieldList) {
            type.addField(field);
        }
    }

    void addMethodListTo(TypeSpec.Builder type) {
        List<MethodSpec> methodList = this.methodList();
        for (MethodSpec method : methodList) {
            type.addMethod(method);
        }
    }

    private static class WithParameter
    extends IsPredicateStatic {
        public WithParameter(IsPredicate predicate) {
            super(predicate);
        }

        @Override
        public List<FieldSpec> fieldList() {
            return ImmutableList.of();
        }

        @Override
        public List<MethodSpec> methodList() {
            MethodSpec yes = this.method("get", this.className());
            MethodSpec not = this.method("not", this.classNameNot());
            return ImmutableList.of((Object)yes, (Object)not);
        }

        private MethodSpec method(String name, ClassName className) {
            MethodSpec.Builder b = MethodSpec.methodBuilder((String)name).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.STATIC}).returns(this.predicateTypeName());
            for (ParameterSpec parameterSpec : this.parameterSpecList()) {
                b.addParameter(parameterSpec);
            }
            CodeBlock returnStatement = ((MethodInfoCodeWriter)((MethodInfoCodeWriter)((MethodInfoCodeWriter)this.methodInfo().statementWriter().add("return new $T(").add("$L").forEachParameter(", ")).add(")").set((Object)className)).setParameterName()).write();
            return b.addCode(returnStatement).build();
        }
    }

    private static class ParameterLess
    extends IsPredicateStatic {
        public ParameterLess(IsPredicate predicate) {
            super(predicate);
        }

        @Override
        public List<FieldSpec> fieldList() {
            FieldSpec yes = this.field(this.className(), "INSTANCE");
            FieldSpec not = this.field(this.classNameNot(), "NOT");
            return ImmutableList.of((Object)yes, (Object)not);
        }

        @Override
        public List<MethodSpec> methodList() {
            MethodSpec yes = this.method("get", "INSTANCE");
            MethodSpec not = this.method("not", "NOT");
            return ImmutableList.of((Object)yes, (Object)not);
        }

        private FieldSpec field(ClassName className, String name) {
            return FieldSpec.builder((TypeName)this.predicateTypeName(), (String)name, (Modifier[])new Modifier[0]).addModifiers(new Modifier[]{Modifier.PRIVATE, Modifier.STATIC, Modifier.FINAL}).initializer("new $T()", new Object[]{className}).build();
        }

        private MethodSpec method(String name, String fieldName) {
            return MethodSpec.methodBuilder((String)name).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.STATIC}).returns(this.predicateTypeName()).addStatement("return $L", new Object[]{fieldName}).build();
        }
    }
}

