/*
 * Decompiled with CFR 0.152.
 */
package br.com.objectos.auto.functional;

import br.com.objectos.auto.functional.ToFunctionConstructor;
import br.com.objectos.auto.functional.ToFunctionField;
import br.com.objectos.auto.functional.ToFunctionMethod;
import br.com.objectos.auto.functional.ToFunctionStatic;
import br.com.objectos.auto.functional.ToFunctionType;
import br.com.objectos.code.CodeCanvasArtifact;
import br.com.objectos.code.CodeCanvasWriter;
import br.com.objectos.code.MethodInfo;
import br.com.objectos.code.ParameterInfo;
import br.com.objectos.code.SimpleTypeInfo;
import br.com.objectos.code.TypeInfo;
import br.com.objectos.core.util.Function;
import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.JavaFile;
import com.squareup.javapoet.ParameterSpec;
import com.squareup.javapoet.ParameterizedTypeName;
import com.squareup.javapoet.TypeName;
import com.squareup.javapoet.TypeSpec;
import java.util.List;
import java.util.stream.Collectors;

class ToFunction {
    final TypeInfo typeInfo;
    final MethodInfo methodInfo;
    final List<ParameterSpec> parameterSpecList;
    final ClassName className;
    final TypeName functionTypeName;

    private ToFunction(TypeInfo typeInfo, MethodInfo methodInfo, List<ParameterSpec> parameterSpecList, ClassName className, TypeName functionTypeName) {
        this.typeInfo = typeInfo;
        this.methodInfo = methodInfo;
        this.parameterSpecList = parameterSpecList;
        this.className = className;
        this.functionTypeName = functionTypeName;
    }

    public static ToFunction wrap(TypeInfo typeInfo, MethodInfo methodInfo) {
        List<ParameterSpec> parameterSpecList = methodInfo.parameterInfoStream().map(ParameterInfo::parameterSpec).collect(Collectors.toList());
        String suffix = methodInfo.className();
        ClassName className = typeInfo.classNameSuffix(suffix);
        ClassName function = ClassName.get(Function.class);
        TypeName from = typeInfo.typeNameRaw();
        SimpleTypeInfo returnTypeInfo = methodInfo.returnTypeInfo().autobox();
        TypeName to = returnTypeInfo.typeName();
        ParameterizedTypeName functionTypeName = ParameterizedTypeName.get((ClassName)function, (TypeName[])new TypeName[]{from, to});
        return new ToFunction(typeInfo, methodInfo, parameterSpecList, className, (TypeName)functionTypeName);
    }

    ToFunctionConstructor constructor() {
        return new ToFunctionConstructor(this);
    }

    ToFunctionField field() {
        return new ToFunctionField(this);
    }

    ToFunctionMethod method() {
        return new ToFunctionMethod(this);
    }

    ToFunctionStatic static_() {
        return ToFunctionStatic.wrap(this);
    }

    ToFunctionType type() {
        return new ToFunctionType(this);
    }

    CodeCanvasArtifact toCodeCanvasArtifact() {
        ToFunctionType type = this.type();
        TypeSpec typeSpec = type.get();
        JavaFile javaFile = this.typeInfo.toJavaFile(typeSpec);
        return CodeCanvasWriter.forJavaFile((JavaFile)javaFile).namedAfter(this.typeInfo, this.methodInfo.className()).toCodeCanvasArtifact();
    }
}

