/*
 * Decompiled with CFR 0.152.
 */
package br.com.objectos.auto.functional;

import br.com.objectos.auto.functional.ToFunction;
import br.com.objectos.code.AccessInfo;
import br.com.objectos.code.CodeCanvasArtifact;
import br.com.objectos.code.MethodInfo;
import br.com.objectos.code.SimpleTypePrimitives;
import br.com.objectos.code.TypeInfo;
import java.util.stream.Stream;

class ToFunctionCanvas {
    private static ToFunctionCanvas INSTANCE = new ToFunctionCanvas();

    private ToFunctionCanvas() {
    }

    public static Stream<CodeCanvasArtifact> toArtifactStream(TypeInfo typeInfo, MethodInfo methodInfo) {
        return INSTANCE.code(typeInfo, methodInfo);
    }

    private Stream<CodeCanvasArtifact> code(TypeInfo typeInfo, MethodInfo methodInfo) {
        if (methodInfo.hasAccessInfo(AccessInfo.PRIVATE)) {
            return Stream.empty();
        }
        if (methodInfo.hasReturnTypeInfo(SimpleTypePrimitives.BOOLEAN)) {
            return Stream.empty();
        }
        if (methodInfo.hasReturnTypeInfo(SimpleTypePrimitives.VOID)) {
            return Stream.empty();
        }
        CodeCanvasArtifact artifact = this.codeMethod(typeInfo, methodInfo);
        return Stream.of(artifact);
    }

    private CodeCanvasArtifact codeMethod(TypeInfo typeInfo, MethodInfo methodInfo) {
        ToFunction function = ToFunction.wrap(typeInfo, methodInfo);
        return function.toCodeCanvasArtifact();
    }
}

