/*
 * Decompiled with CFR 0.152.
 */
package br.com.senior.crm.http.camel.services.impl;

import br.com.senior.crm.http.camel.entities.account.AccountDefinition;
import br.com.senior.crm.http.camel.entities.account.AccountDefinitionCollection;
import java.util.UUID;
import lombok.NonNull;
import org.apache.camel.Exchange;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.model.ChoiceDefinition;
import org.apache.camel.model.RouteDefinition;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FilterFields {
    private static final Logger log = LoggerFactory.getLogger(FilterFields.class);
    @NonNull
    private RouteBuilder builder;
    private final UUID id = UUID.randomUUID();
    private final String directImpl = "direct:crm-filter-fields-" + this.id.toString();
    private final String directResponse = "direct:crm-filter-fields-response-" + this.id.toString();
    private static String DIRECT_END_REST = "direct:crm-filter-fields-end-rest";

    public void prepare() {
        ((ChoiceDefinition)((ChoiceDefinition)this.builder.from(this.directImpl).choice().when(this::filter).to(this.directResponse)).otherwise().to(DIRECT_END_REST)).endChoice();
        ((RouteDefinition)this.builder.from(DIRECT_END_REST).log("N\u00e3o passou no filtro")).endRest();
    }

    private boolean filter(Exchange exchange) {
        boolean isValid = false;
        if (exchange.getMessage().getBody() instanceof AccountDefinitionCollection) {
            isValid = this.filterAccountDefinition(exchange);
        }
        return isValid;
    }

    private boolean filterAccountDefinition(Exchange exchange) {
        AccountDefinitionCollection collection = (AccountDefinitionCollection)exchange.getMessage().getBody(AccountDefinitionCollection.class);
        Long typeAccount = (Long)exchange.getProperty("Type-Account", Long.class);
        boolean isValid = false;
        for (AccountDefinition accountDefinition : collection.definitions) {
            if (isValid) continue;
            isValid = accountDefinition.getAccountType().getId().equals(typeAccount);
            log.info("Comparative between account type: Definition " + accountDefinition.getId() + " with type account " + accountDefinition.getAccountType().getId() + " and parameter type account " + typeAccount);
        }
        return isValid;
    }

    public FilterFields(@NonNull RouteBuilder builder) {
        if (builder == null) {
            throw new NullPointerException("builder is marked non-null but is null");
        }
        this.builder = builder;
    }

    public String getDirectImpl() {
        return this.directImpl;
    }

    public String getDirectResponse() {
        return this.directResponse;
    }
}

