/*
 * Decompiled with CFR 0.152.
 */
package br.com.senior.crm.http.camel.services.impl;

import java.util.Base64;
import java.util.List;
import org.apache.camel.Exchange;
import org.apache.camel.Message;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class PrepareParameters {
    private static final String HEADER_PARAMS = "X-Param-";

    private PrepareParameters() {
    }

    public static void prepare(Exchange exchange, List<String> params) {
        Message message = exchange.getMessage();
        params.forEach(param -> {
            String paramComplete = HEADER_PARAMS + param;
            if (message.getHeader(paramComplete) != null) {
                exchange.setProperty(param, PrepareParameters.decode(message.getHeader(paramComplete).toString()));
            }
        });
    }

    private static Object decode(String valueEncoded) {
        byte[] valueDecoded = Base64.getDecoder().decode(valueEncoded);
        String value = new String(valueDecoded);
        if (PrepareParameters.isJsonObject(value)) {
            return new JSONObject(value);
        }
        if (PrepareParameters.isJsonArray(value)) {
            return new JSONArray(value);
        }
        return value;
    }

    private static boolean isJsonObject(String json) {
        try {
            new JSONObject(json);
        }
        catch (JSONException ex) {
            return false;
        }
        return true;
    }

    private static boolean isJsonArray(String json) {
        try {
            new JSONArray(json);
        }
        catch (JSONException ex1) {
            return false;
        }
        return true;
    }
}

