/*
 * Decompiled with CFR 0.152.
 */
package br.com.senior.crm.http.camel.services.impl;

import br.com.senior.crm.http.camel.services.exception.AuthenticationException;
import br.com.senior.seniorx.http.camel.authentication.AuthenticationAPI;
import br.com.senior.seniorx.http.camel.authentication.LoginWithKeyInput;
import java.util.Base64;
import java.util.UUID;
import lombok.NonNull;
import org.apache.camel.Exchange;
import org.apache.camel.Message;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.model.RouteDefinition;

public class Authentication {
    @NonNull
    private RouteBuilder builder;
    private final UUID id = UUID.randomUUID();
    private final String directImpl = "direct:crm-authentication-" + this.id.toString();
    private final String directResponse = "direct:crm-authentication-response-" + this.id.toString();

    public void prepare() {
        AuthenticationAPI authenticationAPI = new AuthenticationAPI(this.builder);
        authenticationAPI.prepare();
        ((RouteDefinition)((RouteDefinition)this.builder.from(this.directImpl).routeId("Authentication SeniorX (CRM)").process(this::searchAuthorization)).process(this::prepareAuthorization)).to(authenticationAPI.route());
        this.builder.from(authenticationAPI.responseRoute()).to(this.directResponse);
    }

    public void searchAuthorization(Exchange exchange) {
        Message message = exchange.getMessage();
        String authorization = (String)message.getHeader("Authorization", String.class);
        if (authorization == null) {
            throw new AuthenticationException("Basic Auth not found!");
        }
    }

    private void prepareAuthorization(Exchange exchange) {
        Message message = exchange.getMessage();
        String authorizationEncode = ((String)message.getHeader("Authorization", String.class)).replace("Basic", "").trim();
        String authorizationDecode = Authentication.decode(authorizationEncode);
        String[] authorization = authorizationDecode.split(":");
        LoginWithKeyInput loginWithKeyInput = new LoginWithKeyInput();
        loginWithKeyInput.accessKey = authorization[0];
        loginWithKeyInput.secret = authorization[1];
        loginWithKeyInput.tenantName = (String)message.getHeader("X-Integration-Tenant", String.class);
        message.removeHeader("Authorization");
        message.setBody((Object)loginWithKeyInput);
    }

    private static String decode(String valueEncoded) {
        byte[] valueDecoded = Base64.getDecoder().decode(valueEncoded);
        return new String(valueDecoded);
    }

    public static void addAuthorization(Exchange exchange) {
        AuthenticationAPI.addAuthorization((Exchange)exchange);
    }

    public Authentication(@NonNull RouteBuilder builder) {
        if (builder == null) {
            throw new NullPointerException("builder is marked non-null but is null");
        }
        this.builder = builder;
    }

    public String getDirectImpl() {
        return this.directImpl;
    }

    public String getDirectResponse() {
        return this.directResponse;
    }
}

