/*
 * Decompiled with CFR 0.152.
 */
package br.com.senior.crm.http.camel.services.impl;

import org.apache.camel.Exchange;

public class ComparativeStatusCode {
    public static boolean isOk(Exchange exchange) {
        return ComparativeStatusCode.equalStatusCode(exchange, 200) || ComparativeStatusCode.equalStatusCode(exchange, 201);
    }

    public static boolean notOk(Exchange exchange) {
        return ComparativeStatusCode.notEqualStatusCode(exchange, 200) && ComparativeStatusCode.notEqualStatusCode(exchange, 201);
    }

    public static boolean isInternationalServerError(Exchange exchange) {
        return ComparativeStatusCode.equalStatusCode(exchange, 500);
    }

    public static boolean isNotFound(Exchange exchange) {
        return ComparativeStatusCode.equalStatusCode(exchange, 404);
    }

    public static boolean isUnauthorized(Exchange exchange) {
        return ComparativeStatusCode.equalStatusCode(exchange, 401);
    }

    private static boolean equalStatusCode(Exchange exchange, Integer statusCode) {
        return ((Integer)exchange.getMessage().getHeader("CamelHttpResponseCode", Integer.class)).equals(statusCode);
    }

    private static boolean notEqualStatusCode(Exchange exchange, Integer statusCode) {
        return !((Integer)exchange.getMessage().getHeader("CamelHttpResponseCode", Integer.class)).equals(statusCode);
    }
}

