/*
 * Decompiled with CFR 0.152.
 */
package br.com.senior.crm.http.camel.services.impl;

import br.com.senior.crm.http.camel.dtos.AccountTypeDTO;
import br.com.senior.crm.http.camel.entities.account.AccountDefinition;
import br.com.senior.crm.http.camel.entities.account.AccountDefinitionCollection;
import br.com.senior.crm.http.camel.services.impl.CrmHTTPRouteBuilder;
import br.com.senior.crm.http.camel.utils.enums.MethodEnum;
import br.com.senior.crm.http.camel.utils.enums.PrimitiveComplementEnum;
import br.com.senior.crm.http.camel.utils.enums.PrimitiveEnum;
import br.com.senior.crm.http.camel.utils.enums.ServiceEnum;
import br.com.senior.seniorx.http.camel.PrimitiveType;
import br.com.senior.seniorx.http.camel.authentication.AuthenticationAPI;
import java.util.UUID;
import lombok.NonNull;
import org.apache.camel.Exchange;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.model.RouteDefinition;
import org.apache.camel.spi.DataFormat;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FilterFields {
    private static final Logger log = LoggerFactory.getLogger(FilterFields.class);
    @NonNull
    private RouteBuilder builder;
    private final String id = UUID.randomUUID().toString();
    private final String directImpl = "direct:crm-filter-fields-".concat(this.id);
    private final String directResponse = "direct:crm-filter-fields-response-".concat(this.id);
    private static final String DIRECT_GET_ACCOUNT_TYPE = "direct:get-account-type";
    private static final String MESSAGE_ACCOUNT_CANNOT_BE_INTEGRATED_PT_BR = "O tipo de conta %s n\u00e3o \u00e9 aceito para integra\u00e7\u00e3o. Altere para o tipo de conta %s.";
    private static final String MESSAGE_ACCOUNT_CANNOT_BE_INTEGRATED_ES_CO = "El tipo de cuenta %s no es acepto para integraci\u00f3n. Cambie para el tipo de cuenta %s.";
    public static final String PROPERTY_IS_VALID = "property:filter-fields-is-valid";
    public static final String PROPERTY_MESSAGE = "property:filter-fields-message";

    public void prepare() {
        CrmHTTPRouteBuilder getAccountType = new CrmHTTPRouteBuilder(this.builder, ServiceEnum.BASE_RECORDS, PrimitiveType.ENTITY, PrimitiveEnum.ACCOUNT_TYPE, MethodEnum.GET);
        this.builder.from(this.directImpl).to(DIRECT_GET_ACCOUNT_TYPE);
        ((RouteDefinition)((RouteDefinition)((RouteDefinition)((RouteDefinition)((RouteDefinition)((RouteDefinition)((RouteDefinition)((RouteDefinition)this.builder.from(DIRECT_GET_ACCOUNT_TYPE).routeId("Gets the account type.").process(exchange -> exchange.setProperty(AccountDefinitionCollection.class.toString(), exchange.getMessage().getBody()))).process(AuthenticationAPI::addAuthorization)).process(exchange -> exchange.getMessage().setBody(null))).process(exchange -> getAccountType.setPrimitiveComplement((String)exchange.getProperty("Type-Account", (Object)"0", String.class), PrimitiveComplementEnum.PARAMETER))).process(arg_0 -> ((CrmHTTPRouteBuilder)getAccountType).route(arg_0))).unmarshal((DataFormat)AccountTypeDTO.JACKSON_DATA_FORMAT)).process(exchange -> exchange.setProperty(AccountTypeDTO.class.toString(), exchange.getMessage().getBody(AccountTypeDTO.class)))).process(exchange -> exchange.setProperty(PROPERTY_IS_VALID, (Object)this.filter(exchange)))).to(this.directResponse);
    }

    private Boolean filter(Exchange exchange) {
        return this.filterAccountDefinition(exchange);
    }

    private Boolean filterAccountDefinition(Exchange exchange) {
        AccountDefinitionCollection collection = (AccountDefinitionCollection)exchange.getProperty(AccountDefinitionCollection.class.toString(), null, AccountDefinitionCollection.class);
        Long typeAccount = (Long)exchange.getProperty("Type-Account", (Object)"0", Long.class);
        Boolean isValid = false;
        for (AccountDefinition accountDefinition : collection.definitions) {
            if (!isValid.equals(Boolean.FALSE)) continue;
            isValid = accountDefinition.getAccountType().getId().equals(typeAccount);
            String integrationName = (String)exchange.getMessage().getHeader("X-Integration-Id");
            AccountTypeDTO accountTypeDTO = (AccountTypeDTO)exchange.getProperty(AccountTypeDTO.class.toString(), null, AccountTypeDTO.class);
            if (integrationName.contains("novasoft")) {
                exchange.setProperty(PROPERTY_MESSAGE, (Object)String.format(MESSAGE_ACCOUNT_CANNOT_BE_INTEGRATED_ES_CO, accountDefinition.getAccountType().getName(), accountTypeDTO.getName()));
            } else {
                exchange.setProperty(PROPERTY_MESSAGE, (Object)String.format(MESSAGE_ACCOUNT_CANNOT_BE_INTEGRATED_PT_BR, accountDefinition.getAccountType().getName(), accountTypeDTO.getName()));
            }
            log.info("Comparative between account type: Definition {} with type account {} and parameter type account {}", new Object[]{accountDefinition.getId(), accountDefinition.getAccountType().getId(), typeAccount});
        }
        return isValid;
    }

    public FilterFields(@NonNull RouteBuilder builder) {
        if (builder == null) {
            throw new NullPointerException("builder is marked non-null but is null");
        }
        this.builder = builder;
    }

    public String getDirectImpl() {
        return this.directImpl;
    }

    public String getDirectResponse() {
        return this.directResponse;
    }
}

