/*
 * Decompiled with CFR 0.152.
 */
package br.com.senior.crm.http.camel.services.impl;

import br.com.senior.crm.http.camel.entities.integrationManagement.LogIntegration;
import br.com.senior.crm.http.camel.services.impl.CrmHTTPRouteBuilder;
import br.com.senior.crm.http.camel.utils.enums.MethodEnum;
import br.com.senior.crm.http.camel.utils.enums.PrimitiveEnum;
import br.com.senior.crm.http.camel.utils.enums.ServiceEnum;
import br.com.senior.seniorx.http.camel.PrimitiveType;
import java.util.UUID;
import lombok.NonNull;
import org.apache.camel.Exchange;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.model.ChoiceDefinition;
import org.apache.camel.spi.DataFormat;

public class SaveLog {
    public static String PAYLOAD_SENT = "payloadSent";
    public static String PAYLOAD_RECEIVER = "payloadReceiver";
    @NonNull
    private RouteBuilder builder;
    private final UUID id = UUID.randomUUID();
    private final String directImpl = "direct:crm-save-log-" + this.id.toString();
    private final String directResponse = "direct:crm-save-log-response-" + this.id.toString();

    void prepare() {
        CrmHTTPRouteBuilder logIntegration = new CrmHTTPRouteBuilder(this.builder, ServiceEnum.CRM_INTEGRATION_MANAGEMENT, PrimitiveType.ENTITY, PrimitiveEnum.LOG_INTEGRATION, MethodEnum.POST);
        ((ChoiceDefinition)((ChoiceDefinition)((ChoiceDefinition)((ChoiceDefinition)((ChoiceDefinition)this.builder.from(this.directImpl).choice().process(this::prepareLogIntegration)).marshal((DataFormat)LogIntegration.JACKSON_DATA_FORMAT)).process(arg_0 -> ((CrmHTTPRouteBuilder)logIntegration).route(arg_0))).log("Return POST logIntegration: ${body}")).process(exchange -> exchange.getMessage().setBody(exchange.getProperty(PAYLOAD_RECEIVER)))).to(this.directResponse);
    }

    private void prepareLogIntegration(Exchange exchange) {
        String integration = (String)exchange.getMessage().getHeader("X-Integration-Id", String.class);
        String payloadSent = (String)exchange.getProperty(PAYLOAD_SENT, String.class);
        String payloadReceived = (String)exchange.getProperty(PAYLOAD_RECEIVER, String.class);
        Long statusCode = (Long)exchange.getMessage().getHeader("CamelHttpResponseCode", Long.class);
        LogIntegration log = new LogIntegration();
        log.setIntegration(integration);
        log.setPayloadSent(payloadSent);
        log.setPayloadReceived(payloadReceived);
        log.setStatusCode(statusCode);
        exchange.getMessage().setBody((Object)log);
    }

    public SaveLog(@NonNull RouteBuilder builder) {
        if (builder == null) {
            throw new NullPointerException("builder is marked non-null but is null");
        }
        this.builder = builder;
    }

    public String getDirectImpl() {
        return this.directImpl;
    }

    public String getDirectResponse() {
        return this.directResponse;
    }
}

