/*
 * Decompiled with CFR 0.152.
 */
package br.com.senior.seniorx.http.camel;

import java.util.Map;
import org.apache.camel.Exchange;
import org.apache.camel.Message;
import org.apache.camel.Processor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ForwardProcessor
implements Processor {
    private static final Logger LOGGER = LoggerFactory.getLogger(ForwardProcessor.class);
    private final Exchange source;

    public ForwardProcessor(Exchange source) {
        this.source = source;
    }

    public void process(Exchange exchange) throws Exception {
        this.prepare(this.source, exchange);
    }

    private void prepare(Exchange src, Exchange dest) {
        Message sourceMessage = src.getMessage();
        Message message = dest.getMessage();
        message.setBody(sourceMessage.getBody());
        for (Map.Entry entry : sourceMessage.getHeaders().entrySet()) {
            message.setHeader((String)entry.getKey(), entry.getValue());
        }
        LOGGER.info("Body {}", message.getBody());
        LOGGER.info("Headers {}", (Object)message.getHeaders());
    }

    public void reverse(Exchange exchange) {
        this.prepare(exchange, this.source);
    }
}

