/*
 * Decompiled with CFR 0.152.
 */
package br.com.senior.seniorx.http.camel;

import br.com.senior.seniorx.http.camel.ForwardProcessor;
import br.com.senior.seniorx.http.camel.PrimitiveType;
import br.com.senior.seniorx.http.camel.SeniorXHTTPException;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSession;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import org.apache.camel.Exchange;
import org.apache.camel.Message;
import org.apache.camel.Processor;
import org.apache.camel.ProducerTemplate;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.http.HttpClientConfigurer;
import org.apache.camel.component.http.HttpComponent;
import org.apache.camel.spi.PropertiesComponent;
import org.apache.http.config.Lookup;
import org.apache.http.config.Registry;
import org.apache.http.config.RegistryBuilder;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.impl.conn.BasicHttpClientConnectionManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SeniorXHTTPRouteBuilder {
    private static final Logger LOGGER = LoggerFactory.getLogger(SeniorXHTTPRouteBuilder.class);
    private static final String HTTPS = "https";
    protected final RouteBuilder builder;
    protected String url = "{{seniorx.url}}";
    protected boolean anonymous = false;
    protected String allowedInsecureHost = "{{seniorx.allowedinsecurehost}}";
    protected String method;
    protected String domain;
    protected String service;
    protected PrimitiveType primitiveType;
    protected String primitive;

    public SeniorXHTTPRouteBuilder(RouteBuilder builder) {
        this.builder = builder;
    }

    public SeniorXHTTPRouteBuilder method(String method) {
        this.method = method;
        return this;
    }

    public SeniorXHTTPRouteBuilder url(String url) {
        this.url = url;
        return this;
    }

    public SeniorXHTTPRouteBuilder anonymous(boolean anonymous) {
        this.anonymous = anonymous;
        return this;
    }

    public SeniorXHTTPRouteBuilder allowedInsecureHost(String allowedInsecureHost) {
        this.allowedInsecureHost = allowedInsecureHost;
        return this;
    }

    public SeniorXHTTPRouteBuilder domain(String domain) {
        this.domain = domain;
        return this;
    }

    public SeniorXHTTPRouteBuilder service(String service) {
        this.service = service;
        return this;
    }

    public SeniorXHTTPRouteBuilder primitiveType(PrimitiveType primitiveType) {
        this.primitiveType = primitiveType;
        return this;
    }

    public SeniorXHTTPRouteBuilder primitive(String primitive) {
        this.primitive = primitive;
        return this;
    }

    public void route(Exchange exchange) {
        PropertiesComponent properties = exchange.getContext().getPropertiesComponent();
        Object route = this.resolve(properties, this.url);
        if (route == null) {
            return;
        }
        if (((String)route).endsWith("/")) {
            route = ((String)route).substring(0, ((String)route).length() - 1);
        }
        if (this.anonymous) {
            route = (String)route + "/anonymous";
        }
        route = (String)route + "/rest/" + this.domain + "/" + this.service + "/" + this.primitiveType.path + "/" + this.primitive;
        Message message = exchange.getMessage();
        message.setHeader("Content-Type", (Object)"application/json");
        message.setHeader("CamelHttpMethod", (Object)this.method);
        this.call((String)route, this.resolve(properties, this.allowedInsecureHost), exchange);
    }

    private void call(String route, String insecureHost, Exchange exchange) {
        HttpComponent httpComponent = (HttpComponent)exchange.getContext().getComponent("http", HttpComponent.class);
        if (route.startsWith(HTTPS)) {
            httpComponent = (HttpComponent)exchange.getContext().getComponent(HTTPS, HttpComponent.class);
            if (insecureHost != null) {
                this.configureInsecureCall(route, insecureHost, httpComponent);
            }
        }
        exchange.getIn().setHeader("CamelHttpUri", (Object)route);
        try (ProducerTemplate producerTemplate = exchange.getContext().createProducerTemplate();){
            LOGGER.info("Routing to {}", (Object)route);
            ForwardProcessor forwardProcessor = new ForwardProcessor(exchange);
            Exchange request = producerTemplate.request(httpComponent.createEndpoint(route), (Processor)forwardProcessor);
            LOGGER.info("Routed to {}", (Object)route);
            Exception e = request.getException();
            if (e != null) {
                throw new SeniorXHTTPException(e);
            }
            forwardProcessor.reverse(request);
        }
        catch (SeniorXHTTPException e) {
            throw e;
        }
        catch (Exception e) {
            throw new SeniorXHTTPException(e);
        }
    }

    private void configureInsecureCall(String route, String insecureHost, HttpComponent httpComponent) {
        LOGGER.warn("Routing to insecure http call {}", (Object)route);
        SSLContext sslctxt = this.getSSLContext();
        HttpClientConfigurer httpClientConfig = this.getEndpointClientConfigurer(sslctxt);
        httpComponent.setHttpClientConfigurer(httpClientConfig);
        AllowHost hnv = new AllowHost(insecureHost);
        SSLConnectionSocketFactory sslSocketFactory = new SSLConnectionSocketFactory(sslctxt, (HostnameVerifier)hnv);
        Registry lookup = RegistryBuilder.create().register(HTTPS, (Object)sslSocketFactory).build();
        BasicHttpClientConnectionManager connManager = new BasicHttpClientConnectionManager((Lookup)lookup);
        httpComponent.setClientConnectionManager((HttpClientConnectionManager)connManager);
    }

    private SSLContext getSSLContext() {
        try {
            SSLContext sslContext = SSLContext.getInstance("TLSv1.2", "SunJSSE");
            TrustManager[] trustAllCerts = new TrustManager[]{new TrustALLManager()};
            sslContext.init(null, trustAllCerts, null);
            return sslContext;
        }
        catch (KeyManagementException | NoSuchAlgorithmException | NoSuchProviderException e) {
            throw new SeniorXHTTPException(e);
        }
    }

    private HttpClientConfigurer getEndpointClientConfigurer(SSLContext sslContext) {
        return clientBuilder -> clientBuilder.setSSLContext(sslContext);
    }

    private String resolve(PropertiesComponent properties, String value) {
        if (value != null && value.startsWith("{{") && value.endsWith("}}")) {
            return properties.resolveProperty(value.substring(2, value.length() - 2)).orElse(null);
        }
        return value;
    }

    private static class AllowHost
    implements HostnameVerifier {
        private final String allowedInsecureHost;

        public AllowHost(String allowedInsecureHost) {
            this.allowedInsecureHost = allowedInsecureHost;
        }

        @Override
        public boolean verify(String hostname, SSLSession session) {
            boolean allowed = this.allowedInsecureHost.equals(hostname);
            if (allowed) {
                LOGGER.debug("Allowing {}", (Object)hostname);
            } else {
                LOGGER.error("Blocking {}", (Object)hostname);
            }
            return allowed;
        }
    }

    private class TrustALLManager
    implements X509TrustManager {
        private TrustALLManager() {
        }

        @Override
        public void checkClientTrusted(X509Certificate[] chain, String authType) throws CertificateException {
        }

        @Override
        public void checkServerTrusted(X509Certificate[] chain, String authType) throws CertificateException {
        }

        @Override
        public X509Certificate[] getAcceptedIssuers() {
            return new X509Certificate[0];
        }
    }
}

