/*
 * Decompiled with CFR 0.152.
 */
package br.com.senior.seniorx.http.camel.authentication;

import br.com.senior.seniorx.http.camel.PrimitiveType;
import br.com.senior.seniorx.http.camel.SeniorXHTTPRouteBuilder;
import br.com.senior.seniorx.http.camel.authentication.AuthenticationException;
import br.com.senior.seniorx.http.camel.authentication.LoginInput;
import br.com.senior.seniorx.http.camel.authentication.LoginOutput;
import br.com.senior.seniorx.http.camel.authentication.LoginWithKeyInput;
import br.com.senior.seniorx.http.camel.authentication.RefreshTokenInput;
import br.com.senior.seniorx.http.camel.authentication.Token;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.time.Duration;
import java.util.Date;
import org.apache.camel.Exchange;
import org.apache.camel.ExchangePattern;
import org.apache.camel.Predicate;
import org.apache.camel.Processor;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.model.ChoiceDefinition;
import org.apache.camel.model.RouteDefinition;
import org.apache.camel.spi.DataFormat;
import org.ehcache.Cache;
import org.ehcache.CacheManager;
import org.ehcache.config.ResourcePools;
import org.ehcache.config.ResourceUnit;
import org.ehcache.config.builders.CacheConfigurationBuilder;
import org.ehcache.config.builders.CacheManagerBuilder;
import org.ehcache.config.builders.ExpiryPolicyBuilder;
import org.ehcache.config.builders.ResourcePoolsBuilder;
import org.ehcache.config.units.MemoryUnit;

public class AuthenticationAPI {
    private static final String PLATFORM = "platform";
    private static final String AUTHENTICATION = "authentication";
    private static final String AUTHENTICATE = "authenticate";
    private static final String HEADERS_LOG = "${in.headers}";
    private static final String DIRECT_TOKEN_FOUND = "direct:authentication-token-found";
    private static final String DIRECT_TOKEN_NOT_FOUND = "direct:authentication-token-not-found";
    private static final String DIRECT_LOGIN = "direct:authentication-login";
    private static final String DIRECT_LOGIN_WITH_KEY = "direct:authentication-login-with-key";
    private static final String DIRECT_REFRESH_TOKEN = "direct:authentication-refresh-token";
    private static final String TOKEN_CACHE_KEY = "token-cache-key";
    private static final String TOKEN = "token";
    private static final String TOKEN_CACHE_NAME = "tokenCache";
    private static final long TOKEN_CACHE_SIZE = 64000000L;
    private static final int REFRESH_TOKEN_TTL = 15552000;
    private static final int TOKEN_EXPIRATION_MARGIN = 60;
    private static final CacheManager CACHE_MANAGER = CacheManagerBuilder.newCacheManagerBuilder().build(true);
    private static final Cache<String, Token> TOKEN_CACHE = CACHE_MANAGER.createCache("tokenCache", CacheConfigurationBuilder.newCacheConfigurationBuilder(String.class, Token.class, (ResourcePools)ResourcePoolsBuilder.newResourcePoolsBuilder().heap(64000000L, (ResourceUnit)MemoryUnit.B).build()).withExpiry(ExpiryPolicyBuilder.timeToLiveExpiration((Duration)Duration.ofSeconds(15552000L))).build());
    private final RouteBuilder builder;

    public AuthenticationAPI(RouteBuilder builder) {
        this.builder = builder;
    }

    public void authenticate(String from, Processor enrichWithToken, String to) {
        this.tokenFound();
        this.tokenNotFound();
        this.login();
        this.loginWithKey();
        this.refreshToken();
        ((ChoiceDefinition)((ChoiceDefinition)((ChoiceDefinition)((ChoiceDefinition)((RouteDefinition)((RouteDefinition)((RouteDefinition)this.builder.from(from).routeId(AUTHENTICATE).to("log:authenticate")).log(HEADERS_LOG)).process(this::searchToken)).choice().when((Predicate)this.builder.method((Object)this, "tokenFound")).setExchangePattern(ExchangePattern.InOut)).to(DIRECT_TOKEN_FOUND)).otherwise().setExchangePattern(ExchangePattern.InOut)).to(DIRECT_TOKEN_NOT_FOUND)).end().process(enrichWithToken).to(to);
    }

    public static void addAuthorization(Exchange exchange) {
        Token token = (Token)exchange.getProperty(TOKEN);
        exchange.getMessage().setHeader("Authorization", (Object)("Bearer " + token.accessToken));
    }

    private void tokenFound() {
        ((ChoiceDefinition)((ChoiceDefinition)((ChoiceDefinition)((ChoiceDefinition)((ChoiceDefinition)((ChoiceDefinition)((ChoiceDefinition)((ChoiceDefinition)((RouteDefinition)((RouteDefinition)this.builder.from(DIRECT_TOKEN_FOUND).routeId("token-found").to("log:tokenFound")).log(HEADERS_LOG)).choice().when((Predicate)this.builder.method((Object)this, "isExpiredToken")).to("log:tokenExpired")).log(HEADERS_LOG)).setExchangePattern(ExchangePattern.InOut)).to(DIRECT_REFRESH_TOKEN)).to("log:refreshedToken")).log(HEADERS_LOG)).unmarshal((DataFormat)LoginOutput.LOGIN_OUTPUT_FORMAT)).process(this::unmarshallToken)).end();
    }

    private void tokenNotFound() {
        ((ChoiceDefinition)((ChoiceDefinition)((ChoiceDefinition)((ChoiceDefinition)((RouteDefinition)((RouteDefinition)this.builder.from(DIRECT_TOKEN_NOT_FOUND).routeId("token-not-found").to("log:tokenNotFound")).log(HEADERS_LOG)).choice().when((Predicate)this.builder.method((Object)this, "isUserLogin")).setExchangePattern(ExchangePattern.InOut)).to(DIRECT_LOGIN)).otherwise().setExchangePattern(ExchangePattern.InOut)).to(DIRECT_LOGIN_WITH_KEY)).end().to("log:authenticated").log(HEADERS_LOG).unmarshal((DataFormat)LoginOutput.LOGIN_OUTPUT_FORMAT).process(this::unmarshallToken);
    }

    private void login() {
        SeniorXHTTPRouteBuilder login = new SeniorXHTTPRouteBuilder(this.builder);
        login.method("post").domain(PLATFORM).service(AUTHENTICATION).primitiveType(PrimitiveType.ACTION).primitive("login");
        ((RouteDefinition)((RouteDefinition)((RouteDefinition)((RouteDefinition)((RouteDefinition)((RouteDefinition)this.builder.from(DIRECT_LOGIN).routeId("login").marshal((DataFormat)LoginInput.LOGIN_INPUT_FORMAT)).to("log:login")).log(HEADERS_LOG)).setExchangePattern(ExchangePattern.InOut)).process(login::route)).to("log:logged")).log(HEADERS_LOG);
    }

    private void loginWithKey() {
        SeniorXHTTPRouteBuilder loginWithKey = new SeniorXHTTPRouteBuilder(this.builder);
        loginWithKey.method("post").domain(PLATFORM).service(AUTHENTICATION).primitiveType(PrimitiveType.ACTION).primitive("loginWithKey").anonymous(true);
        ((RouteDefinition)((RouteDefinition)((RouteDefinition)((RouteDefinition)((RouteDefinition)((RouteDefinition)this.builder.from(DIRECT_LOGIN_WITH_KEY).routeId("loginWithKey").marshal((DataFormat)LoginWithKeyInput.LOGIN_WITH_KEY_INPUT_FORMAT)).to("log:loginWithKey")).log(HEADERS_LOG)).setExchangePattern(ExchangePattern.InOut)).process(loginWithKey::route)).to("log:loggedWithKey")).log(HEADERS_LOG);
    }

    private void refreshToken() {
        SeniorXHTTPRouteBuilder refreshToken = new SeniorXHTTPRouteBuilder(this.builder);
        refreshToken.method("post").domain(PLATFORM).service(AUTHENTICATION).primitiveType(PrimitiveType.ACTION).primitive("refreshToken");
        ((RouteDefinition)((RouteDefinition)((RouteDefinition)((RouteDefinition)((RouteDefinition)((RouteDefinition)((RouteDefinition)this.builder.from(DIRECT_REFRESH_TOKEN).routeId("refreshToken").process(this::prepareRefreshToken)).marshal((DataFormat)RefreshTokenInput.REFRESH_TOKEN_INPUT_FORMAT)).to("log:refreshToken")).log(HEADERS_LOG)).setExchangePattern(ExchangePattern.InOut)).process(refreshToken::route)).to("log:refreshedToken")).log(HEADERS_LOG);
    }

    private void searchToken(Exchange exchange) {
        String key = null;
        Token token = null;
        Object body = exchange.getMessage().getBody();
        if (body instanceof LoginInput) {
            LoginInput loginInput = (LoginInput)body;
            key = "user:" + loginInput.username + "$" + loginInput.password;
        } else if (body instanceof LoginWithKeyInput) {
            LoginWithKeyInput loginWithKeyInput = (LoginWithKeyInput)body;
            key = "app:" + loginWithKeyInput.accessKey + "@" + loginWithKeyInput.tenantName + "$" + loginWithKeyInput.secret;
        } else {
            throw new AuthenticationException("Unknown login payload: " + body.getClass().getName());
        }
        exchange.setProperty(TOKEN_CACHE_KEY, (Object)key);
        token = (Token)TOKEN_CACHE.get((Object)key);
        if (token != null) {
            exchange.getMessage().setBody((Object)token);
        }
    }

    public boolean tokenFound(Object body) {
        return body instanceof Token;
    }

    public boolean isExpiredToken(Object body) {
        Token token = (Token)body;
        return this.now() >= token.expireTime;
    }

    public boolean isUserLogin(Object body) {
        return body instanceof LoginInput;
    }

    private void unmarshallToken(Exchange exchange) {
        Exception exception = exchange.getException();
        if (exception != null) {
            throw new AuthenticationException(exception);
        }
        LoginOutput output = (LoginOutput)exchange.getMessage().getBody();
        if (output.jsonToken == null) {
            throw new AuthenticationException(output.reason + ": " + output.message);
        }
        ObjectMapper mapper = new ObjectMapper();
        try {
            Token token = (Token)mapper.readValue(output.jsonToken, Token.class);
            token.expireTime = this.now() + (token.expiresIn - 60L) * 1000L;
            TOKEN_CACHE.put((Object)exchange.getProperty(TOKEN_CACHE_KEY).toString(), (Object)token);
            exchange.setProperty(TOKEN, (Object)token);
            exchange.getMessage().setBody((Object)token);
            AuthenticationAPI.addAuthorization(exchange);
        }
        catch (JsonProcessingException e) {
            throw new AuthenticationException(e);
        }
    }

    private long now() {
        return new Date().getTime();
    }

    private void prepareRefreshToken(Exchange exchange) {
        RefreshTokenInput input = new RefreshTokenInput();
        Token token = (Token)exchange.getProperty(TOKEN);
        input.refreshToken = token.refreshToken;
        exchange.getMessage().setBody((Object)input);
    }
}

