/*
 * Decompiled with CFR 0.152.
 */
package buzz.getcoco.media;

import buzz.getcoco.media.CocoMediaClient;
import buzz.getcoco.media.CommandIdInterface;
import buzz.getcoco.media.CommandResponse;
import buzz.getcoco.media.Util;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.util.logging.Logger;

public class Command<T extends CommandIdInterface, U extends CommandResponse<T>> {
    private static final Logger LOGGER = Util.getLogger();
    private final transient T commandId;
    private final transient Class<U> responseClass;

    protected Command(T commandId, Class<U> responseClass) {
        this.commandId = commandId;
        this.responseClass = responseClass;
    }

    static void init(GsonBuilder builder) {
        builder.registerTypeAdapter(State.class, (json, typeOfT, context) -> State.getValue(json.getAsInt()));
    }

    public T getCommandId() {
        return this.commandId;
    }

    U createResponse(String json) {
        LOGGER.fine("responseJson: " + json);
        Gson gson = CocoMediaClient.getInstance().getGson();
        JsonElement je = JsonParser.parseString((String)json);
        if (!je.isJsonObject()) {
            throw new IllegalStateException("Internal error, jo should be a JsonObject.But, it is: " + je.getClass());
        }
        JsonObject jo = je.getAsJsonObject();
        JsonElement cmdParamsJson = jo.get("cmdParams");
        JsonElement cmdStatusJson = jo.get("status");
        JsonElement errorMessageJson = jo.get("errorMessage");
        State status = (State)((Object)gson.fromJson(cmdStatusJson, State.class));
        String errorMessage = (String)gson.fromJson(errorMessageJson, String.class);
        CommandResponse response = (CommandResponse)gson.fromJson((JsonElement)(null != cmdParamsJson ? cmdParamsJson : new JsonObject()), this.responseClass);
        response.setStatus(null != status ? status : State.FAILURE);
        response.setErrorMessage(errorMessage);
        response.setCommandId(this.getCommandId());
        return (U)response;
    }

    JsonObject toJson() {
        Gson gson = CocoMediaClient.getInstance().getGson();
        JsonObject jo = new JsonObject();
        jo.add("cmdId", gson.toJsonTree(this.getCommandId()));
        jo.add("cmdParams", gson.toJsonTree((Object)this));
        return jo;
    }

    public String toString() {
        return "Command{commandId=" + this.commandId + ", responseClass=" + this.responseClass + '}';
    }

    public static enum State {
        SUCCESS,
        INVALID,
        FAILURE,
        PARTIAL_SUCCESS,
        TIMEOUT,
        REJECTED,
        DEVICE_BUSY,
        IN_PROGRESS,
        AUTH_FAILED,
        RESOURCE_NOT_SUPPORTED,
        SUCCESS_INSECURE,
        PARTIAL_SUCCESS_INSECURE,
        CONNECTIVITY_ERROR,
        CMD_NOT_SUPPORTED,
        TOKEN_NOT_SET,
        TOKEN_REFRESH_FAILED,
        DISCOVERY_NOT_APPLICABLE,
        NETWORK_DISCONNECTED,
        MAX_COUNT_REACHED,
        DEVICE_UNREACHABLE,
        NETWORK_BLOCKED;


        static State getValue(int val) {
            return State.values()[val];
        }
    }
}

