/*
 * Decompiled with CFR 0.152.
 */
package buzz.getcoco.media;

import buzz.getcoco.media.Channel;
import buzz.getcoco.media.CocoMediaClient;
import buzz.getcoco.media.Command;
import buzz.getcoco.media.CommandResponse;
import buzz.getcoco.media.Context;
import buzz.getcoco.media.Frame;
import buzz.getcoco.media.JniLoader;
import buzz.getcoco.media.Native;
import buzz.getcoco.media.NativeInterface;
import buzz.getcoco.media.Network;
import buzz.getcoco.media.Stream;
import com.google.gson.JsonObject;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

class DefaultNativeHandler
implements NativeInterface {
    private final ThreadPoolExecutor executor = new ThreadPoolExecutor(1, 2, 2L, TimeUnit.SECONDS, new ArrayBlockingQueue<Runnable>(10));

    DefaultNativeHandler() {
    }

    @Override
    public void init(String cwdPath, String appAccessList, String clientId, String downloadPath) {
        JniLoader.load(cwdPath);
        Native.nativeInit(cwdPath, appAccessList, clientId, downloadPath);
    }

    @Override
    public void setTokens(String tokens) {
        Native.nativeSetTokens(tokens);
    }

    @Override
    public <V extends CommandResponse<CocoMediaClient.CommandId>, U extends Command<CocoMediaClient.CommandId, V>> void sendHttpCommand(U command, CocoMediaClient.CommandStatusListener<V> listener) {
        JsonObject commandJson = command.toJson();
        int retVal = Native.nativeSendHttpCommand(commandJson.toString(), new Context(listener, command));
        if (0 > retVal) {
            this.executor.execute(() -> listener.onResponse(null, new IllegalArgumentException("Internal error, check logs")));
        }
    }

    @Override
    public <V extends CommandResponse<Network.CommandId>, U extends Command<Network.CommandId, V>> void sendNetworkCommand(Network n, U command, Network.CommandStatusListener<V> listener) {
        JsonObject commandJson = command.toJson();
        commandJson.addProperty("networkId", n.getId());
        int retVal = Native.nativeSendNetworkCommand(commandJson.toString(), new Context(listener, command));
        if (0 > retVal) {
            this.executor.execute(() -> listener.onResponse(null, new IllegalArgumentException("Internal error, check logs, is this network connected ?")));
        }
    }

    @Override
    public void joinChannel(Channel channel, Channel.ChannelStatusListener listener) {
        int retVal = Native.nativeJoinChannel(channel.getNetworkId(), channel.getId(), new Context(listener, channel));
        if (0 > retVal) {
            this.executor.execute(() -> listener.onJoinStatusChanged(Channel.State.JOIN_FAILED));
        }
    }

    @Override
    public void leaveChannel(Channel channel) {
        Native.nativeLeaveChannel(channel.getNetworkId(), channel.getId());
    }

    @Override
    public void connect(Network network) {
        Native.nativeConnect(network.getId(), new Context(null, network));
    }

    @Override
    public void disconnect(Network network) {
        Native.nativeDisconnect(network.getId());
    }

    @Override
    public void startStream(Stream stream, Stream.StreamStatusListener listener) {
        int retVal = Native.nativeStartStream(stream.getNetworkId(), stream.getChannelId(), stream.getId(), stream.getSourceNodeId(), stream.getSdp(), stream.isTxStream(), new Context(listener, stream));
        if (0 > retVal) {
            this.executor.execute(() -> {
                boolean isTx = stream.isTxStream();
                listener.onStreamStatusChanged(isTx ? Stream.State.CREATE_FAILED : Stream.State.STOPPED);
            });
        }
    }

    @Override
    public void sendStreamData(Stream stream, Frame frame) {
        Native.nativeSendFrameData(stream.getStreamHandle(), frame.getSendData());
    }

    @Override
    public void stopStream(Stream stream) {
        long streamHandle = stream.getStreamHandle();
        if (0L == streamHandle) {
            throw new NullPointerException("internal error (OR) stream not yet started, state: " + (Object)((Object)stream.getStatus()));
        }
        Native.nativeStopStream(stream.getStreamHandle(), stream.isTxStream());
    }

    @Override
    public void sendMessage(Network network, String message, long[] destinationNodes) {
        Native.nativeSendMessage(network.getId(), message, true, 0, destinationNodes);
    }

    @Override
    public void sendContentInfoMessage(Network network, String message, int contentTime, long[] destinationNodes) {
        Native.nativeSendMessage(network.getId(), message, false, contentTime, destinationNodes);
    }

    public String toString() {
        return "DefaultNativeHandler{executor=" + this.executor + '}';
    }
}

