/*
 * Decompiled with CFR 0.152.
 */
package buzz.getcoco.media;

import buzz.getcoco.media.Frame;
import buzz.getcoco.media.RxStreamInfo;
import buzz.getcoco.media.Stream;

public class RxStream
extends Stream {
    private final RxStreamInfo streamInfo;

    public RxStream(RxStreamInfo streamInfo) {
        super(streamInfo.getSdp(), streamInfo.getNetworkId(), streamInfo.getChannelId(), streamInfo.getStreamId());
        this.streamInfo = streamInfo;
        this.internalSetSourceNodeId(streamInfo.getSourceNodeId());
    }

    @Override
    protected boolean isTxStream() {
        return false;
    }

    public void start(Stream.StreamStatusListener listener) throws Stream.StateException {
        if (RxStreamInfo.isDestroyed(this.streamInfo)) {
            throw new Stream.StateException(Stream.State.DESTROYED, "Stream is already destroyed");
        }
        super.internalStart(listener);
    }

    public void stop() {
        super.internalStop();
    }

    @Override
    protected void sendData(Frame frame) {
        throw new IllegalArgumentException("cannot send data into rx stream");
    }

    @Override
    public String toString() {
        return "RxStream{streamInfo=" + this.streamInfo + "} " + super.toString();
    }
}

