/*
 * Decompiled with CFR 0.152.
 */
package buzz.getcoco.media;

import buzz.getcoco.media.CocoMediaClient;
import buzz.getcoco.media.Frame;
import buzz.getcoco.media.Listener;
import buzz.getcoco.media.Util;
import java.util.Objects;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.logging.Logger;

public abstract class Stream {
    private static final Logger LOGGER = Util.getLogger();
    private final String networkId;
    private final int channelId;
    private final String sdp;
    private final long streamId;
    private final ReentrantReadWriteLock handleLock = new ReentrantReadWriteLock();
    private volatile long streamHandle = 0L;
    private long sourceNodeId;
    private State status = State.DESTROYED;

    protected Stream(String sdp, String networkId, int channelId, long streamId) {
        this.sdp = sdp;
        this.networkId = networkId;
        this.channelId = channelId;
        this.streamId = streamId;
    }

    protected abstract boolean isTxStream();

    public State getStatus() {
        return this.status;
    }

    public String getNetworkId() {
        return this.networkId;
    }

    public int getChannelId() {
        return this.channelId;
    }

    public long getId() {
        return this.streamId;
    }

    public String getSdp() {
        return this.sdp;
    }

    public long getSourceNodeId() {
        return this.sourceNodeId;
    }

    protected void internalSetSourceNodeId(long nodeId) {
        this.sourceNodeId = nodeId;
    }

    protected void internalSetStatus(State status) {
        this.status = status;
    }

    void setStreamHandle(long streamHandle) {
        this.streamHandle = streamHandle;
    }

    long getStreamHandle() {
        return this.streamHandle;
    }

    void waitUntilAllSendersReturn() {
        this.handleLock.writeLock().lock();
        this.handleLock.writeLock().unlock();
    }

    protected final void internalStart(StreamStatusListener listener) {
        if (State.STARTING == this.status || State.STARTED == this.status) {
            throw new StateException(this.status, "cannot internalStart when status is: " + (Object)((Object)this.status));
        }
        Objects.requireNonNull(listener);
        CocoMediaClient.getInstance().getNativeHandler().startStream(this, listener);
    }

    protected void sendData(Frame frame) {
        if (!frame.getData().isDirect()) {
            throw new IllegalArgumentException("frame data MUST be a direct ByteBuffer");
        }
        this.handleLock.readLock().lock();
        try {
            if (0L == this.streamHandle) {
                throw new StateException(this.status, "stream handle un-set");
            }
            CocoMediaClient.getInstance().getNativeHandler().sendStreamData(this, frame);
        }
        finally {
            this.handleLock.readLock().unlock();
        }
    }

    protected final void internalStop() {
        this.handleLock.readLock().lock();
        try {
            if (0L == this.streamHandle) {
                LOGGER.warning("stream handle un-set, ignoring stop call");
                return;
            }
            CocoMediaClient.getInstance().getNativeHandler().stopStream(this);
        }
        finally {
            this.handleLock.readLock().unlock();
        }
    }

    public String toString() {
        return "Stream{networkId='" + this.networkId + '\'' + ", channelId=" + this.channelId + ", sdp='" + this.sdp + '\'' + ", streamId=" + this.streamId + ", sendLock=" + this.handleLock + ", streamHandle=" + this.streamHandle + ", sourceNodeId=" + this.sourceNodeId + ", status=" + (Object)((Object)this.status) + '}';
    }

    public static class StateException
    extends IllegalStateException {
        private static final long serialVersionUID = 9120120234234L;
        public final State currentState;

        public StateException(State currentState, String message) {
            super(message);
            this.currentState = currentState;
        }

        @Override
        public String toString() {
            return "StateException{currentState=" + (Object)((Object)this.currentState) + "} " + super.toString();
        }
    }

    public static interface StreamStatusListener
    extends Listener {
        public void onStreamStatusChanged(State var1);

        default public void onStreamDataReceived(Frame frame) {
        }
    }

    public static enum State {
        CREATED,
        CREATE_FAILED,
        STARTING,
        STARTED,
        STOPPED,
        DESTROYED;


        static State getValue(int val, boolean isTx) {
            switch (val) {
                case 0: {
                    return isTx ? STARTED : CREATED;
                }
                case 1: {
                    return CREATE_FAILED;
                }
                case 3: {
                    return STARTED;
                }
                case 2: {
                    return STARTING;
                }
                case 4: {
                    return STOPPED;
                }
            }
            return DESTROYED;
        }
    }
}

