/*
 * Decompiled with CFR 0.152.
 */
package buzz.getcoco.media;

import buzz.getcoco.media.Util;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.logging.Logger;

public final class Frame {
    private static final Logger LOGGER = Util.getLogger();
    public static final int FRAME_TYPE_KEY = 0;
    public static final int FRAME_TYPE_NONE = 1;
    public static final int MIME_TYPE_VIDEO_H264 = 0;
    public static final int MIME_TYPE_AUDIO_AAC = 1;
    public static final int MIME_TYPE_TEXT = 2;
    private final int originalPosition;
    private final long frameIndex;
    private final int frameType;
    private final int mimeType;
    private final long frameDuration;
    private final long framePts;
    private final ByteBuffer data;
    public static final int HEADER_SIZE = 32;

    public Frame(ByteBuffer buf) {
        assert (null != buf);
        assert (32 < buf.remaining());
        this.originalPosition = buf.position();
        this.frameIndex = buf.getInt();
        this.mimeType = buf.getInt();
        this.frameType = buf.getInt();
        this.frameDuration = buf.getLong();
        this.framePts = buf.getLong();
        int frameSize = buf.getInt();
        LOGGER.fine("frameSize: " + frameSize);
        assert (0 <= frameSize) : "frameSize: " + frameSize;
        assert (0L <= this.frameIndex) : "frameIndex: " + this.frameIndex;
        assert (0L <= this.framePts) : "framePts: " + this.framePts;
        assert (0L <= this.frameDuration) : "frameDuration: " + this.frameDuration;
        assert (0 == this.frameType || 1 == this.frameType);
        this.data = buf;
    }

    public int getMimeType() {
        return this.mimeType;
    }

    public long getFrameIndex() {
        return this.frameIndex;
    }

    public int getFrameType() {
        return this.frameType;
    }

    public long getFrameDuration() {
        return this.frameDuration;
    }

    public long getFramePts() {
        return this.framePts;
    }

    public ByteBuffer getData() {
        return this.data;
    }

    ByteBuffer getSendData() {
        this.data.position(this.originalPosition);
        return this.data;
    }

    public String toString() {
        return "Frame{originalPosition=" + this.originalPosition + ", frameIndex=" + this.frameIndex + ", frameType=" + this.frameType + ", mimeType=" + this.mimeType + ", frameDuration=" + this.frameDuration + ", framePts=" + this.framePts + ", data=" + this.data + '}';
    }

    public static class Builder {
        private int frameIndex;
        private int frameType;
        private int mimeType;
        private long frameDuration;
        private long framePts;

        public Builder setFrameIndex(int frameIndex) {
            this.frameIndex = frameIndex;
            return this;
        }

        public Builder setFrameType(int frameType) {
            this.frameType = frameType;
            return this;
        }

        public Builder setMimeType(int mimeType) {
            this.mimeType = mimeType;
            return this;
        }

        public Builder setFramePts(long framePts) {
            this.framePts = framePts;
            return this;
        }

        public Builder setFrameDuration(long frameDuration) {
            this.frameDuration = frameDuration;
            return this;
        }

        public Frame build(int frameSize) {
            assert (0 < frameSize) : "frameSize: " + frameSize;
            ByteBuffer buf = ByteBuffer.allocateDirect(32 + frameSize);
            buf.order(ByteOrder.nativeOrder());
            buf.putInt(this.frameIndex);
            buf.putInt(this.mimeType);
            buf.putInt(this.frameType);
            buf.putLong(this.frameDuration);
            buf.putLong(this.framePts);
            buf.putInt(frameSize);
            buf.position(0);
            return new Frame(buf);
        }

        public String toString() {
            return "Builder{frameIndex=" + this.frameIndex + ", frameType=" + this.frameType + ", mimeType=" + this.mimeType + ", frameDuration=" + this.frameDuration + ", framePts=" + this.framePts + '}';
        }
    }
}

