/*
 * Decompiled with CFR 0.152.
 */
package buzz.getcoco.media;

import buzz.getcoco.media.CocoMediaClient;
import buzz.getcoco.media.Listener;
import buzz.getcoco.media.RxStreamInfo;
import buzz.getcoco.media.Stream;
import com.google.gson.annotations.SerializedName;

public class Channel {
    @SerializedName(value="channelName")
    private String channelName;
    @SerializedName(value="metadata")
    private String channelMetadata;
    @SerializedName(value="maxStreams")
    private int maxStreams;
    @SerializedName(value="networkId")
    private final String networkId;
    @SerializedName(value="channelID")
    private final int channelId;
    private transient State channelState = null;

    protected Channel(String networkId, int channelId) {
        this.networkId = networkId;
        this.channelId = channelId;
    }

    public String getNetworkId() {
        return this.networkId;
    }

    public int getId() {
        return this.channelId;
    }

    protected void internalSetState(State state) {
        this.channelState = state;
    }

    protected void internalSetName(String channelName) {
        this.channelName = channelName;
    }

    protected void internalSetMetadata(String channelMetadata) {
        this.channelMetadata = channelMetadata;
    }

    protected void internalSetMaxStreams(int maxStreams) {
        this.maxStreams = maxStreams;
    }

    public State getState() {
        return this.channelState;
    }

    public String getName() {
        return this.channelName;
    }

    public String getMetadata() {
        return this.channelMetadata;
    }

    public int getMaxStreams() {
        return this.maxStreams;
    }

    public void join(ChannelStatusListener listener) {
        CocoMediaClient.getInstance().getNativeHandler().joinChannel(this, listener);
    }

    public void leave() {
        CocoMediaClient.getInstance().getNativeHandler().leaveChannel(this);
    }

    public String toString() {
        return "Channel{channelName='" + this.channelName + '\'' + ", channelMetadata='" + this.channelMetadata + '\'' + ", maxStreams=" + this.maxStreams + ", networkId='" + this.networkId + '\'' + ", channelId=" + this.channelId + ", channelState=" + (Object)((Object)this.channelState) + '}';
    }

    public static interface ChannelStatusListener
    extends Listener {
        public void onJoinStatusChanged(State var1);

        public void onStreamInfoUpdated(RxStreamInfo var1, Stream.State var2);
    }

    public static enum State {
        CREATED,
        JOINING,
        JOINED,
        JOIN_FAILED,
        LEFT,
        LEAVE_FAILED,
        DESTROYED,
        DESTROY_FAILED;


        static State getValue(int val) {
            return State.values()[val];
        }
    }
}

