/*
 * Decompiled with CFR 0.152.
 */
package buzz.getcoco.media;

import buzz.getcoco.media.Channel;
import buzz.getcoco.media.CocoMediaClient;
import buzz.getcoco.media.Command;
import buzz.getcoco.media.CommandIdInterface;
import buzz.getcoco.media.CommandResponse;
import buzz.getcoco.media.Context;
import buzz.getcoco.media.Frame;
import buzz.getcoco.media.NativeCallbacksInterface;
import buzz.getcoco.media.Network;
import buzz.getcoco.media.RxStreamInfo;
import buzz.getcoco.media.Stream;
import buzz.getcoco.media.Util;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.Objects;
import java.util.logging.Level;
import java.util.logging.Logger;

class DefaultNativeCallbacksHandler
implements NativeCallbacksInterface {
    private static final Logger LOGGER = Util.getLogger();

    DefaultNativeCallbacksHandler() {
    }

    private <T extends CommandIdInterface> Throwable getErrorFromResponse(CommandResponse<T> response) {
        if (null == response) {
            return new IllegalStateException("unable to parse response");
        }
        if (Command.State.SUCCESS == response.getStatus()) {
            return null;
        }
        return new IllegalStateException("failure response: " + response);
    }

    @Override
    public void authCallback(String authEndPoint, String tokenEndPoint) {
        CocoMediaClient.getInstance().getAuthListener().onAuthRequired(authEndPoint, tokenEndPoint);
        LOGGER.log(Level.FINE, "authCallback: authEndPoint: " + authEndPoint + ", tokenEndPoint: " + tokenEndPoint);
    }

    @Override
    public void httpCommandStatusCallback(String response, Object context) {
        LOGGER.fine("response: " + response + ", context: " + context);
        Context castedContext = (Context)context;
        Command command = (Command)castedContext.getSdkContext();
        CocoMediaClient.CommandStatusListener listener = (CocoMediaClient.CommandStatusListener)castedContext.getDeveloperContext();
        Object commandResponse = command.createResponse(response);
        listener.onResponse(commandResponse, this.getErrorFromResponse((CommandResponse)commandResponse));
        LOGGER.log(Level.FINE, "response: " + response);
    }

    @Override
    public void networkCommandStatusCallback(String response, Object context) {
        LOGGER.fine("response: " + response + ", context: " + context);
        Context castedContext = (Context)context;
        Command command = (Command)castedContext.getSdkContext();
        Network.CommandStatusListener listener = (Network.CommandStatusListener)castedContext.getDeveloperContext();
        Object commandResponse = command.createResponse(response);
        listener.onResponse(commandResponse, this.getErrorFromResponse((CommandResponse)commandResponse));
        LOGGER.log(Level.FINE, "response: " + response);
    }

    @Override
    public void connectStatusCallback(int status, Object connectContext) {
        LOGGER.fine("status: " + status + ", context: " + connectContext);
        Context castedContext = (Context)connectContext;
        Network network = (Network)castedContext.getSdkContext();
        Network.State networkStatus = Network.State.getValue(status);
        network.internalSetStatus(networkStatus);
        LOGGER.log(Level.FINE, "network: " + network + ", state: " + status);
    }

    @Override
    public void channelJoinStatusCallback(int channelId, int status, Object joinContext) {
        LOGGER.fine("channelId: " + channelId + ", status: " + status + ", context: " + joinContext);
        Context castedContext = (Context)joinContext;
        Channel channel = (Channel)castedContext.getSdkContext();
        Channel.ChannelStatusListener listener = (Channel.ChannelStatusListener)castedContext.getDeveloperContext();
        Channel.State joinStatus = Channel.State.getValue(status);
        channel.internalSetState(joinStatus);
        listener.onJoinStatusChanged(joinStatus);
        LOGGER.log(Level.FINE, "channel: " + channel);
    }

    @Override
    public void channelStreamInfoCallback(int channelId, long streamId, long sourceNodeId, int status, String sdp, Object joinContext) {
        LOGGER.fine("channelId: " + channelId + ", streamId: " + streamId + ", nodeId: " + sourceNodeId + ", status: " + status + ", joinContext: " + joinContext);
        Context castedContext = (Context)joinContext;
        Channel channel = (Channel)castedContext.getSdkContext();
        Channel.ChannelStatusListener listener = (Channel.ChannelStatusListener)castedContext.getDeveloperContext();
        Objects.requireNonNull(listener);
        RxStreamInfo streamInfo = new RxStreamInfo(sdp, channel.getNetworkId(), channelId, streamId, sourceNodeId);
        Stream.State streamStatus = Stream.State.getValue(status, false);
        if (Stream.State.CREATED == streamStatus) {
            RxStreamInfo.activateStream(streamInfo);
        }
        if (Stream.State.DESTROYED == streamStatus) {
            RxStreamInfo.deactivateStream(streamInfo);
        }
        listener.onStreamInfoUpdated(streamInfo, streamStatus);
    }

    @Override
    public void streamStatusChangedCallback(int channelId, long streamHandle, long sourceNodeId, int status, Object streamContext) {
        LOGGER.fine("channelId: " + channelId + ", streamHandle: " + streamHandle + ", status: " + status + ", streamContext: " + streamContext);
        Context castedContext = (Context)streamContext;
        Stream stream = (Stream)castedContext.getSdkContext();
        Stream.StreamStatusListener listener = (Stream.StreamStatusListener)castedContext.getDeveloperContext();
        Stream.State streamStatus = Stream.State.getValue(status, stream.isTxStream());
        streamHandle = Stream.State.STARTED == streamStatus ? streamHandle : 0L;
        Objects.requireNonNull(listener);
        stream.setStreamHandle(streamHandle);
        stream.internalSetSourceNodeId(sourceNodeId);
        stream.internalSetStatus(streamStatus);
        listener.onStreamStatusChanged(streamStatus);
        LOGGER.log(Level.FINE, "stream: " + stream);
        if (0L == streamHandle) {
            stream.waitUntilAllSendersReturn();
        }
    }

    @Override
    public void streamDataReceivedCallback(ByteBuffer data, Object streamContext) {
        Context castedContext = (Context)streamContext;
        Stream.StreamStatusListener listener = (Stream.StreamStatusListener)castedContext.getDeveloperContext();
        data.order(ByteOrder.nativeOrder());
        listener.onStreamDataReceived(new Frame(data));
    }

    @Override
    public void messageReceivedCallback(String message, long sourceNodeId, Object connectContext) {
        LOGGER.fine("message received: " + message + ", source: " + sourceNodeId);
        LOGGER.fine("context: " + connectContext);
        Context castedContext = (Context)connectContext;
        Network network = (Network)castedContext.getSdkContext();
        network.internalOnMessageReceived(message, sourceNodeId);
    }

    @Override
    public void contentInfoReceivedCallback(String message, int contentTime, long sourceNodeId, Object connectContext) {
        LOGGER.fine("message received: " + message + ", source: " + sourceNodeId);
        LOGGER.fine("context: " + connectContext);
        Context castedContext = (Context)connectContext;
        Network network = (Network)castedContext.getSdkContext();
        network.internalOnContentInfoMessageReceived(message, sourceNodeId, contentTime);
    }

    @Override
    public void nodeConnectionStatusCallback(long nodeId, boolean isOnline, Object connectContext) {
        LOGGER.fine("node: " + nodeId + ", isOnline: " + isOnline);
        LOGGER.fine("context: " + connectContext);
        Context castedContext = (Context)connectContext;
        Network network = (Network)castedContext.getSdkContext();
        network.internalNodeConnectionStatusCallback(nodeId, isOnline);
    }

    public String toString() {
        return "DefaultNativeCallbacksHandler{}";
    }
}

