/*
 * Decompiled with CFR 0.152.
 */
package buzz.getcoco.media;

import buzz.getcoco.media.Util;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Objects;
import java.util.logging.Level;
import java.util.logging.Logger;

class JniLoader {
    private static final Logger LOGGER = Util.getLogger();
    private static final String LIBRARY_FORMATTER = "/native/%s/%s/libcocomediasdk-java.%s";

    JniLoader() {
    }

    private static String getOsName() {
        String jvmName = System.getProperty("java.vm.name", "").toLowerCase();
        String osName = System.getProperty("os.name", "").toLowerCase();
        if (jvmName.startsWith("dalvik") && osName.startsWith("linux")) {
            osName = "android";
        } else if (jvmName.startsWith("robovm") && osName.startsWith("darwin")) {
            osName = "ios";
        } else if (osName.startsWith("mac") || osName.startsWith("darwin")) {
            osName = "mac";
        } else if (osName.startsWith("windows")) {
            osName = "windows";
        } else if (osName.startsWith("linux")) {
            osName = "linux";
        } else {
            throw new IllegalStateException("unknown os: " + osName);
        }
        return osName;
    }

    private static String getOsArch() {
        String osArch = System.getProperty("os.arch", "").toLowerCase();
        if (osArch.equals("i386") || osArch.equals("i486") || osArch.equals("i586") || osArch.equals("i686")) {
            osArch = "x86";
        } else if (osArch.equals("amd64") || osArch.equals("x86-64") || osArch.equals("x64")) {
            osArch = "x86_64";
        } else if (osArch.startsWith("aarch64") || osArch.startsWith("armv8") || osArch.startsWith("arm64")) {
            osArch = "armv8";
        } else if (osArch.startsWith("arm")) {
            osArch = "armv7";
        } else {
            throw new IllegalStateException("unknown arch: " + osArch);
        }
        return osArch;
    }

    private static String getExtension() {
        String extension;
        String osName = System.getProperty("os.name", "").toLowerCase();
        if (osName.startsWith("linux")) {
            extension = "so";
        } else if (osName.startsWith("mac") || osName.startsWith("darwin")) {
            extension = "dylib";
        } else if (osName.startsWith("windows")) {
            extension = "dll";
        } else {
            throw new IllegalStateException("unknown os: " + osName);
        }
        return extension;
    }

    static void load(String cwd) {
        long startTime = System.currentTimeMillis();
        try {
            System.loadLibrary("cocomediasdk-java");
            return;
        }
        catch (UnsatisfiedLinkError err) {
            LOGGER.log(Level.WARNING, "load from env failed", err);
            LOGGER.log(Level.FINE, "load failed in: " + (System.currentTimeMillis() - startTime));
            String libResource = Util.formatInvariant(LIBRARY_FORMATTER, JniLoader.getOsName(), JniLoader.getOsArch(), JniLoader.getExtension());
            File extractedLib = new File(cwd, libResource);
            LOGGER.log(Level.FINE, "lib path: " + extractedLib.getAbsolutePath());
            try {
                extractedLib.mkdirs();
                extractedLib.delete();
                extractedLib.createNewFile();
            }
            catch (IOException e) {
                LOGGER.log(Level.WARNING, "create/delete file failed", e);
            }
            LOGGER.log(Level.FINE, "loading from resource stream: " + libResource);
            try (InputStream is = JniLoader.class.getResourceAsStream(libResource);
                 FileOutputStream fos = new FileOutputStream(extractedLib);){
                int readLength;
                Objects.requireNonNull(is);
                byte[] buffer = new byte[1024];
                while (-1 != (readLength = is.read(buffer))) {
                    fos.write(buffer, 0, readLength);
                }
            }
            catch (IOException | NullPointerException e) {
                LOGGER.log(Level.WARNING, "load failed from resource stream: " + libResource, e);
            }
            LOGGER.log(Level.FINE, "load: copy complete in: " + (System.currentTimeMillis() - startTime));
            System.load(extractedLib.getAbsolutePath());
            LOGGER.log(Level.FINE, "load: complete in: " + (System.currentTimeMillis() - startTime));
            return;
        }
    }
}

