/*
 * Decompiled with CFR 0.152.
 */
package buzz.getcoco.media;

import buzz.getcoco.media.CocoMediaClient;
import buzz.getcoco.media.Util;
import java.nio.ByteBuffer;
import java.util.logging.Level;
import java.util.logging.Logger;

public class NativeCallbacks {
    private static final Logger LOGGER = Util.getLogger();

    static void logException(Throwable tr) {
        LOGGER.log(Level.WARNING, "error while executing callback", tr);
    }

    static void nativeAuthCallback(String authEndPoint, String tokenEndPoint) {
        try {
            CocoMediaClient.getInstance().getCallbackHandler().authCallback(authEndPoint, tokenEndPoint);
        }
        catch (Throwable tr) {
            NativeCallbacks.logException(tr);
        }
    }

    static void nativeHttpCommandStatusCallback(String response, Object context) {
        try {
            CocoMediaClient.getInstance().getCallbackHandler().httpCommandStatusCallback(response, context);
        }
        catch (Throwable tr) {
            NativeCallbacks.logException(tr);
        }
    }

    static void nativeNetworkCommandStatusCallback(String response, Object context) {
        try {
            CocoMediaClient.getInstance().getCallbackHandler().networkCommandStatusCallback(response, context);
        }
        catch (Throwable tr) {
            NativeCallbacks.logException(tr);
        }
    }

    static void nativeConnectStatusCallback(int status, Object connectContext) {
        try {
            CocoMediaClient.getInstance().getCallbackHandler().connectStatusCallback(status, connectContext);
        }
        catch (Throwable tr) {
            NativeCallbacks.logException(tr);
        }
    }

    static void nativeChannelJoinStatusCallback(int channelId, int status, Object joinContext) {
        try {
            CocoMediaClient.getInstance().getCallbackHandler().channelJoinStatusCallback(channelId, status, joinContext);
        }
        catch (Throwable tr) {
            NativeCallbacks.logException(tr);
        }
    }

    static void nativeChannelStreamInfoUpdatedCallback(int channelId, long streamId, long sourceNodeId, int status, String sdp, Object joinContext) {
        try {
            CocoMediaClient.getInstance().getCallbackHandler().channelStreamInfoCallback(channelId, streamId, sourceNodeId, status, sdp, joinContext);
        }
        catch (Throwable tr) {
            NativeCallbacks.logException(tr);
        }
    }

    static void nativeStreamStatusChangedCallback(int channelId, long streamHandle, long sourceNodeId, int streamStatus, Object streamContext) {
        try {
            CocoMediaClient.getInstance().getCallbackHandler().streamStatusChangedCallback(channelId, streamHandle, sourceNodeId, streamStatus, streamContext);
        }
        catch (Throwable tr) {
            NativeCallbacks.logException(tr);
        }
    }

    static void nativeStreamDataReceivedCallback(ByteBuffer data, Object streamContext) {
        try {
            CocoMediaClient.getInstance().getCallbackHandler().streamDataReceivedCallback(data, streamContext);
        }
        catch (Throwable tr) {
            NativeCallbacks.logException(tr);
        }
    }

    static void nativeMessageReceivedCallback(boolean isMessage, long sourceNodeId, int contentTime, String message, Object connectContext) {
        try {
            if (isMessage) {
                CocoMediaClient.getInstance().getCallbackHandler().messageReceivedCallback(message, sourceNodeId, connectContext);
            } else {
                CocoMediaClient.getInstance().getCallbackHandler().contentInfoReceivedCallback(message, contentTime, sourceNodeId, connectContext);
            }
        }
        catch (Throwable tr) {
            NativeCallbacks.logException(tr);
        }
    }

    static void nativeNodeConnectionStatusCallback(long nodeId, boolean isOnline, Object connectContext) {
        try {
            CocoMediaClient.getInstance().getCallbackHandler().nodeConnectionStatusCallback(nodeId, isOnline, connectContext);
        }
        catch (Throwable tr) {
            NativeCallbacks.logException(tr);
        }
    }
}

