/*
 * Decompiled with CFR 0.152.
 */
package buzz.getcoco.media;

import buzz.getcoco.media.Channel;
import buzz.getcoco.media.CocoMediaClient;
import buzz.getcoco.media.Command;
import buzz.getcoco.media.CommandIdInterface;
import buzz.getcoco.media.CommandResponse;
import buzz.getcoco.media.Listener;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonPrimitive;
import com.google.gson.annotations.SerializedName;
import java.util.Arrays;

public class Network {
    public static final long MANAGEMENT_NODE_ID = 0L;
    @SerializedName(value="networkName")
    private String networkName;
    @SerializedName(value="metadata")
    private String networkMetadata;
    @SerializedName(value="type")
    private Type networkType;
    @SerializedName(value="role")
    private Role userRole;
    @SerializedName(value="accessType")
    private AccessType accessType;
    @SerializedName(value="networkId")
    private final String networkId;
    private transient MessagingListener messagingListener;
    private transient State networkStatus = State.DISCONNECTED;

    protected Network(String networkId) {
        this.networkId = networkId;
    }

    static void init(GsonBuilder builder) {
        builder.registerTypeAdapter(CommandId.class, (src, typeOfSrc, context) -> new JsonPrimitive((Number)src.getInt()));
        builder.registerTypeAdapter(Role.class, (src, typeOfSrc, context) -> new JsonPrimitive((Number)src.getInt()));
        builder.registerTypeAdapter(Role.class, (json, typeOfT, context) -> Role.getValue(json.getAsInt()));
        builder.registerTypeAdapter(AccessType.class, (src, typeOfSrc, context) -> new JsonPrimitive((Number)src.getInt()));
        builder.registerTypeAdapter(AccessType.class, (json, t, c) -> AccessType.getValue(json.getAsInt()));
        builder.registerTypeAdapter(Type.class, (src, typeOfSrc, context) -> new JsonPrimitive((Number)src.getInt()));
        builder.registerTypeAdapter(Type.class, (json, typeOfT, context) -> Type.getValue(json.getAsInt()));
        builder.registerTypeAdapter(State.class, (src, typeOfSrc, context) -> new JsonPrimitive((Number)src.getInt()));
        builder.registerTypeAdapter(State.class, (json, typeOfT, context) -> State.getValue(json.getAsInt()));
    }

    public String getId() {
        return this.networkId;
    }

    protected void internalOnMessageReceived(String message, long sourceNodeId) {
        if (null == this.messagingListener) {
            return;
        }
        this.messagingListener.onNewMessageReceived(message, sourceNodeId);
    }

    protected void internalOnContentInfoMessageReceived(String message, long sourceNodeId, int contentTime) {
        if (null == this.messagingListener) {
            return;
        }
        this.messagingListener.onContentInfoMessageReceived(message, sourceNodeId, contentTime);
    }

    protected void internalNodeConnectionStatusCallback(long nodeId, boolean isOnline) {
        if (null == this.messagingListener) {
            return;
        }
        this.messagingListener.onNodeConnectionStatusChanged(nodeId, isOnline);
    }

    protected void internalSetMetadata(String networkMetadata) {
        this.networkMetadata = networkMetadata;
    }

    protected void internalSetName(String networkName) {
        this.networkName = networkName;
    }

    protected void internalSetType(Type networkType) {
        this.networkType = networkType;
    }

    protected void internalSetStatus(State networkStatus) {
        this.networkStatus = networkStatus;
    }

    public String getMetadata() {
        return this.networkMetadata;
    }

    public String getName() {
        return this.networkName;
    }

    public Type getType() {
        return this.networkType;
    }

    public State getStatus() {
        return this.networkStatus;
    }

    public Role getUserRole() {
        return this.userRole;
    }

    public AccessType getAccessType() {
        return this.accessType;
    }

    public void setMessagingListener(MessagingListener listener) {
        this.messagingListener = listener;
    }

    public void sendMessage(String message, long ... destinationNodes) {
        CocoMediaClient.getInstance().getNativeHandler().sendMessage(this, message, destinationNodes);
    }

    public void sendContentInfoMessage(String message, int contentTime, long ... destinationNodes) {
        CocoMediaClient.getInstance().getNativeHandler().sendContentInfoMessage(this, message, contentTime, destinationNodes);
    }

    public void connect() {
        CocoMediaClient.getInstance().getNativeHandler().connect(this);
        if (State.CONNECTED != this.networkStatus && State.CONNECTING != this.networkStatus) {
            this.internalSetStatus(State.CONNECTING);
        }
    }

    public void disconnect() {
        CocoMediaClient.getInstance().getNativeHandler().disconnect(this);
    }

    public <V extends CommandResponse<CommandId>, U extends Command<CommandId, V>> void sendCommand(U command, CommandStatusListener<V> listener) {
        CocoMediaClient.getInstance().getNativeHandler().sendNetworkCommand(this, command, listener);
    }

    public String toString() {
        return "Network{networkName='" + this.networkName + '\'' + ", networkMetadata='" + this.networkMetadata + '\'' + ", networkType=" + (Object)((Object)this.networkType) + ", userRole=" + (Object)((Object)this.userRole) + ", accessType=" + (Object)((Object)this.accessType) + ", networkId='" + this.networkId + '\'' + ", messagingListener=" + this.messagingListener + ", networkStatus=" + (Object)((Object)this.networkStatus) + '}';
    }

    public static interface MessagingListener {
        public void onNodeConnectionStatusChanged(long var1, boolean var3);

        public void onNewMessageReceived(String var1, long var2);

        public void onContentInfoMessageReceived(String var1, long var2, int var4);
    }

    public static interface CommandStatusListener<T extends CommandResponse<CommandId>>
    extends Listener {
        public void onResponse(T var1, Throwable var2);
    }

    public static class GetAvailableChannelsResponse
    extends CommandResponse<CommandId> {
        @SerializedName(value="channelInfoArray")
        private final Channel[] channels;

        public GetAvailableChannelsResponse(Channel[] channels) {
            super(CommandId.GET_AVAILABLE_CHANNELS);
            this.channels = channels;
        }

        public Channel[] getChannels() {
            return this.channels;
        }

        @Override
        public String toString() {
            return "GetAvailableChannelsResponse{channels=" + Arrays.toString(this.channels) + "} " + super.toString();
        }
    }

    public static class GetAvailableChannels
    extends Command<CommandId, GetAvailableChannelsResponse> {
        public GetAvailableChannels() {
            super(CommandId.GET_AVAILABLE_CHANNELS, GetAvailableChannelsResponse.class);
        }
    }

    public static class DeleteChannelResponse
    extends CommandResponse<CommandId> {
        public DeleteChannelResponse() {
            super(CommandId.DELETE_CHANNEL);
        }
    }

    public static class DeleteChannel
    extends Command<CommandId, DeleteChannelResponse> {
        @SerializedName(value="channelID")
        private final int channelId;

        protected DeleteChannel(int channelId) {
            super(CommandId.DELETE_CHANNEL, DeleteChannelResponse.class);
            this.channelId = channelId;
        }

        @Override
        public String toString() {
            return "DeleteChannel{channelId=" + this.channelId + "} " + super.toString();
        }
    }

    public static class CreateChannelResponse
    extends CommandResponse<CommandId> {
        @SerializedName(value="channelID")
        private final int channelId;

        public CreateChannelResponse(int channelId) {
            super(CommandId.CREATE_CHANNEL);
            this.channelId = channelId;
        }

        public int getChannelId() {
            return this.channelId;
        }

        @Override
        public String toString() {
            return "CreateChannelResponse{channelId=" + this.channelId + "} " + super.toString();
        }
    }

    public static class CreateChannel
    extends Command<CommandId, CreateChannelResponse> {
        @SerializedName(value="channelName")
        private final String name;
        @SerializedName(value="metadata")
        private final String metadata;
        @SerializedName(value="maxStreams")
        private final int maxStreams;

        public CreateChannel(String name, String metadata, int maxStreams) {
            super(CommandId.CREATE_CHANNEL, CreateChannelResponse.class);
            this.name = name;
            this.metadata = metadata;
            this.maxStreams = maxStreams;
        }

        @Override
        public String toString() {
            return "CreateChannel{name='" + this.name + '\'' + ", metadata='" + this.metadata + '\'' + ", maxStreams=" + this.maxStreams + "} " + super.toString();
        }
    }

    public static enum CommandId implements CommandIdInterface
    {
        CREATE_CHANNEL,
        DELETE_CHANNEL,
        GET_AVAILABLE_CHANNELS;


        @Override
        public int getInt() {
            return this.ordinal();
        }
    }

    public static enum AccessType {
        LOCAL,
        REMOTE;


        int getInt() {
            return this.ordinal();
        }

        static AccessType getValue(int value) {
            return AccessType.values()[value];
        }
    }

    public static enum Role {
        OWNER,
        ADMIN,
        GUEST;


        int getInt() {
            return this.ordinal();
        }

        static Role getValue(int value) {
            return Role.values()[value];
        }
    }

    public static enum State {
        CONNECTED,
        CONNECTING,
        CONNECTION_ERROR,
        RESET,
        DISCONNECTED,
        BLOCKED,
        REMOTE_CONNECTED;


        int getInt() {
            return this.ordinal();
        }

        static State getValue(int value) {
            return State.values()[value];
        }
    }

    public static enum Type {
        IOT,
        MEDIA_NET,
        UNKNOWN;


        int getInt() {
            return this.ordinal();
        }

        static Type getValue(int value) {
            return Type.values()[value];
        }
    }
}

