/*
 * Decompiled with CFR 0.152.
 */
package buzz.getcoco.media;

import buzz.getcoco.media.Command;
import buzz.getcoco.media.CommandIdInterface;
import buzz.getcoco.media.CommandResponse;
import buzz.getcoco.media.DefaultNativeCallbacksHandler;
import buzz.getcoco.media.DefaultNativeHandler;
import buzz.getcoco.media.Listener;
import buzz.getcoco.media.NativeCallbacksInterface;
import buzz.getcoco.media.NativeInterface;
import buzz.getcoco.media.Network;
import buzz.getcoco.media.User;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonPrimitive;
import com.google.gson.annotations.SerializedName;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public class CocoMediaClient {
    private static CocoMediaClient instance;
    private final Gson gson;
    private final AuthListener authListener;
    private final NativeInterface nativeHandler;
    private final NativeCallbacksInterface callbackHandler;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private CocoMediaClient(AuthListener authListener, NativeInterface nativeHandler, NativeCallbacksInterface callbackHandler, String cwdPath, String appAccessList, String clientId, String downloadPath) {
        Class<CocoMediaClient> clazz = CocoMediaClient.class;
        synchronized (CocoMediaClient.class) {
            if (null != instance) {
                throw new IllegalArgumentException("CocoMediaClient already initialized");
            }
            instance = this;
            // ** MonitorExit[var8_8] (shouldn't be in output)
            GsonBuilder builder = new GsonBuilder();
            Command.init(builder);
            Network.init(builder);
            CocoMediaClient.init(builder);
            this.gson = builder.create();
            this.authListener = authListener;
            this.nativeHandler = nativeHandler;
            this.callbackHandler = callbackHandler;
            this.getNativeHandler().init(cwdPath, appAccessList, clientId, downloadPath);
            return;
        }
    }

    static void init(GsonBuilder builder) {
        builder.registerTypeAdapter(CommandId.class, (src, typeOfSrc, context) -> new JsonPrimitive((Number)src.getInt()));
    }

    NativeInterface getNativeHandler() {
        return this.nativeHandler;
    }

    AuthListener getAuthListener() {
        return this.authListener;
    }

    NativeCallbacksInterface getCallbackHandler() {
        return this.callbackHandler;
    }

    Gson getGson() {
        return this.gson;
    }

    public static CocoMediaClient getInstance() {
        return instance;
    }

    public void setTokens(String tokens) {
        this.getNativeHandler().setTokens(tokens);
    }

    public <V extends CommandResponse<CommandId>, U extends Command<CommandId, V>> void sendCommand(U command, CommandStatusListener<V> listener) {
        this.getNativeHandler().sendHttpCommand(command, listener);
    }

    public String toString() {
        return "CocoMediaClient{authListener=" + this.authListener + ", nativeHandler=" + this.nativeHandler + ", callbackHandler=" + this.callbackHandler + '}';
    }

    public static interface AuthListener {
        public void onAuthRequired(String var1, String var2);
    }

    public static interface CommandStatusListener<T extends CommandResponse<CommandId>>
    extends Listener {
        public void onResponse(T var1, Throwable var2);
    }

    public static class InviteExternalUserResponse
    extends CommandResponse<CommandId> {
        public InviteExternalUserResponse() {
            super(CommandId.INVITE_EXTERNAL_USER);
        }
    }

    public static class InviteExternalUser
    extends Command<CommandId, InviteExternalUserResponse> {
        @SerializedName(value="networkId")
        private final String networkId;
        @SerializedName(value="userId")
        private final String userId;

        public InviteExternalUser(String networkId, String userId) {
            super(CommandId.INVITE_EXTERNAL_USER, InviteExternalUserResponse.class);
            this.networkId = networkId;
            this.userId = userId;
        }

        @Override
        public String toString() {
            return "InviteExternalUser{networkId='" + this.networkId + '\'' + ", userId='" + this.userId + '\'' + "} " + super.toString();
        }
    }

    public static class InviteUserResponse
    extends CommandResponse<CommandId> {
        public InviteUserResponse() {
            super(CommandId.INVITE_USER);
        }
    }

    public static class InviteUser
    extends Command<CommandId, InviteUserResponse> {
        @SerializedName(value="networkId")
        private final String networkId;
        @SerializedName(value="email")
        private final String username;
        @SerializedName(value="role")
        private final Network.Role role;
        @SerializedName(value="accessType")
        private final Network.AccessType accessType;

        public InviteUser(String networkId, String username, Network.Role role, Network.AccessType accessType) {
            super(CommandId.INVITE_USER, InviteUserResponse.class);
            this.networkId = networkId;
            this.username = username;
            this.role = role;
            this.accessType = accessType;
        }

        @Override
        public String toString() {
            return "InviteUser{networkId='" + this.networkId + '\'' + ", username='" + this.username + '\'' + ", role=" + (Object)((Object)this.role) + ", accessType=" + (Object)((Object)this.accessType) + "} " + super.toString();
        }
    }

    public static class RemoveUserResponse
    extends CommandResponse<CommandId> {
        public RemoveUserResponse() {
            super(CommandId.REMOVE_USER);
        }
    }

    public static class RemoveUser
    extends Command<CommandId, RemoveUserResponse> {
        @SerializedName(value="networkId")
        private final String networkId;
        @SerializedName(value="userId")
        private final String userId;

        public RemoveUser(String networkId, String userId) {
            super(CommandId.REMOVE_USER, RemoveUserResponse.class);
            this.networkId = networkId;
            this.userId = userId;
        }

        @Override
        public String toString() {
            return "RemoveUser{networkId='" + this.networkId + '\'' + ", userId='" + this.userId + '\'' + "} " + super.toString();
        }
    }

    public static class GetUsersResponse
    extends CommandResponse<CommandId> {
        @SerializedName(value="networkUsers")
        private final ArrayList<User> users;

        public GetUsersResponse(ArrayList<User> users) {
            super(CommandId.GET_USERS);
            this.users = users;
        }

        public List<User> getUsers() {
            return this.users;
        }

        @Override
        public String toString() {
            return "GetUsersResponse{users=" + this.users + "} " + super.toString();
        }
    }

    public static class GetUsers
    extends Command<CommandId, GetUsersResponse> {
        @SerializedName(value="networkId")
        private final String networkId;

        public GetUsers(String networkId) {
            super(CommandId.GET_USERS, GetUsersResponse.class);
            this.networkId = networkId;
        }

        @Override
        public String toString() {
            return "GetUsers{networkId='" + this.networkId + '\'' + "} " + super.toString();
        }
    }

    public static class DeleteNetworkResponse
    extends CommandResponse<CommandId> {
        public DeleteNetworkResponse() {
            super(CommandId.DELETE_NETWORK);
        }
    }

    public static class DeleteNetwork
    extends Command<CommandId, DeleteNetworkResponse> {
        @SerializedName(value="networkId")
        private final String networkId;

        public DeleteNetwork(String networkId) {
            super(CommandId.DELETE_NETWORK, DeleteNetworkResponse.class);
            this.networkId = networkId;
        }

        @Override
        public String toString() {
            return "DeleteNetwork{networkId='" + this.networkId + '\'' + "} " + super.toString();
        }
    }

    public static class CreateNetworkResponse
    extends CommandResponse<CommandId> {
        @SerializedName(value="networkId")
        private final String networkId;

        public CreateNetworkResponse(String networkId) {
            super(CommandId.CREATE_NETWORK);
            this.networkId = networkId;
        }

        public String getNetworkId() {
            return this.networkId;
        }

        @Override
        public String toString() {
            return "CreateNetworkResponse{networkId='" + this.networkId + '\'' + "} " + super.toString();
        }
    }

    public static class CreateNetwork
    extends Command<CommandId, CreateNetworkResponse> {
        @SerializedName(value="metadata")
        private final String networkMetadata;
        @SerializedName(value="networkName")
        private final String networkName;
        @SerializedName(value="type")
        private final Network.Type networkType;

        public CreateNetwork(String networkName, String networkMetadata) {
            super(CommandId.CREATE_NETWORK, CreateNetworkResponse.class);
            this.networkMetadata = networkMetadata;
            this.networkName = networkName;
            this.networkType = Network.Type.MEDIA_NET;
        }

        @Override
        public String toString() {
            return "CreateNetwork{networkMetadata='" + this.networkMetadata + '\'' + ", networkName='" + this.networkName + '\'' + ", networkType=" + (Object)((Object)this.networkType) + "} " + super.toString();
        }
    }

    public static class GetAllNetworksResponse
    extends CommandResponse<CommandId> {
        @SerializedName(value="networks")
        private final ArrayList<Network> networks;

        public GetAllNetworksResponse(ArrayList<Network> networks) {
            super(CommandId.GET_ALL_NETWORKS);
            this.networks = networks;
        }

        public List<Network> getNetworks() {
            return this.networks;
        }

        @Override
        public String toString() {
            return "GetAllNetworksResponse{networks=" + this.networks + "} " + super.toString();
        }
    }

    public static class GetAllNetworks
    extends Command<CommandId, GetAllNetworksResponse> {
        public GetAllNetworks() {
            super(CommandId.GET_ALL_NETWORKS, GetAllNetworksResponse.class);
        }
    }

    public static enum CommandId implements CommandIdInterface
    {
        GET_ALL_NETWORKS,
        CREATE_NETWORK,
        DELETE_NETWORK,
        GET_USERS,
        REMOVE_USER,
        INVITE_USER,
        INVITE_EXTERNAL_USER;


        @Override
        public int getInt() {
            return this.ordinal();
        }
    }

    public static final class Configurator {
        private AuthListener authListener;
        private NativeInterface nativeHandler;
        private NativeCallbacksInterface callbackHandler;
        private String cwdPath;
        private String appAccessList;
        private String clientId;
        private String downloadPath;

        public Configurator setCurrentWorkingDirectory(String cwdPath) {
            this.cwdPath = cwdPath;
            return this;
        }

        public Configurator setAppAccessList(String appAccessList) {
            this.appAccessList = appAccessList;
            return this;
        }

        public Configurator setClientId(String clientId) {
            this.clientId = clientId;
            return this;
        }

        public Configurator setDownloadDirectory(String downloadPath) {
            this.downloadPath = downloadPath;
            return this;
        }

        public Configurator setHandler(NativeInterface nativeHandler) {
            this.nativeHandler = nativeHandler;
            return this;
        }

        public Configurator setCallbackHandler(NativeCallbacksInterface callbackHandler) {
            this.callbackHandler = callbackHandler;
            return this;
        }

        public Configurator setAuthListener(AuthListener authListener) {
            this.authListener = authListener;
            return this;
        }

        public synchronized CocoMediaClient configure() {
            Objects.requireNonNull(this.authListener);
            Objects.requireNonNull(this.cwdPath);
            Objects.requireNonNull(this.clientId);
            if (null == this.appAccessList) {
                this.appAccessList = "{\"appCapabilities\": [0]}";
            }
            if (null == this.downloadPath) {
                this.downloadPath = this.cwdPath;
            }
            if (null == this.nativeHandler) {
                this.nativeHandler = new DefaultNativeHandler();
            }
            if (null == this.callbackHandler) {
                this.callbackHandler = new DefaultNativeCallbacksHandler();
            }
            return new CocoMediaClient(this.authListener, this.nativeHandler, this.callbackHandler, this.cwdPath, this.appAccessList, this.clientId, this.downloadPath);
        }

        public String toString() {
            return "Configurator{authListener=" + this.authListener + ", nativeHandler=" + this.nativeHandler + ", callbackHandler=" + this.callbackHandler + ", cwdPath='" + this.cwdPath + '\'' + ", appAccessList='" + this.appAccessList + '\'' + ", clientId='" + this.clientId + '\'' + ", downloadPath='" + this.downloadPath + '\'' + '}';
        }
    }
}

